/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.internal.providers.resources.root.AbstractSingleValueGetPropertyProvider;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PackageReadOnlyProvider
extends AbstractSingleValueGetPropertyProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        return UniqueNameUtil.isResourceUin(element.getUniqueName());
    }

    protected String getPropertyName() {
        return "$readOnly";
    }

    public String getPropertyValue(Element element, String propertyName) {
        IRootRelativePath rootRelativePath = this.getRootManager().extractRootRelativePath(element.getUniqueName());
        if (rootRelativePath == null) {
            return null;
        }
        IProjectRelativePath[] projectRelativePaths = this.getRootManager().projectRelativePath(rootRelativePath);
        if (projectRelativePaths == null || projectRelativePaths.length == 0) {
            return null;
        }
        boolean result = false;
        int i = 0;
        while (!result && i < projectRelativePaths.length) {
            result = PackageReadOnlyProvider.isContainsReadOblyFile(this.getProject(), projectRelativePaths[i]);
            ++i;
        }
        return result ? Boolean.TRUE.toString() : null;
    }

    private static boolean isContainsReadOblyFile(IProject project, IProjectRelativePath relativePath) {
        IProject baseContainer = relativePath.isEmpty() ? project : project.getFolder((IPath)relativePath);
        return baseContainer != null && baseContainer.exists() && PackageReadOnlyProvider.isContainsReadOblyFile((IContainer)baseContainer);
    }

    private static boolean isContainsReadOblyFile(IContainer container) {
        try {
            if (container.isReadOnly()) {
                return true;
            }
            IResource[] allMembers = container.members();
            LinkedList<IResource> subFolders = null;
            boolean result = false;
            int i = 0;
            while (!result && i < allMembers.length) {
                IResource next = allMembers[i];
                if (next instanceof IContainer) {
                    if (subFolders == null) {
                        subFolders = new LinkedList<IResource>();
                    }
                    subFolders.add(next);
                } else if (next instanceof IFile) {
                    result = next.isReadOnly();
                }
                ++i;
            }
            if (!result && subFolders != null) {
                Iterator subIt = subFolders.iterator();
                while (!result && subIt.hasNext()) {
                    IContainer nextSub = (IContainer)subIt.next();
                    result = PackageReadOnlyProvider.isContainsReadOblyFile(nextSub);
                }
            }
            return result;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }
}

