/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.internal.providers.resources.root.AbstractResourceProvider;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IRootRelativePath;

public class PackageExistenceProvider
extends AbstractResourceProvider
implements EntityExistenceProvider {
    public boolean exists(UniqueName uniqueName) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        if (UniqueNameUtil.isResourceUin(uniqueName)) {
            IRootRelativePath rootRelativePath = UniqueNameUtil.getRootRelativePath(uniqueName);
            return this.getRootManager().projectRelativePath(rootRelativePath).length > 0;
        }
        return false;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        return "Package".equals(shapeType) && UniqueNameUtil.getRootRelativePath(parent) != null;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IRootRelativePath parentPath = UniqueNameUtil.getRootRelativePath(parent);
        String namePrefix = null;
        if (template != null && template.hasProperty("$name")) {
            namePrefix = template.getPropertyValue("$name");
        }
        IRootRelativePath childPath = this.getRootManager().create(parentPath, namePrefix);
        return UniqueNameUtil.createResourceUin(childPath);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        return this.exists(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        return !element.hasProperty("$readOnly");
    }

    public void delete(Element element) {
        IRootRelativePath rootRelativePath = UniqueNameUtil.getRootRelativePath(element.getUniqueName());
        this.getRootManager().delete(rootRelativePath);
    }

    public boolean isDeleted(Element element) {
        return false;
    }
}

