/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.internal.providers.resources.delta.AbstractModelDeltaNodeAdapter;
import com.tssap.selena.model.internal.providers.resources.delta.IDeltaBuilderListener;
import com.tssap.selena.model.internal.providers.resources.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.internal.providers.resources.root.AbstractResourceProvider;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

public class PackageDeltaProvider
extends AbstractResourceProvider
implements DeltaTreeProvider,
IDeltaBuilderListener {
    private RegularPackageDelta myCollectedDelta;
    private AddedPackagesInfo myAddedPackagesInfo = new AddedPackagesInfo();

    public void registered(Model model) {
        super.registered(model);
        if (this.isDisposedInCurrentModel()) {
            return;
        }
        this.getRootManager().getDeltaBuilder().setDeltaBuilderListener(this);
        this.getRootManager().reloadAllRoots();
    }

    public void unregistered(Model model) {
        if (!this.isDisposedInCurrentModel()) {
            this.getRootManager().getDeltaBuilder().removeDeltaBuilderListener(this);
        }
        super.unregistered(model);
    }

    public ModelDeltaNode getModelChanges() {
        if (this.isDisposedInCurrentModel()) {
            return null;
        }
        RegularPackageDelta result = this.myCollectedDelta;
        this.myCollectedDelta = null;
        return result;
    }

    public void resourceUpdateStarted() {
        if (this.isDisposedInCurrentModel()) {
            return;
        }
        if (this.myCollectedDelta == null) {
            this.myCollectedDelta = new RegularPackageDelta(this.getModel(), this.getModel().getUniqueName());
        }
    }

    public void resourceUpdateFinished() {
        if (this.isDisposedInCurrentModel()) {
            return;
        }
        this.processAddedPathes();
        if (this.myCollectedDelta != null && !this.myCollectedDelta.isEmpty() && this.getModel() != null) {
            this.getModel().getExtensionManager().modelContentsChanged();
        }
    }

    private void processAddedPathes() {
        Iterator addedRootPathes = this.myAddedPackagesInfo.addedRootPathes().iterator();
        while (addedRootPathes.hasNext()) {
            IRootRelativePath curRootRelative = (IRootRelativePath)addedRootPathes.next();
            Set addedProjectPathes = this.myAddedPackagesInfo.addedProjectPathes(curRootRelative);
            IProjectRelativePath[] existsProjectPathes = this.getRootManager().projectRelativePath(curRootRelative);
            if (existsProjectPathes.length > addedProjectPathes.size()) continue;
            UniqueName uin = UniqueNameUtil.createResourceUin(curRootRelative);
            RegularPackageDelta deltaNode = new RegularPackageDelta(this.getModel(), uin);
            deltaNode.setKind(ModelDeltaNodeKind.ADDED);
            this.myCollectedDelta.addDeepChild(curRootRelative, deltaNode);
        }
        this.myAddedPackagesInfo.clear();
    }

    private boolean existsUnderOtherRoots(IProjectRelativePath path) {
        IRootRelativePath rootRelativePath = this.getRootManager().rootRelativePath(path);
        IProjectRelativePath[] underAllRoots = this.getRootManager().projectRelativePath(rootRelativePath);
        int i = 0;
        while (i < underAllRoots.length) {
            if (!underAllRoots[i].equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void packageAdded(IProjectRelativePath path) {
        if (this.isDisposedInCurrentModel()) {
            return;
        }
        IRootRelativePath rootRelativePath = this.getRootManager().rootRelativePath(path);
        if (rootRelativePath != null && !rootRelativePath.isEmpty()) {
            this.myAddedPackagesInfo.packageAdded(rootRelativePath, path);
            return;
        }
    }

    public void packageRemoved(IProjectRelativePath path) {
        if (this.isDisposedInCurrentModel()) {
            return;
        }
        IRootRelativePath rootRelativePath = this.getRootManager().rootRelativePath(path);
        if (rootRelativePath != null) {
            if (this.existsUnderOtherRoots(path)) {
                return;
            }
            UniqueName uin = UniqueNameUtil.createResourceUin(rootRelativePath);
            RegularPackageDelta deltaNode = new RegularPackageDelta(this.getModel(), uin);
            deltaNode.setKind(ModelDeltaNodeKind.DELETED);
            this.myCollectedDelta.addDeepChild(rootRelativePath, deltaNode);
        }
    }

    public void packageMoved(IProjectRelativePath before, IProjectRelativePath now) {
        if (this.isDisposedInCurrentModel()) {
            return;
        }
        IRootRelativePath rootRelativePathBefore = this.getRootManager().rootRelativePath(before);
        if (rootRelativePathBefore == null) {
            this.packageAdded(now);
            return;
        }
        IProjectRelativePath[] underOtherRootsBefore = this.getRootManager().projectRelativePath(rootRelativePathBefore);
        if (underOtherRootsBefore.length > 0) {
            this.packageAdded(now);
            return;
        }
        UniqueName oldUin = UniqueNameUtil.createResourceUin(rootRelativePathBefore);
        IRootRelativePath rootRelativePathNow = this.getRootManager().rootRelativePath(now);
        if (rootRelativePathNow != null) {
            UniqueName newUin = UniqueNameUtil.createResourceUin(rootRelativePathNow);
            MovedPackageDelta movedToDeltaNode = new MovedPackageDelta(this.getModel(), oldUin, newUin, false);
            this.myCollectedDelta.addDeepChild(rootRelativePathNow, movedToDeltaNode);
            MovedPackageDelta movedFromDeltaNode = new MovedPackageDelta(this.getModel(), newUin, oldUin, true);
            this.myCollectedDelta.addDeepChild(rootRelativePathBefore, movedFromDeltaNode);
        } else {
            RegularPackageDelta deletedDeltaNode = new RegularPackageDelta(this.getModel(), oldUin);
            deletedDeltaNode.setKind(ModelDeltaNodeKind.DELETED);
            this.myCollectedDelta.addDeepChild(rootRelativePathBefore, deletedDeltaNode);
        }
    }

    private static class AddedPackagesInfo {
        private HashMap myAddedPathes;

        private AddedPackagesInfo() {
        }

        public void packageAdded(IRootRelativePath relativePath, IProjectRelativePath projectRelativePath) {
            HashSet<IProjectRelativePath> projectPathes;
            if (this.myAddedPathes == null) {
                this.myAddedPathes = new HashMap();
            }
            if ((projectPathes = (HashSet<IProjectRelativePath>)this.myAddedPathes.get(relativePath)) == null) {
                projectPathes = new HashSet<IProjectRelativePath>();
                this.myAddedPathes.put(relativePath, projectPathes);
            }
            projectPathes.add(projectRelativePath);
        }

        public Set addedRootPathes() {
            if (this.myAddedPathes == null) {
                return Collections.EMPTY_SET;
            }
            return this.myAddedPathes.keySet();
        }

        public Set addedProjectPathes(IRootRelativePath rootRelativePath) {
            if (this.myAddedPathes == null) {
                return Collections.EMPTY_SET;
            }
            Set projectPathes = (Set)this.myAddedPathes.get(rootRelativePath);
            if (projectPathes == null) {
                return Collections.EMPTY_SET;
            }
            return projectPathes;
        }

        public void clear() {
            this.myAddedPathes = null;
        }
    }

    private static class MovedPackageDelta
    implements ModelDeltaNode {
        private boolean myReversed;
        private Model myModel;
        private UniqueName myOldUin;
        private UniqueName myNewUin;

        public MovedPackageDelta(Model model, UniqueName oldUin, UniqueName newUin, boolean reversed) {
            Assert.isLegal((oldUin != null ? 1 : 0) != 0);
            Assert.isLegal((newUin != null ? 1 : 0) != 0);
            this.myModel = model;
            this.myOldUin = oldUin;
            this.myNewUin = newUin;
            this.myReversed = reversed;
        }

        public Enumeration changedChildren() {
            return EmptyEnumeration.getEnumeration();
        }

        public Element getElement() {
            return this.myModel.findElement(this.getElementUniqueName());
        }

        public UniqueName getElementUniqueName() {
            return this.myNewUin;
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myOldUin;
        }

        public boolean isNew() {
            return !this.myReversed;
        }

        public boolean isChanged() {
            return false;
        }

        public boolean isTotallyChanged() {
            return false;
        }

        public boolean isDeleted() {
            return this.myReversed;
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private static class RegularPackageDelta
    extends AbstractModelDeltaNodeAdapter {
        private HashMap myChildren = new HashMap();
        private UniqueName myUin;

        public RegularPackageDelta(Model model, UniqueName uin) {
            super(model, ModelDeltaNodeKind.CONNECTION);
            this.myUin = uin;
        }

        public void addDeepChild(IRootRelativePath rootRelativePath, ModelDeltaNode deepDeltaNode) {
            Assert.isLegal((deepDeltaNode.isNew() || deepDeltaNode.isDeleted() ? 1 : 0) != 0);
            if (rootRelativePath == null || rootRelativePath.isEmpty()) {
                this.setKind(ModelDeltaNodeKind.TOTALLY_CHANGED);
                return;
            }
            String key = rootRelativePath.segment(0);
            IPath nextLevelPath = rootRelativePath.removeFirstSegments(1);
            if (nextLevelPath.isEmpty()) {
                if (this.myChildren.get(key) instanceof MovedPackageDelta) {
                    return;
                }
                this.myChildren.put(key, deepDeltaNode);
            } else {
                RegularPackageDelta nextLevelNode = (RegularPackageDelta)this.myChildren.get(key);
                if (nextLevelNode == null) {
                    UniqueName nextLevelNodeUin = this.createChildUin(key);
                    nextLevelNode = new RegularPackageDelta(this.getModel(), nextLevelNodeUin);
                    this.myChildren.put(key, nextLevelNode);
                }
                if (nextLevelNode.getKind() != ModelDeltaNodeKind.CONNECTION) {
                    return;
                }
                nextLevelNode.addDeepChild(RootRelativePath.valueOf(nextLevelPath), deepDeltaNode);
            }
        }

        public Enumeration changedChildren() {
            LinkedList result = new LinkedList(this.myChildren.values());
            return Collections.enumeration(result);
        }

        public Element getElement() {
            return this.getModel().findElement(this.getElementUniqueName());
        }

        public UniqueName getElementUniqueName() {
            return this.myUin;
        }

        public boolean isEmpty() {
            return this.myChildren.isEmpty();
        }

        private UniqueName createChildUin(String childName) {
            if (this.myUin.equals(this.getModel().getUniqueName())) {
                return UniqueNameUtil.createResourceUin(RootRelativePath.valueOf(childName));
            }
            IRootRelativePath pathToThis = UniqueNameUtil.getRootRelativePath(this.myUin);
            RootRelativePath pathToChild = RootRelativePath.valueOf(pathToThis.append(childName));
            return UniqueNameUtil.createResourceUin(pathToChild);
        }
    }
}

