/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.PasteProvider;
import com.tssap.selena.model.internal.providers.resources.root.AbstractResourceProvider;
import com.tssap.selena.model.internal.providers.resources.root.CompositePackageContentsInfo;
import com.tssap.selena.model.internal.providers.resources.root.IPackageContentsInfo;
import com.tssap.selena.model.internal.providers.resources.root.RootManagerImpl;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import java.util.HashMap;

public class PackageCopyPasteProvider
extends AbstractResourceProvider
implements CopyProvider,
PasteProvider,
CutProvider,
EntityExistenceProvider {
    private HashMap myClipboard;

    public boolean isCopyProviderApplicable(Element element) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        return element instanceof Entity && UniqueNameUtil.isResourceUin(element.getUniqueName()) && "Package".equals(element.getPropertyValue("$metaclass"));
    }

    public boolean canCopy(Element element) {
        RootManagerImpl rootManager = this.getRootManager();
        IRootRelativePath rootRelativePath = UniqueNameUtil.getRootRelativePath(element.getUniqueName());
        if (rootRelativePath == null || rootRelativePath.isEmpty()) {
            return false;
        }
        IProjectRelativePath[] projectPathes = rootManager.projectRelativePath(rootRelativePath);
        if (projectPathes.length == 0) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (result && i < projectPathes.length) {
            IProjectRelativePath curPath = projectPathes[i];
            IRootProvider[] providers = rootManager.providers(curPath);
            int p = 0;
            while (result && p < providers.length) {
                IRootProvider curProvider = providers[p];
                if (curProvider.isValidFolder(curPath)) {
                    result = curProvider.getCopyPaster().canCopy(curPath);
                }
                ++p;
            }
            ++i;
        }
        return result;
    }

    public void copy(Element element, CopyUniqueName copyUniqueName) {
        this.naiveCopy(element, copyUniqueName, false);
    }

    private void naiveCopy(Element element, CopyUniqueName copyUniqueName, boolean cut) {
        RootManagerImpl rootManager = this.getRootManager();
        IRootRelativePath rootRelativePath = UniqueNameUtil.getRootRelativePath((Entity)element);
        CompositePackageContentsInfo info = new CompositePackageContentsInfo(rootManager, rootRelativePath, (Entity)element, cut);
        this.myClipboard.put(copyUniqueName, info);
    }

    public boolean isPasteProviderApplicable(Entity container) {
        if (this.isDisposedInCurrentModel() || this.myClipboard.isEmpty()) {
            return false;
        }
        return container instanceof Model || UniqueNameUtil.isResourceUin(container.getUniqueName());
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        IPackageContentsInfo info = (IPackageContentsInfo)this.myClipboard.get(element.getUniqueName());
        if (info == null) {
            return false;
        }
        RootManagerImpl rootManager = this.getRootManager();
        IRootRelativePath containerPath = UniqueNameUtil.getRootRelativePath(container.getUniqueName());
        return info.canPaste(containerPath);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        HashMap substitutionMap;
        IPackageContentsInfo info = (IPackageContentsInfo)this.myClipboard.get(element.getUniqueName());
        RootManagerImpl rootManager = this.getRootManager();
        IRootRelativePath containerPath = UniqueNameUtil.getRootRelativePath(container);
        IRootRelativePath result = info.paste(containerPath, substitutionMap = new HashMap(50));
        return result == null ? null : rootManager.getUniqueName(result);
    }

    public boolean isCutProviderApplicable(Element element) {
        return this.isCopyProviderApplicable(element);
    }

    public boolean canCut(Element element) {
        return this.canCopy(element) && element.canDelete();
    }

    public void cut(Element element, CopyUniqueName cutUniqueName) {
        this.naiveCopy(element, cutUniqueName, true);
        element.delete();
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboard = new HashMap();
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myClipboard.clear();
        this.myClipboard = null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return true;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        IPackageContentsInfo info = (IPackageContentsInfo)this.myClipboard.remove(element.getUniqueName());
        info.dispose();
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName instanceof CopyUniqueName && this.myClipboard.containsKey(uniqueName);
    }
}

