/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.internal.providers.resources.root.IPackageContentsInfo;
import com.tssap.selena.model.internal.providers.resources.root.RootManagerImpl;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootCopyPaster;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class PackageContentsInfo
implements IPackageContentsInfo {
    private RootManagerImpl myRootManager;
    private IRootRelativePath myRootRelativePath;
    private HashMap myPerProviderContents;
    private String myOriginalName;
    private IRootRelativePath myIntermediateResult;

    protected PackageContentsInfo(RootManagerImpl rootManager, IRootRelativePath rootRelativePath, Entity modelPackage, boolean cut) {
        this.myRootManager = rootManager;
        this.myRootRelativePath = rootRelativePath;
        this.myOriginalName = modelPackage.getPropertyValue("$name");
        this.myPerProviderContents = new HashMap(5);
        IProjectRelativePath[] projectPathes = rootManager.projectRelativePath(rootRelativePath);
        int i = 0;
        while (i < projectPathes.length) {
            IProjectRelativePath curPath = projectPathes[i];
            IRootProvider[] providers = rootManager.providers(curPath);
            int p = 0;
            while (p < providers.length) {
                IRootProvider curProvider = providers[p];
                if (cut) {
                    curProvider.getCopyPaster().cut(curPath);
                } else {
                    curProvider.getCopyPaster().copy(curPath);
                }
                this.add(curPath, curProvider);
                ++p;
            }
            ++i;
        }
    }

    public IRootRelativePath getIntermediateResult() {
        return this.myIntermediateResult;
    }

    public void dispose() {
        Iterator entries = this.myPerProviderContents.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            IRootProvider curProvider = (IRootProvider)curEntry.getKey();
            IProjectRelativePath curPath = (IProjectRelativePath)curEntry.getValue();
            curProvider.getCopyPaster().disposeCopy(curPath);
        }
        this.myIntermediateResult = null;
    }

    public boolean canPaste(IRootRelativePath containerPath) {
        boolean result = true;
        Iterator entries = this.myPerProviderContents.entrySet().iterator();
        while (result && entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            IRootProvider curProvider = (IRootProvider)curEntry.getKey();
            IProjectRelativePath curFromPath = (IProjectRelativePath)curEntry.getValue();
            ProjectRelativePath curDestPath = ProjectRelativePath.valueOf(curProvider.getRootPath().append((IPath)containerPath));
            result = curProvider.getCopyPaster().canPaste(curFromPath, curDestPath);
        }
        return result;
    }

    public void pasteBase(final IRootRelativePath containerPath, final Map substitutionMap) {
        final Runnable command = new Runnable(){

            public void run() {
                PackageContentsInfo.this.myIntermediateResult = PackageContentsInfo.this.myRootManager.create(containerPath, PackageContentsInfo.this.myOriginalName);
                if (PackageContentsInfo.this.myIntermediateResult != null) {
                    try {
                        PackageContentsInfo.this.commonPaste(PasteStage.PASTE_BASE, containerPath, PackageContentsInfo.this.myIntermediateResult, substitutionMap);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        PackageContentsInfo.this.myIntermediateResult = null;
                    }
                }
            }
        };
        IWorkspaceRunnable workspaceCommand = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ModelAccess.runCommand((Runnable)command);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(workspaceCommand, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.myIntermediateResult = null;
        }
    }

    public void pasteDerived(IRootRelativePath containerPath, Map substitutionMap) {
        try {
            this.commonPaste(PasteStage.PASTE_DERIVED, containerPath, this.myIntermediateResult, substitutionMap);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void pasteTertiary(IRootRelativePath containerPath, Map substitutionMap) {
        try {
            this.commonPaste(PasteStage.PASTE_TERTIARY, containerPath, this.myIntermediateResult, substitutionMap);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void commonPaste(final PasteStage stage, IRootRelativePath containerPath, final IRootRelativePath justPastedPath, final Map substitutionMap) throws CoreException {
        final Runnable command = new Runnable(){

            public void run() {
                Map.Entry designRootEntry = null;
                Iterator entries = PackageContentsInfo.this.myPerProviderContents.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry curEntry = entries.next();
                    IRootProvider curProvider = (IRootProvider)curEntry.getKey();
                    if ("com.tssap.selena.design_root".equals(curProvider.getID())) {
                        designRootEntry = curEntry;
                        continue;
                    }
                    IProjectRelativePath curFromPath = (IProjectRelativePath)curEntry.getValue();
                    ProjectRelativePath curPastedProjectPath = ProjectRelativePath.valueOf(curProvider.getRootPath().append((IPath)justPastedPath));
                    if (!curProvider.isValidFolder(curPastedProjectPath)) continue;
                    PackageContentsInfo.dynamicInvoke(curProvider.getCopyPaster(), stage, curFromPath, curPastedProjectPath, substitutionMap);
                }
                if (designRootEntry != null) {
                    IRootProvider curProvider = (IRootProvider)designRootEntry.getKey();
                    IProjectRelativePath curFromPath = (IProjectRelativePath)designRootEntry.getValue();
                    ProjectRelativePath curPastedProjectPath = ProjectRelativePath.valueOf(curProvider.getRootPath().append((IPath)justPastedPath));
                    if (curProvider.isValidFolder(curPastedProjectPath)) {
                        PackageContentsInfo.dynamicInvoke(curProvider.getCopyPaster(), stage, curFromPath, curPastedProjectPath, substitutionMap);
                    }
                }
            }
        };
        IWorkspaceRunnable workspaceCommand = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ModelAccess.runCommand((Runnable)command);
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceCommand, (IProgressMonitor)new NullProgressMonitor());
    }

    private void add(IProjectRelativePath projectRelativePath, IRootProvider provider) {
        this.myPerProviderContents.put(provider, projectRelativePath);
    }

    private static void dynamicInvoke(IRootCopyPaster copyPaster, PasteStage pasteStage, IProjectRelativePath from, IProjectRelativePath dest, Map subsMap) {
        Assert.isLegal((copyPaster != null && pasteStage != null ? 1 : 0) != 0);
        if (pasteStage == PasteStage.PASTE_BASE) {
            copyPaster.pasteBase(from, dest, subsMap);
            return;
        }
        if (pasteStage == PasteStage.PASTE_DERIVED) {
            copyPaster.pasteDerived(from, dest, subsMap);
            return;
        }
        if (pasteStage == PasteStage.PASTE_TERTIARY) {
            copyPaster.pasteTertiary(from, dest, subsMap);
            return;
        }
    }

    public abstract IRootRelativePath paste(IRootRelativePath var1, Map var2);

    private static final class PasteStage {
        public static final PasteStage PASTE_BASE = new PasteStage();
        public static final PasteStage PASTE_DERIVED = new PasteStage();
        public static final PasteStage PASTE_TERTIARY = new PasteStage();

        private PasteStage() {
        }
    }
}

