/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.internal.providers.resources.root.AbstractResourceProvider;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PackageChildrenProvider
extends AbstractResourceProvider
implements ChildrenProvider {
    public boolean isChildrenProviderApplicable(Entity parent) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        return UniqueNameUtil.getRootRelativePath(parent) != null;
    }

    public UniqueNameEnumeration children(Entity parent) {
        HashSet<UniqueName> result = new HashSet<UniqueName>();
        IProjectRelativePath[] parentPathes = this.getRootManager().projectRelativePath(UniqueNameUtil.getRootRelativePath(parent));
        int i = 0;
        while (i < parentPathes.length) {
            block7: {
                IProjectRelativePath curPath = parentPathes[i];
                IResource curResource = this.getProject().findMember((IPath)curPath);
                if (curResource instanceof IContainer) {
                    IResource[] members;
                    try {
                        members = ((IContainer)curResource).members();
                    }
                    catch (CoreException noMembers) {
                        System.err.println("can not access memebers for: " + curPath + " \n" + (Object)((Object)noMembers));
                        break block7;
                    }
                    int j = 0;
                    while (j < members.length) {
                        if (members[j] instanceof IContainer && members[j].exists()) {
                            ProjectRelativePath curMemberPath = ProjectRelativePath.valueOf(members[j].getProjectRelativePath());
                            IRootRelativePath curRootRelativePath = this.getRootManager().rootRelativePath(curMemberPath);
                            if (curRootRelativePath != null && !curRootRelativePath.isEmpty()) {
                                result.add(UniqueNameUtil.createResourceUin(curRootRelativePath));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(result.iterator());
    }
}

