/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.preferences.PreferencesPlugin;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class IgnoreFoldersSupport
implements IPropertyChangeListener {
    private HashSet myValues = new HashSet();
    private static final IPreferenceStore ourWorkpacePreferenceStore = PreferencesPlugin.getPreferenceStore((String)"workspace", null);
    private static IgnoreFoldersSupport ourInstance;
    private static final String DELIMITER = ",";

    public static IgnoreFoldersSupport getInstance() {
        if (ourInstance == null) {
            ourInstance = new IgnoreFoldersSupport();
        }
        return ourInstance;
    }

    private IgnoreFoldersSupport() {
        ourWorkpacePreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.loadIgnoreFolders();
    }

    public boolean isPathIgnored(IProjectRelativePath projectRelativePath) {
        if (projectRelativePath.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < projectRelativePath.segmentCount()) {
            if (this.myValues.contains(projectRelativePath.segment(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("ignored_folders".equals(event.getProperty())) {
            this.loadIgnoreFolders();
        }
    }

    private void loadIgnoreFolders() {
        String value = ourWorkpacePreferenceStore.getString("ignored_folders");
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, DELIMITER);
            while (st.hasMoreElements()) {
                String s = st.nextToken().trim();
                this.myValues.add(s);
            }
        }
    }
}

