/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.internal.providers.resources.root.AbstractResourceProvider;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.HashSet;

public class FilePropertyProvider
extends AbstractResourceProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (this.isDisposedInCurrentModel()) {
            return false;
        }
        return element instanceof Entity && UniqueNameUtil.getRootRelativePath((Entity)element) != null;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        IRootRelativePath rootRelativePath = UniqueNameUtil.getRootRelativePath((Entity)element);
        IProjectRelativePath[] projectRelativePaths = this.getRootManager().projectRelativePath(rootRelativePath);
        HashSet<String> stringResults = new HashSet<String>();
        HashSet<PropertyAdapter> realResults = new HashSet<PropertyAdapter>();
        int i = 0;
        while (i < projectRelativePaths.length) {
            String cur = projectRelativePaths[i].toString();
            if (!stringResults.contains(cur)) {
                stringResults.add(cur);
                realResults.add(new PropertyAdapter(propertyName, cur, element));
            }
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(realResults.iterator());
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$file");
    }

    public Property getProperty(Element element, String propertyName) {
        PropertyEnumeration all = this.properties(element, propertyName);
        return all.hasMoreElements() ? (Property)all.nextElement() : null;
    }

    public String getPropertyValue(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        return property == null ? null : property.getValue();
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.properties(element, propertyName).hasMoreElements();
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        IRootRelativePath rootRelativePath = UniqueNameUtil.getRootRelativePath((Entity)element);
        IProjectRelativePath[] projectRelativePaths = this.getRootManager().projectRelativePath(rootRelativePath);
        int i = 0;
        while (i < projectRelativePaths.length) {
            if (propertyValue.equals(projectRelativePaths[i].toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

