/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.internal.providers.resources.root.IPackageContentsInfo;
import com.tssap.selena.model.internal.providers.resources.root.PackageContentsInfo;
import com.tssap.selena.model.internal.providers.resources.root.RootManagerImpl;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CompositePackageContentsInfo
extends PackageContentsInfo
implements IPackageContentsInfo {
    private LinkedList myChildInfos = new LinkedList();

    public CompositePackageContentsInfo(RootManagerImpl rootManager, IRootRelativePath rootRelativePath, Entity modelPackage, boolean cut) {
        super(rootManager, rootRelativePath, modelPackage, cut);
        EntityEnumeration children = modelPackage.childEntities();
        while (children.hasMoreElements()) {
            IRootRelativePath curRootRelativePath;
            Entity curChild = children.next();
            if (!UniqueNameUtil.isResourceUin(curChild.getUniqueName()) || !"Package".equals(curChild.getPropertyValue("$metaclass")) || (curRootRelativePath = rootManager.extractRootRelativePath(curChild.getUniqueName())) == null) continue;
            this.myChildInfos.add(new CompositePackageContentsInfo(rootManager, curRootRelativePath, curChild, cut));
        }
    }

    public void dispose() {
        Iterator children = this.myChildInfos.iterator();
        while (children.hasNext()) {
            ((CompositePackageContentsInfo)children.next()).dispose();
        }
        super.dispose();
    }

    public void pasteBase(IRootRelativePath containerPath, Map substitutionMap) {
        super.pasteBase(containerPath, substitutionMap);
        if (this.getIntermediateResult() != null) {
            Iterator children = this.myChildInfos.iterator();
            while (children.hasNext()) {
                ((CompositePackageContentsInfo)children.next()).pasteBase(this.getIntermediateResult(), substitutionMap);
            }
        }
    }

    public void pasteDerived(IRootRelativePath containerPath, Map substitutionMap) {
        if (this.getIntermediateResult() != null) {
            super.pasteDerived(containerPath, substitutionMap);
            Iterator children = this.myChildInfos.iterator();
            while (children.hasNext()) {
                ((CompositePackageContentsInfo)children.next()).pasteDerived(this.getIntermediateResult(), substitutionMap);
            }
        }
    }

    public void pasteTertiary(IRootRelativePath containerPath, Map substitutionMap) {
        if (this.getIntermediateResult() != null) {
            super.pasteTertiary(containerPath, substitutionMap);
            Iterator children = this.myChildInfos.iterator();
            while (children.hasNext()) {
                ((CompositePackageContentsInfo)children.next()).pasteTertiary(this.getIntermediateResult(), substitutionMap);
            }
        }
    }

    public IRootRelativePath paste(IRootRelativePath containerPath, Map substitutionMap) {
        this.pasteBase(containerPath, substitutionMap);
        if (this.getIntermediateResult() != null) {
            this.pasteDerived(containerPath, substitutionMap);
            this.pasteTertiary(containerPath, substitutionMap);
        }
        return this.getIntermediateResult();
    }
}

