/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.root;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.Provider;
import com.tssap.selena.model.internal.providers.resources.root.RootManagerImpl;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;

public class AbstractResourceProvider
implements ModelAware,
Provider {
    private Model myModel;
    private boolean myIsProjectModelFlag;
    private IProject myProject;

    public void registered(Model model) {
        Assert.isLegal((model != null ? 1 : 0) != 0);
        this.myModel = model;
        this.initProject();
    }

    public void unregistered(Model model) {
        Assert.isLegal((boolean)model.equals(this.myModel));
        this.myModel = null;
        this.myProject = null;
    }

    protected Model getModel() {
        return this.myModel;
    }

    protected RootManagerImpl getRootManager() {
        Assert.isLegal((this.myProject != null ? 1 : 0) != 0, (String)"Provider should check isDisposedInCurrentModel in is<...>Applicable method");
        return (RootManagerImpl)RootManagerAccess.getRootManager(this.myProject);
    }

    protected boolean isDisposedInCurrentModel() {
        return this.myProject == null;
    }

    protected IProject getProject() {
        return this.myProject;
    }

    private void initProject() {
        if (ModelUinSupport.isModelUin((UniqueName)this.myModel.getUniqueName())) {
            this.myProject = ModelUinSupport.getProject((UniqueName)this.myModel.getUniqueName());
            if (this.myProject == null || !this.myProject.exists() || !this.myProject.isAccessible()) {
                this.myProject = null;
            }
        }
    }
}

