/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.natures;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.internal.providers.resources.RootManagerPlugin;
import com.tssap.selena.model.internal.providers.resources.natures.DefaultNatureRegistryReader;
import com.tssap.selena.model.internal.providers.resources.natures.IDefaultNatureDescriptor;
import com.tssap.selena.model.internal.providers.resources.root.AbstractResourceProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NaturePropertyProvider
extends AbstractResourceProvider
implements PropertyGetProvider,
PropertySetProvider {
    private static final String PROPERTY_NAME = "$nature";

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return !this.isDisposedInCurrentModel() && element.equals(this.getModel());
    }

    public String getPropertyValue(Element element, String propertyName) {
        List natureIds = this.getNatures();
        if (natureIds.size() > 0) {
            return (String)natureIds.get(0);
        }
        return null;
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return this.properties(element);
    }

    public Property getProperty(Element element, String propertyName) {
        PropertyEnumeration properties = this.properties(element, propertyName);
        if (properties.hasMoreElements()) {
            return properties.next();
        }
        return null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        List natureIds = this.getNatures();
        return natureIds.contains(propertyValue);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        IProject project = this.getProject();
        if (project != null && !project.isReadOnly()) {
            List natureIds = this.getNatures();
            return natureIds.size() < 2;
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        IProject project = this.getProject(element);
        if (project != null) {
            try {
                project.getDescription().setNatureIds(new String[]{propertyValue});
            }
            catch (CoreException e) {
                RootManagerPlugin.getDefault().getLog().log((IStatus)new Status(4, RootManagerPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Could not set nature", (Throwable)e));
            }
        }
    }

    public PropertyEnumeration properties(Element element) {
        List natureIds = this.getNatures();
        ArrayList<MyProperty> properties = new ArrayList<MyProperty>();
        Iterator natures = natureIds.iterator();
        while (natures.hasNext()) {
            MyProperty property = new MyProperty(element.getModel(), (String)natures.next());
            if (property == null) continue;
            properties.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return false;
        }
        IProject project = this.getProject();
        if (project != null && !project.isReadOnly()) {
            List natureIds = this.getNatures();
            return !natureIds.contains(propertyValue);
        }
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        IProject project = this.getProject(element);
        if (project != null) {
            try {
                IProjectDescription projectDescription = project.getDescription();
                String[] natureIds = projectDescription.getNatureIds();
                ArrayList<String> list = new ArrayList<String>(natureIds.length * 2);
                int i = 0;
                while (i < natureIds.length) {
                    list.add(natureIds[i]);
                    ++i;
                }
                list.add(propertyValue);
                natureIds = new String[list.size()];
                list.toArray(natureIds);
                projectDescription.setNatureIds(natureIds);
                project.setDescription(projectDescription, null);
                MyProperty property = new MyProperty(element.getModel(), propertyValue);
                return property;
            }
            catch (CoreException e) {
                RootManagerPlugin.getDefault().getLog().log((IStatus)new Status(4, RootManagerPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Could not add nature", (Throwable)e));
            }
        }
        return null;
    }

    public boolean isPropertyWritable(Element element, String propertyName) {
        return true;
    }

    protected String getPropertyName() {
        return PROPERTY_NAME;
    }

    private IProject getProject(Element element) {
        return this.getProject();
    }

    private List getNatures() {
        String[] natureIds;
        IProject project = this.getProject();
        if (project == null) {
            return new ArrayList();
        }
        try {
            natureIds = project.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            natureIds = null;
        }
        ArrayList<String> natureList = new ArrayList<String>();
        if (natureIds != null) {
            int i = 0;
            while (i < natureIds.length) {
                natureList.add(natureIds[i]);
                ++i;
            }
        }
        IDefaultNatureDescriptor[] defNatures = DefaultNatureRegistryReader.getInstance().getDefaultNatures();
        int i = 0;
        while (i < defNatures.length) {
            boolean maskMatchFound = false;
            int j = 0;
            while (j < natureIds.length) {
                if (natureIds[j].startsWith(defNatures[i].getMask())) {
                    maskMatchFound = true;
                    break;
                }
                ++j;
            }
            if (!maskMatchFound) {
                natureList.add(defNatures[i].getNatureId());
            }
            ++i;
        }
        return natureList;
    }

    private class MyProperty
    implements Property {
        private Model myModel;
        private String myNature;

        MyProperty(Model model, String nature) {
            this.myModel = model;
            this.myNature = nature;
        }

        public String getValue() {
            return this.myNature;
        }

        public boolean canSetValue(String newValue) {
            IProject project = NaturePropertyProvider.this.getProject((Element)this.myModel);
            if (project != null && !project.isReadOnly()) {
                return this.isValid();
            }
            return false;
        }

        public void setValue(String newValue) {
            if (this.canSetValue(newValue)) {
                IProject project = NaturePropertyProvider.this.getProject((Element)this.myModel);
                try {
                    IProjectDescription projectDescription = project.getDescription();
                    String[] natureIds = projectDescription.getNatureIds();
                    int i = 0;
                    while (i < natureIds.length) {
                        if (natureIds[i].equals(this.myNature)) {
                            natureIds[i] = newValue;
                        }
                        ++i;
                    }
                    projectDescription.setNatureIds(natureIds);
                    project.setDescription(projectDescription, null);
                }
                catch (CoreException e) {
                    RootManagerPlugin.getDefault().getLog().log((IStatus)new Status(4, RootManagerPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "Could not set nature", (Throwable)e));
                }
                this.myNature = newValue;
            }
        }

        public Element getElement() {
            return this.myModel;
        }

        public String getName() {
            return NaturePropertyProvider.PROPERTY_NAME;
        }

        public PropertyMap getSubproperties() {
            return null;
        }

        public boolean isWritable() {
            return true;
        }

        private boolean isValid() {
            List natureIds = NaturePropertyProvider.this.getNatures();
            return natureIds.contains(this.myNature);
        }
    }
}

