/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.natures;

import com.tssap.selena.model.internal.providers.resources.natures.IDefaultNatureDescriptor;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class DefaultNatureRegistryReader {
    static final String EXT_POINT = "defaultNatures";
    static final String TAG_NATURE = "nature";
    static final String ATT_NATURE_ID = "id";
    static final String ATT_NATURE_MASK = "mask";
    private static DefaultNatureRegistryReader myInstance;
    private ArrayList myNatures = null;

    public static DefaultNatureRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new DefaultNatureRegistryReader();
        }
        return myInstance;
    }

    public IDefaultNatureDescriptor[] getDefaultNatures() {
        if (this.myNatures == null) {
            this.myNatures = new ArrayList();
            this.readRegistry();
        }
        IDefaultNatureDescriptor[] defaultNatures = new IDefaultNatureDescriptor[this.myNatures.size()];
        this.myNatures.toArray(defaultNatures);
        return defaultNatures;
    }

    private void readRegistry() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.tssap.selena.model.providers.resources", EXT_POINT);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            IConfigurationElement[] elements = null;
            int i = 0;
            while (i < extensions.length) {
                elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    this.readElement(elements[j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_NATURE.equals(element.getName())) {
            this.readNature(element);
        }
    }

    private void readNature(IConfigurationElement element) {
        String id = element.getAttribute(ATT_NATURE_ID);
        String mask = element.getAttribute(ATT_NATURE_MASK);
        this.myNatures.add(new MyNatureDescriptor(id, mask));
    }

    private class MyNatureDescriptor
    implements IDefaultNatureDescriptor {
        private String id = null;
        private String mask = null;

        public MyNatureDescriptor(String id, String mask) {
            this.id = id;
            this.mask = mask;
        }

        public String getNatureId() {
            return this.id;
        }

        public String getMask() {
            return this.mask;
        }
    }
}

