/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.designlinks;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import java.util.LinkedList;

public class DependencyUtil {
    public static final String RC_PROPERTY_PREFIX = "$packageDependency:";
    public static final String TARGET_PROPERTY_NAME = "$packageDependency:targetUin";
    public static final String DEPENDENCY_DOMAIN = "com.tssap.twse.package.dependency";
    private static final int MIN_UIN_LENGTH = 4;

    public static UniqueName createDependencyUin(ReferenceCollection sourceRC, ReferenceCollection targetRC) {
        return DependencyUtil.createDependencyUin(sourceRC.getUniqueName(), targetRC.getUniqueName());
    }

    public static UniqueName createDependencyUin(UniqueName sourceRCUin, UniqueName targetRCUin) {
        String domain = DEPENDENCY_DOMAIN;
        String subDomain = "";
        String location = "";
        ArrayList result = DependencyUtil.toParametersList(sourceRCUin);
        String name = new Integer(result.size()).toString();
        result.addAll(DependencyUtil.toParametersList(targetRCUin));
        return ModelAccess.createUniqueName((String)domain, (String)subDomain, (String)location, (String)name, (String[])result.toArray(new String[result.size()]));
    }

    public static boolean isDependencyUin(UniqueName uin) {
        if (uin == null) {
            return false;
        }
        if (!DEPENDENCY_DOMAIN.equals(uin.getDomain())) {
            return false;
        }
        int firstPartLength = DependencyUtil.getFirstPartLength(uin);
        return firstPartLength > 0 && firstPartLength + 4 < uin.getParametersCount();
    }

    private static int getFirstPartLength(UniqueName uin) {
        int result;
        String nameString = uin.getName();
        try {
            result = Integer.parseInt(nameString);
        }
        catch (Exception e) {
            return -1;
        }
        return result;
    }

    public static UniqueName getSourceUin(UniqueName dependencyUin) {
        int firstPartLength = DependencyUtil.getFirstPartLength(dependencyUin);
        if (firstPartLength < 0) {
            return null;
        }
        return DependencyUtil.fromParameters(dependencyUin, 0, firstPartLength);
    }

    public static UniqueName getTargetUin(UniqueName dependencyUin) {
        int firstPartLength = DependencyUtil.getFirstPartLength(dependencyUin);
        if (firstPartLength < 0) {
            return null;
        }
        return DependencyUtil.fromParameters(dependencyUin, firstPartLength, dependencyUin.getParametersCount() - firstPartLength);
    }

    private static ArrayList toParametersList(UniqueName uin) {
        ArrayList<String> result = new ArrayList<String>(uin.getParametersCount() + 4);
        result.add(uin.getDomain());
        result.add(uin.getSubDomain());
        result.add(uin.getLocation());
        result.add(uin.getName());
        int i = 0;
        while (i < uin.getParametersCount()) {
            result.add(uin.getParameter(i));
            ++i;
        }
        return result;
    }

    private static UniqueName fromParameters(UniqueName uin, int start, int length) {
        String domain = uin.getParameter(start + 0);
        String subdomain = uin.getParameter(start + 1);
        String location = uin.getParameter(start + 2);
        String name = uin.getParameter(start + 3);
        LinkedList<String> newParams = new LinkedList<String>();
        int i = start + 4;
        while (i < start + length) {
            newParams.add(uin.getParameter(i));
            ++i;
        }
        return ModelAccess.createUniqueName((String)domain, (String)subdomain, (String)location, (String)name, (String[])newParams.toArray(new String[newParams.size()]));
    }
}

