/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.designlinks;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Link;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.internal.providers.resources.designlinks.AbstractDependencyProvider;
import com.tssap.selena.model.internal.providers.resources.designlinks.DependencyUtil;
import com.tssap.selena.model.internal.providers.resources.designlinks.Messages;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;

public class DependencyNameProvider
extends AbstractDependencyProvider
implements PropertyGetProvider {
    private static final String UNKNOWN_NAME = Messages.getString("DependencyNameProvider.unknownName");
    private static final String COLON = ": ";
    private static final String ARROW = " -> ";

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return DependencyUtil.isDependencyUin(element.getUniqueName()) && element instanceof Link;
    }

    public String getPropertyValue(Element element, String propertyName) {
        ElementEnumeration sources = ((Link)element).participants("Client");
        ElementEnumeration targets = ((Link)element).participants("Supplier");
        String sourceName = sources.hasMoreElements() ? sources.next().getPropertyValue("$name") : UNKNOWN_NAME;
        String targetName = targets.hasMoreElements() ? targets.next().getPropertyValue("$name") : UNKNOWN_NAME;
        StringBuffer result = new StringBuffer(50);
        result.append("Dependency Link");
        result.append(COLON);
        result.append(sourceName);
        result.append(ARROW);
        result.append(targetName);
        return result.toString();
    }

    public Property getProperty(Element element, String propertyName) {
        return new PropertyAdapter(propertyName, this.getPropertyValue(element, propertyName), element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return true;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$name");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return SingleEnumeration.createPropertyEnumeration((Property)this.getProperty(element, propertyName));
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }
}

