/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.designlinks;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.internal.providers.resources.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.internal.providers.resources.designlinks.AbstractDependencyProvider;
import com.tssap.selena.model.internal.providers.resources.designlinks.DependencyUtil;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.Arrays;

public class DependencyLinkProvider
extends AbstractDependencyProvider
implements LinkProvider {
    private static final String[] ROLES = new String[]{"Client", "Supplier"};

    public boolean isLinkProviderApplicable(Entity link) {
        return DependencyUtil.isDependencyUin(link.getUniqueName());
    }

    public StringEnumeration participantRoles(Entity link) {
        return EnumerationConverter.toStringEnumeration(Arrays.asList(ROLES).iterator());
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        UniqueName result = null;
        if ("Client".equals(role)) {
            result = DependencyUtil.getSourceUin(link.getUniqueName());
        } else if ("Supplier".equals(role)) {
            result = DependencyUtil.getTargetUin(link.getUniqueName());
        }
        return result == null ? EmptyEnumeration.getUniqueNameEnumeration() : SingleEnumeration.createUniqueNameEnumeration((UniqueName)result);
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
        throw new IllegalStateException("should not be reachable");
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        Property baseProperty = this.getBaseRCProperty(link.getUniqueName());
        return oldParticipant != null && newParticipant != null && baseProperty != null && oldParticipant.getUniqueName().toString().equals(baseProperty.getValue()) && baseProperty.canSetValue(newParticipant.getUniqueName().toString());
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        Property baseProperty = this.getBaseRCProperty(link.getUniqueName());
        UniqueName newUin = DependencyUtil.createDependencyUin(DependencyUtil.getSourceUin(link.getUniqueName()), newParticipant.getUniqueName());
        UniqueName oldUin = link.getUniqueName();
        this.getDeltaProvider().registerDelta(link.getParent(), oldUin, ModelDeltaNodeKind.DELETED);
        this.getDeltaProvider().registerDelta(link.getParent(), newUin, ModelDeltaNodeKind.ADDED);
        baseProperty.setValue(newParticipant.getUniqueName().toString());
    }
}

