/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.designlinks;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.internal.providers.resources.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.internal.providers.resources.designlinks.AbstractDependencyProvider;
import com.tssap.selena.model.internal.providers.resources.designlinks.DependencyUtil;

public class DependencyExistenceProvider
extends AbstractDependencyProvider
implements EntityExistenceProvider {
    public boolean isDeleteProviderApplicable(Element element) {
        return element instanceof Entity && DependencyUtil.isDependencyUin(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        Property baseProperty = this.getBaseRCProperty(element.getUniqueName());
        return baseProperty == null || baseProperty.canSetValue(null);
    }

    public void delete(Element element) {
        Property baseProperty = this.getBaseRCProperty(element.getUniqueName());
        if (baseProperty != null) {
            this.getDeltaProvider().registerDelta(element.getParent(), element.getUniqueName(), ModelDeltaNodeKind.DELETED);
            baseProperty.setValue(null);
        } else {
            System.err.println("element: " + element.getUniqueName() + " is already deleted");
        }
    }

    public boolean isDeleted(Element element) {
        return this.getBaseRCProperty(element.getUniqueName()) == null;
    }

    public boolean exists(UniqueName uniqueName) {
        return this.getBaseRCProperty(uniqueName) != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if ("Dependency Link".equals(shapeType) && AbstractDependencyProvider.isDefaultRC((Element)parent)) {
            Element target = this.getTarget(template);
            if (target == null) {
                return true;
            }
            return AbstractDependencyProvider.isDefaultRC(target) && parent.canAddProperty("$packageDependency:targetUin", target.getUniqueName().toString());
        }
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Element target = this.getTarget(template);
        if (target == null) {
            System.err.println("Attention null template in createUnqiueName() metaclass: Dependency Link");
            return null;
        }
        UniqueName result = DependencyUtil.createDependencyUin((ReferenceCollection)parent, (ReferenceCollection)target);
        Property baseProperty = parent.addProperty("$packageDependency:targetUin", target.getUniqueName().toString());
        if (baseProperty == null) {
            return null;
        }
        this.getDeltaProvider().registerDelta(parent, result, ModelDeltaNodeKind.ADDED);
        return result;
    }

    private Element getTarget(Entity template) {
        if (template == null || !template.participants("Supplier").hasMoreElements()) {
            return null;
        }
        return template.participants("Supplier").next();
    }
}

