/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.designlinks;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.internal.providers.resources.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.internal.providers.resources.designlinks.DeltaManager;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;

public class DependencyDeltaProvider
implements DeltaTreeProvider,
ModelAware {
    private ConnectionDelta myRootDelta;
    private Model myModel;

    public void registered(Model model) {
        DeltaManager.getInstance().addDeltaProvider(model, this);
        this.myModel = model;
        this.initRootDelta();
    }

    private void initRootDelta() {
        this.myRootDelta = new ConnectionDelta(this.myModel, this.myModel.getUniqueName());
    }

    public void unregistered(Model model) {
        this.myModel = null;
        DeltaManager.getInstance().removeDeltaProvider(model);
    }

    public ModelDeltaNode getModelChanges() {
        ConnectionDelta result = this.myRootDelta;
        this.initRootDelta();
        return result;
    }

    protected void registerDelta(Entity parentRC, UniqueName dependencyUin, ModelDeltaNodeKind kind) {
        ConnectionDelta delta = this.addDeltaChain(parentRC);
        if (delta != null) {
            delta.addChildren(new DependencyDelta(parentRC.getModel(), dependencyUin, kind));
            this.notifyExtensionManager();
        }
    }

    private void notifyExtensionManager() {
        if (this.myModel != null) {
            this.myModel.getExtensionManager().modelContentsChanged();
        }
    }

    private ConnectionDelta addDeltaChain(Entity parentRC) {
        Model model = parentRC.getModel();
        ArrayList<UniqueName> parentsChain = new ArrayList<UniqueName>();
        Entity cur = null;
        cur = parentRC;
        while (cur != null && !(cur instanceof Model)) {
            parentsChain.add(cur.getUniqueName());
            cur = cur.getParent();
        }
        ConnectionDelta result = this.myRootDelta;
        if (cur instanceof Model) {
            int i = parentsChain.size() - 1;
            while (i >= 0) {
                UniqueName curUin = (UniqueName)parentsChain.get(i);
                ModelDeltaNode child = result.getChild(curUin);
                if (!(child instanceof ConnectionDelta)) {
                    child = new ConnectionDelta(model, curUin);
                    result.addChildren(child);
                }
                result = (ConnectionDelta)child;
                --i;
            }
            return result;
        }
        return null;
    }

    private static class DependencyDelta
    implements ModelDeltaNode {
        private Model myModel;
        private UniqueName myUin;
        private ModelDeltaNodeKind myKind;

        public DependencyDelta(Model model, UniqueName uin, ModelDeltaNodeKind kind) {
            this.myModel = model;
            this.myUin = uin;
            this.myKind = kind;
        }

        public boolean isChanged() {
            return this.myKind.isChanged();
        }

        public boolean isDeleted() {
            return this.myKind.isDeleted();
        }

        public boolean isNew() {
            return this.myKind.isNew();
        }

        public boolean isTotallyChanged() {
            return false;
        }

        public Enumeration changedChildren() {
            return EmptyEnumeration.getEnumeration();
        }

        public Element getElement() {
            return this.myModel.findElement(this.myUin);
        }

        public UniqueName getElementUniqueName() {
            return this.myUin;
        }

        public UniqueName getOriginalElementUniqueName() {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private static class ConnectionDelta
    implements ModelDeltaNode {
        private Model myModel;
        private UniqueName myUin;
        private HashMap myChildren;

        public ConnectionDelta(Model model, UniqueName uin) {
            this.myModel = model;
            this.myUin = uin;
        }

        public Enumeration changedChildren() {
            if (this.myChildren == null) {
                return EmptyEnumeration.getEnumeration();
            }
            HashSet result = new HashSet(this.myChildren.values());
            return Collections.enumeration(result);
        }

        public void addChildren(ModelDeltaNode node) {
            if (this.myChildren == null) {
                this.myChildren = new HashMap(5);
            }
            this.myChildren.put(node.getElementUniqueName(), node);
        }

        public ModelDeltaNode getChild(UniqueName uin) {
            return this.myChildren == null ? null : (ModelDeltaNode)this.myChildren.get(uin);
        }

        public Element getElement() {
            return this.myModel.findElement(this.myUin);
        }

        public UniqueName getElementUniqueName() {
            return this.myUin;
        }

        public UniqueName getOriginalElementUniqueName() {
            return null;
        }

        public boolean isChanged() {
            return false;
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isEmpty() {
            return this.myChildren == null || this.myChildren.isEmpty();
        }

        public boolean isNew() {
            return false;
        }

        public boolean isTotallyChanged() {
            return false;
        }
    }
}

