/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.internal.providers.resources.delta;

import com.tssap.selena.model.internal.providers.resources.delta.IDeltaBuilderListener;
import com.tssap.selena.model.internal.providers.resources.root.RootManagerImpl;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.util.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ResourceDeltaBuilder
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private RootManagerImpl myRootManager;
    private IDeltaBuilderListener myDeltaBuilderListener;

    public ResourceDeltaBuilder(RootManagerImpl rootManager) {
        this.myRootManager = rootManager;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void setDeltaBuilderListener(IDeltaBuilderListener listener) {
        Assert.isLegal((this.myDeltaBuilderListener == null ? 1 : 0) != 0);
        this.myDeltaBuilderListener = listener;
    }

    public void removeDeltaBuilderListener(IDeltaBuilderListener listener) {
        Assert.isLegal((this.myDeltaBuilderListener == listener ? 1 : 0) != 0);
        this.myDeltaBuilderListener = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resourceChanged(IResourceChangeEvent event) {
        block7: {
            block8: {
                if (this.myDeltaBuilderListener == null) {
                    return;
                }
                this.myDeltaBuilderListener.resourceUpdateStarted();
                try {
                    int eventType = event.getType();
                    if ((eventType & 2) > 0) {
                        Object var6_3 = null;
                        if (this.myDeltaBuilderListener == null) return;
                        this.myDeltaBuilderListener.resourceUpdateFinished();
                        return;
                    }
                    if ((eventType & 1) <= 0) break block7;
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) {
                        break block8;
                    }
                    try {
                        delta.accept((IResourceDeltaVisitor)this);
                        break block7;
                    }
                    catch (CoreException visitorNotAccepted) {
                        System.err.println("delta can not accept delta-visitor: " + (Object)((Object)visitorNotAccepted));
                        Object var6_5 = null;
                        if (this.myDeltaBuilderListener == null) return;
                        this.myDeltaBuilderListener.resourceUpdateFinished();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (this.myDeltaBuilderListener == null) throw throwable;
                    this.myDeltaBuilderListener.resourceUpdateFinished();
                    throw throwable;
                }
            }
            Object var6_4 = null;
            if (this.myDeltaBuilderListener == null) return;
            this.myDeltaBuilderListener.resourceUpdateFinished();
            return;
        }
        Object var6_6 = null;
        if (this.myDeltaBuilderListener == null) return;
        this.myDeltaBuilderListener.resourceUpdateFinished();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource changedResource = delta.getResource();
        switch (changedResource.getType()) {
            case 8: {
                return this.visitWorkspaceRootDelta(delta);
            }
            case 4: {
                return this.visitProjectDelta(delta);
            }
            case 2: {
                return this.visitFolderDelta(delta);
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    private boolean visitWorkspaceRootDelta(IResourceDelta delta) {
        Assert.isLegal((boolean)(delta.getResource() instanceof IWorkspaceRoot));
        return true;
    }

    private boolean visitProjectDelta(IResourceDelta delta) {
        Assert.isLegal((boolean)(delta.getResource() instanceof IProject));
        return this.myRootManager.getProject().getName().equals(delta.getResource().getName());
    }

    private boolean visitFolderDelta(IResourceDelta delta) {
        Assert.isLegal((boolean)(delta.getResource() instanceof IContainer));
        ProjectRelativePath pathToChanged = ProjectRelativePath.valueOf(delta.getProjectRelativePath());
        IRootProvider[] providers = this.myRootManager.providers(pathToChanged);
        if (providers.length == 0) {
            return false;
        }
        int deltaKind = delta.getKind();
        if ((deltaKind & 1) > 0) {
            IProjectRelativePath movedFromPath = null;
            if ((delta.getFlags() & 0x1000) > 0 && (movedFromPath = this.fullPath2projectRelativePath(delta.getMovedFromPath())) == null) {
                System.err.println("ATTENTION: can not locate project relative path : " + delta.getMovedFromPath());
            }
            if (movedFromPath != null) {
                this.myDeltaBuilderListener.packageMoved(movedFromPath, pathToChanged);
            } else {
                this.myDeltaBuilderListener.packageAdded(pathToChanged);
            }
            return false;
        }
        if ((deltaKind & 2) > 0) {
            IProjectRelativePath movedToPath = null;
            if ((delta.getFlags() & 0x2000) > 0 && (movedToPath = this.fullPath2projectRelativePath(delta.getMovedToPath())) == null) {
                System.err.println("ATTENTION: can not locate project relative path : " + delta.getMovedToPath());
            }
            if (movedToPath != null) {
                this.myDeltaBuilderListener.packageMoved(pathToChanged, movedToPath);
            } else {
                this.myDeltaBuilderListener.packageRemoved(pathToChanged);
            }
            return false;
        }
        return true;
    }

    private IProjectRelativePath fullPath2projectRelativePath(IPath path) {
        if (path == null) {
            return null;
        }
        path = path.makeRelative();
        IPath projectPath = this.myRootManager.getProject().getFullPath().makeRelative();
        if (projectPath.isPrefixOf(path)) {
            IPath result = path.removeFirstSegments(projectPath.segmentCount());
            return ProjectRelativePath.valueOf(result);
        }
        return null;
    }
}

