/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static final int DEFAULT_BUF_SIZE = 4096;
    public static final int MAX_BUF_SIZE = 24576;
    public static final String FILENAME_UNALLOWED_CHARS = "*/\\&|:?<>\"';\u00b4`";

    private FileUtils() {
    }

    public static void zipDirectory(File sourceDir, File destFile) throws IOException, ZipException {
        if (!sourceDir.exists()) {
            throw new FileNotFoundException(sourceDir.toString());
        }
        if (!sourceDir.isDirectory()) {
            throw new IOException(sourceDir.toString() + " must be a directory");
        }
        FileUtils.createIntermediateFolders(destFile);
        ZipOutputStream zipOs = null;
        try {
            zipOs = new ZipOutputStream(new FileOutputStream(destFile));
            StringBuffer sb = new StringBuffer(500);
            FileUtils.addToZip(sb, sourceDir, zipOs, false);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                zipOs.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipOs.close();
        }
        catch (Exception ex) {}
    }

    public static void createIntermediateFolders(File aFile) throws IOException {
        File parentDir = aFile.getAbsoluteFile().getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("FileUtils: failed to create intermediate folders for file " + aFile.getAbsolutePath());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractZipFile(File sourceFile, File destDir) throws IOException, ZipException {
        FileUtils.createIntermediateFolders(destDir);
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException(destDir.toString() + " must be a directory");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(sourceFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                IOException ex2;
                FileOutputStream os;
                block18: {
                    Object var9_8;
                    ZipEntry zipEntry = enumeration.nextElement();
                    File targetFile = new File(destDir, zipEntry.getName().trim().replace('/', File.separatorChar));
                    if (!targetFile.getParentFile().exists()) {
                        targetFile.getParentFile().mkdirs();
                    }
                    if (zipEntry.isDirectory()) {
                        if (targetFile.exists()) continue;
                        targetFile.mkdir();
                        continue;
                    }
                    InputStream is = null;
                    os = null;
                    try {
                        is = zipFile.getInputStream(zipEntry);
                        os = new FileOutputStream(targetFile);
                        FileUtils.copyStream(is, os, (int)Math.min(zipEntry.getSize(), 24576L));
                        var9_8 = null;
                        if (is == null) break block18;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ex2) {
                                // empty catch block
                            }
                        }
                        if (os == null) throw throwable;
                        try {
                            ((OutputStream)os).close();
                            throw throwable;
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                if (os == null) continue;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex2) {}
            }
            Object var12_11 = null;
            if (zipFile == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException ex) {}
    }

    public static void delTree(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                FileUtils.delTree(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addToZip(StringBuffer zipEntryPrefixBuffer, File file, ZipOutputStream zipOs, boolean appendDirName) throws IOException {
        int lastLen = zipEntryPrefixBuffer.length();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) return;
            if (appendDirName) {
                zipEntryPrefixBuffer.append(file.getName()).append('/');
            }
            int i = 0;
            while (i < files.length) {
                FileUtils.addToZip(zipEntryPrefixBuffer, files[i], zipOs, true);
                ++i;
            }
            zipEntryPrefixBuffer.setLength(lastLen);
            return;
        }
        zipEntryPrefixBuffer.append(file.getName());
        ZipEntry zipEntry = new ZipEntry(zipEntryPrefixBuffer.toString());
        zipEntry.setSize(file.length());
        zipOs.putNextEntry(zipEntry);
        zipEntryPrefixBuffer.setLength(lastLen);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            FileUtils.copyStream(is, zipOs, (int)Math.min(file.length(), 24576L));
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                ((InputStream)is).close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                zipOs.closeEntry();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)is).close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            zipOs.closeEntry();
            return;
        }
        catch (Exception ex) {}
    }

    public static void copyStream(InputStream aInputStream, OutputStream aOutputStream) throws IOException {
        FileUtils.copyStream(aInputStream, aOutputStream, 4096);
    }

    public static void copyStream(InputStream aInputStream, OutputStream aOutputStream, int aBufferSize) throws IOException {
        byte[] buffer = null;
        buffer = aBufferSize <= 0 ? new byte[4096] : new byte[aBufferSize];
        int readBytesCount = 0;
        while ((readBytesCount = aInputStream.read(buffer)) >= 0) {
            aOutputStream.write(buffer, 0, readBytesCount);
        }
    }

    public static void copy(File aSrcFile, File aTargetFile) throws IOException {
        Exception ex22;
        FileOutputStream os;
        block13: {
            if (!aSrcFile.exists()) {
                throw new FileNotFoundException("FileUtils.copy(): file " + aSrcFile.getAbsolutePath() + " does not exist.");
            }
            if (!aSrcFile.isFile()) {
                throw new IOException("FileUtils.copy(): cannot copy directory " + aSrcFile.getAbsolutePath());
            }
            FileUtils.createIntermediateFolders(aTargetFile);
            FileInputStream is = null;
            os = null;
            try {
                is = new FileInputStream(aSrcFile);
                os = new FileOutputStream(aTargetFile);
                FileUtils.copyStream(is, os, (int)Math.min(aSrcFile.length(), 24576L));
                Object var5_4 = null;
                if (is == null) break block13;
            }
            catch (Throwable throwable) {
                Exception ex22;
                Object var5_5 = null;
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception ex22) {}
        }
    }

    public static void move(File aSrcFile, File aDestination) throws IOException {
        if (!aSrcFile.exists()) {
            throw new FileNotFoundException("FileUtils.move(): file " + aSrcFile.getAbsolutePath() + " does not exist.");
        }
        File targetFile = null;
        targetFile = aDestination.exists() && aDestination.isDirectory() ? new File(aDestination, aSrcFile.getName()) : aDestination;
        if (targetFile.exists()) {
            targetFile.delete();
        } else {
            FileUtils.createIntermediateFolders(targetFile);
        }
        if (!aSrcFile.renameTo(targetFile)) {
            FileUtils.copy(aSrcFile, targetFile);
            aSrcFile.delete();
        }
    }

    public static String encodeForFileName(String aStringToEncode) {
        StringBuffer sb = new StringBuffer(aStringToEncode.length() + 20);
        FileUtils.encodeForFileName(aStringToEncode, sb);
        return sb.toString();
    }

    public static void encodeForFileName(String aStringToEncode, StringBuffer aOutputBuffer) {
        int i = 0;
        while (i < aStringToEncode.length()) {
            char currentChar = aStringToEncode.charAt(i);
            if (FILENAME_UNALLOWED_CHARS.indexOf(currentChar) == -1) {
                aOutputBuffer.append(currentChar);
            } else {
                aOutputBuffer.append("%");
                aOutputBuffer.append(Integer.toHexString(currentChar));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            FileUtils.printUsage();
            return;
        }
        String mode = args[0];
        String src = args[1];
        String dest = null;
        File srcFile = new File(src);
        File destFile = null;
        if (args.length > 2) {
            dest = args[2];
            destFile = new File(dest);
        }
        int iterations = 1;
        if (args.length > 3) {
            try {
                iterations = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ("-c".equals(mode)) {
            if (dest == null) {
                FileUtils.printUsage();
                return;
            }
            long totalDuration = 0L;
            int i = 0;
            while (i < iterations) {
                System.out.println("Copying " + src + " to " + dest);
                try {
                    long startTs = System.currentTimeMillis();
                    FileUtils.copy(srcFile, destFile);
                    long duration = System.currentTimeMillis() - startTs;
                    totalDuration += duration;
                    System.out.println("Duration: " + duration + "ms. Filesize: " + srcFile.length());
                }
                catch (Exception ex) {
                    System.err.println("Copy failed:");
                    ex.printStackTrace();
                }
                ++i;
            }
            System.out.println("Average duration: " + totalDuration / (long)iterations);
        } else if ("-m".equals(mode)) {
            if (dest == null) {
                FileUtils.printUsage();
                return;
            }
            System.out.println("Moving " + src + " to " + dest);
            try {
                long fileSize = srcFile.length();
                long startTs = System.currentTimeMillis();
                FileUtils.move(srcFile, destFile);
                long duration = System.currentTimeMillis() - startTs;
                System.out.println("Duration: " + duration + "ms. Filesize: " + fileSize);
            }
            catch (Exception ex) {
                System.err.println("Move failed:");
                ex.printStackTrace();
            }
        } else if ("-e".equals(mode)) {
            if (dest == null) {
                FileUtils.printUsage();
                return;
            }
            System.out.println("Extracting zipfile " + src + " to " + dest);
            try {
                long startTs = System.currentTimeMillis();
                FileUtils.extractZipFile(srcFile, destFile);
                long duration = System.currentTimeMillis() - startTs;
                System.out.println("Duration: " + duration + "ms. Filesize: " + srcFile.length());
            }
            catch (Exception ex) {
                System.err.println("Unzip failed:");
                ex.printStackTrace();
            }
        } else if ("-z".equals(mode)) {
            if (dest == null) {
                FileUtils.printUsage();
                return;
            }
            System.out.println("Zipping " + src + " to " + dest);
            try {
                long startTs = System.currentTimeMillis();
                FileUtils.zipDirectory(srcFile, destFile);
                long duration = System.currentTimeMillis() - startTs;
                System.out.println("Duration: " + duration + "ms. Filesize: " + destFile.length());
            }
            catch (Exception ex) {
                System.err.println("Zip failed:");
                ex.printStackTrace();
            }
        } else if ("-d".equals(mode)) {
            System.out.println("Deleting directory " + src);
            try {
                long startTs = System.currentTimeMillis();
                FileUtils.delTree(srcFile);
                long duration = System.currentTimeMillis() - startTs;
                System.out.println("Duration: " + duration + "ms.");
            }
            catch (Exception ex) {
                System.err.println("DelTree failed:");
                ex.printStackTrace();
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage: -c srcFile destFile | -m srcFile destFile | -e srcZip destDir | -z srcDir destFile | -d delDir");
    }
}

