/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class EpaException
extends IOException {
    protected static final String NEWLINE = System.getProperty("line.separator", "\n");
    private Throwable originalException;

    public EpaException(String s) {
        super(s);
        this.originalException = null;
    }

    public EpaException(String s, Throwable exception) {
        super(s);
        this.setException(exception);
    }

    public Throwable getException() {
        return this.originalException;
    }

    public final void setException(Throwable t) {
        this.originalException = t;
    }

    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            super.printStackTrace(out);
            if (this.originalException != null) {
                out.println();
                out.println("Original exception: ");
                this.originalException.printStackTrace(out);
            }
        }
    }

    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            super.printStackTrace(out);
            if (this.originalException != null) {
                out.println();
                out.println("Original exception: ");
                this.originalException.printStackTrace(out);
            }
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public String getMessage() {
        String originalMsg;
        String msg = super.getMessage();
        if (this.originalException != null && (originalMsg = this.originalException.getMessage()) != null) {
            StringBuffer sb = new StringBuffer((msg != null ? msg.length() : 0) + originalMsg.length() + 1);
            sb.append(msg).append(NEWLINE).append(originalMsg);
            msg = sb.toString();
        }
        return msg;
    }
}

