/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile;

import java.io.Serializable;

public class SetTransactionDescriptor
implements Serializable {
    private int m_accessMode;
    private int m_isolation;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    public static final int READ_NONE = 3;
    static final long serialVersionUID = -6317318606668061243L;

    public SetTransactionDescriptor(int accessMode, int isolationLevel) {
        switch (accessMode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("access mode: " + accessMode);
            }
        }
        switch (isolationLevel) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("isolation level: " + isolationLevel);
            }
        }
        this.m_accessMode = accessMode;
        this.m_isolation = isolationLevel;
    }

    public int getAccessMode() {
        return this.m_accessMode;
    }

    public int getIsolationLevel() {
        return this.m_isolation;
    }

    public String toString() {
        StringBuffer desc = new StringBuffer();
        desc.append("ACCESS_MODE=");
        switch (this.getAccessMode()) {
            case 1: {
                desc.append("READ_ONLY");
                break;
            }
            case 2: {
                desc.append("READ_WRITE");
                break;
            }
            case 3: {
                desc.append("NONE");
            }
        }
        desc.append(",ISOLATION_LEVEL=");
        switch (this.getIsolationLevel()) {
            case 0: {
                desc.append("NONE");
                break;
            }
            case 2: {
                desc.append("READ_COMMITTED");
                break;
            }
            case 1: {
                desc.append("READ_UNCOMMITTED");
                break;
            }
            case 4: {
                desc.append("REPEATABLE_READ");
                break;
            }
            case 8: {
                desc.append("SERIALIZABLE");
            }
        }
        return desc.toString();
    }
}

