/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.vault;

import com.sap.security.core.util.Base64;
import com.sap.security.core.vault.Encrypter;
import com.sap.security.core.vault.SecretKeyGenerator;
import iaik.security.provider.IAIK;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class StringEncryptor
extends Encrypter {
    private static final IvParameterSpec defaultIvParam;
    private static final String defaultAlgorithm = "3DES/CBC/PKCS5Padding";
    private Cipher cipher;
    private SecretKey key;
    private IvParameterSpec ivParam;

    private static String getAlgoFromDesc(String algorithmDescription) {
        StringTokenizer stringtokenizer = new StringTokenizer(algorithmDescription, "/");
        return stringtokenizer.nextToken();
    }

    public StringEncryptor() throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(defaultAlgorithm);
        this.key = SecretKeyGenerator.createRandom(StringEncryptor.getAlgoFromDesc(defaultAlgorithm));
        this.ivParam = defaultIvParam;
    }

    public StringEncryptor(String algorithmDescription) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(algorithmDescription);
        this.key = SecretKeyGenerator.createRandom(StringEncryptor.getAlgoFromDesc(algorithmDescription));
        this.ivParam = defaultIvParam;
    }

    public StringEncryptor(byte[] secretData) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(defaultAlgorithm);
        this.key = SecretKeyGenerator.create(StringEncryptor.getAlgoFromDesc(defaultAlgorithm), secretData);
        this.ivParam = defaultIvParam;
    }

    public StringEncryptor(String algorithmDescription, byte[] secretData) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(algorithmDescription);
        this.key = SecretKeyGenerator.create(StringEncryptor.getAlgoFromDesc(algorithmDescription), secretData);
        this.ivParam = defaultIvParam;
    }

    public StringEncryptor(String algorithmDescription, SecretKey keyToUse) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(algorithmDescription);
        this.key = keyToUse;
        this.ivParam = defaultIvParam;
    }

    public void setIV(byte[] initializationVector) {
        this.ivParam = new IvParameterSpec(initializationVector);
    }

    public String encrypt(String string) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return Base64.encode(this.encryptByte(string));
    }

    public String decrypt(String encryptString) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return this.decryptByte(Base64.decode(encryptString));
    }

    public byte[] encryptRaw(byte[] a) throws GeneralSecurityException {
        this.cipher.init(1, (Key)this.key, this.ivParam);
        return this.cipher.doFinal(a);
    }

    public byte[] decryptRaw(byte[] b) throws GeneralSecurityException {
        this.cipher.init(2, (Key)this.key, this.ivParam);
        return this.cipher.doFinal(b);
    }

    public byte[] encryptByte(String string) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        this.cipher.init(1, (Key)this.key, this.ivParam);
        return this.cipher.doFinal(string.getBytes());
    }

    public String decryptByte(byte[] encrypted) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        this.cipher.init(2, (Key)this.key, this.ivParam);
        return new String(this.cipher.doFinal(encrypted));
    }

    public SecretKey getKey() {
        return this.key;
    }

    public String getAlgorithm() {
        return this.cipher.getAlgorithm();
    }

    public static String getDefaultAlgorithm() {
        return defaultAlgorithm;
    }

    public static void main(String[] args) {
        try {
            String secretStr = "This is very secret text";
            String encryptedStr = null;
            SecretKey randomKey = null;
            StringEncryptor strGen = new StringEncryptor();
            encryptedStr = strGen.encrypt("This is very secret text");
            System.out.println("Original string : This is very secret text.");
            System.out.println("Encrypted string: " + encryptedStr + ".");
            randomKey = strGen.getKey();
            strGen = new StringEncryptor(StringEncryptor.getDefaultAlgorithm(), randomKey);
            String decryptedStr = strGen.decrypt(encryptedStr);
            System.out.println("Decrypted string: " + decryptedStr + ".");
            String secretDataString = "this is a secret passphrase";
            byte[] secretData = secretDataString.getBytes();
            StringEncryptor strGen2 = new StringEncryptor(secretData);
            encryptedStr = strGen2.encrypt("This is very secret text");
            System.out.println("Original string : This is very secret text.");
            System.out.println("Encrypted string: " + encryptedStr + ".");
            strGen2 = new StringEncryptor(secretData);
            String decryptedStr2 = strGen2.decrypt(encryptedStr);
            System.out.println("Decrypted string: " + decryptedStr2 + ".");
        }
        catch (Exception exc) {
            System.err.println("Exception caught = " + exc.getMessage());
        }
    }

    static {
        byte[] ivBytes = new byte[]{18, 52, 86, 120, -112, -85, -51, -17};
        IAIK.addAsProvider();
        defaultIvParam = new IvParameterSpec(ivBytes);
    }
}

