/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.vault;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.security.provider.IAIK;
import iaik.security.random.AutoSeedGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SecretKeyGenerator {
    private static final String M_STATIC = "SecretKeyGenerator.<static>";
    private static final String defaultKeyAlgorithm = "3DES";
    private static final Location _location = Location.getLocation((String)"com.sap.security.core.vault");
    private static final Category _category = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)"Usermanagement");
    private static SecureRandom _random = null;

    public static SecureRandom getRandom() {
        return SecretKeyGenerator.getRandom(null);
    }

    public static SecureRandom getRandom(String randomAlgorithm) {
        SecureRandom random;
        if ((randomAlgorithm == null || randomAlgorithm.equals("")) && UMFactory.isInitialized()) {
            randomAlgorithm = UMFactory.getProperties().get("ume.secure_random_algorithm");
        }
        if (randomAlgorithm == null || randomAlgorithm.equals("")) {
            random = new SecureRandom();
        } else {
            try {
                random = SecureRandom.getInstance(randomAlgorithm);
            }
            catch (NoSuchAlgorithmException exc) {
                _category.errorT(_location, "UME: The configuration parameter \"ume.secure_random_algorithm\" specifies an invalid algorithm (\"{0}\"). If in doubt about the right value, please do not assign any value to this parameter.", new Object[]{randomAlgorithm});
                String msg = MessageFormat.format("SecretKeyGenerator: Secure pseudo random number generator \"{0}\" is not available. Every code trying to use this class to generate random numbers will fail.", randomAlgorithm);
                _location.errorT(M_STATIC, msg);
                throw new UMRuntimeException((Throwable)exc);
            }
        }
        AutoSeedGenerator seedGen = new AutoSeedGenerator();
        random.setSeed(seedGen.getSeed());
        return random;
    }

    private static void init(String randomAlgorithm) {
        if (_random != null) {
            return;
        }
        _random = SecretKeyGenerator.getRandom(randomAlgorithm);
    }

    private static String asHexString(byte[] data) {
        int len = data.length;
        StringBuffer dest = new StringBuffer(2 * len);
        int i = 0;
        while (i < len) {
            int n = data[i] < 0 ? 256 + data[i] : data[i];
            if (n < 16) {
                dest.append("0");
            }
            dest.append(Integer.toHexString(n));
            ++i;
        }
        return dest.toString();
    }

    public static SecretKey createRandom() throws NoSuchAlgorithmException {
        return SecretKeyGenerator.createRandom(defaultKeyAlgorithm);
    }

    public static SecretKey createRandom(String algorithm) throws NoSuchAlgorithmException {
        SecretKeyGenerator.init(null);
        KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
        keyGen.init(_random);
        return keyGen.generateKey();
    }

    public static SecretKey createRandom(String randomAlgo, String algorithm) throws NoSuchAlgorithmException {
        SecretKeyGenerator.init(randomAlgo);
        KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
        keyGen.init(_random);
        return keyGen.generateKey();
    }

    public static SecretKey create(byte[] secretData) throws NoSuchAlgorithmException {
        return SecretKeyGenerator.create(defaultKeyAlgorithm, secretData);
    }

    public static SecretKey create(String algorithm, byte[] secretData) throws NoSuchAlgorithmException {
        SecretKeyGenerator.init(null);
        _random.setSeed(secretData);
        KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
        keyGen.init(_random);
        return keyGen.generateKey();
    }

    public static String getDefaultAlgorithm() {
        return defaultKeyAlgorithm;
    }

    public static void main(String[] args) {
        try {
            SecretKey randomKey = SecretKeyGenerator.createRandom();
            System.out.println("Algorithm = " + randomKey.getAlgorithm());
            System.out.println("Generated random key = >" + SecretKeyGenerator.asHexString(randomKey.getEncoded()) + "<");
            byte[] secretData = new byte[]{53, 75, -87, -126, 103, 24, 71, 4};
            SecretKey calculableKey = SecretKeyGenerator.create("DES", secretData);
            System.out.println("Algorithm = " + calculableKey.getAlgorithm());
            System.out.println("Generated random key = >" + SecretKeyGenerator.asHexString(calculableKey.getEncoded()) + "<");
        }
        catch (Exception exc) {
            System.err.println("Exception caught = " + exc.getMessage());
        }
    }

    static {
        IAIK.addAsProvider();
    }
}

