/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.taglib;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class EncodeHtmlTag
extends BodyTagSupport {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/taglib/EncodeHtmlTag.java#2 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/taglib/EncodeHtmlTag.java#2 $ from $DateTime: 2004/11/04 13:54:08 $ ($Change: 17563 $)");

    public int doAfterBody() throws JspException {
        String methodName = "doAfterBody";
        if (trace.bePath()) {
            trace.entering(methodName);
        }
        BodyContent body = this.getBodyContent();
        String orig = body.getString();
        body.clearBody();
        String translated = EncodeHtmlTag.encode(orig);
        try {
            if (trace.beDebug()) {
                trace.debugT(methodName, "Outputting: " + translated);
            }
            this.getPreviousOut().print(translated);
        }
        catch (IOException e) {
            trace.warningT(methodName, "unexpected IO Error", e);
            throw new JspException("unexpected IO Error");
        }
        return 0;
    }

    public static String encode(String orig) {
        if (null == orig) {
            return null;
        }
        int length = orig.length();
        StringBuffer result = new StringBuffer(Math.round((float)length * 1.1f));
        int i = 0;
        while (i < length) {
            char c = orig.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\n': {
                    result.append("<BR>");
                    break;
                }
                case ' ': {
                    result.append("&#32;");
                    break;
                }
                case '\t': {
                    result.append("&nbsp;&nbsp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

