/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.notification;

import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.permissions.UMAdminPermissions;
import com.sap.security.core.role.imp.RoleUtils;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.Message;
import com.sap.security.core.util.notification.Email;
import com.sap.security.core.util.notification.EmailPool;
import com.sap.security.core.util.notification.NotificationException;
import com.sap.security.core.util.notification.NotificationTextsBean;
import com.sap.security.core.util.notification.SendMail;
import com.sapmarkets.tpd.TradingPartnerDirectoryCommon;
import com.sapmarkets.tpd.master.PartnerID;
import com.sapmarkets.tpd.master.TradingPartnerInterface;
import com.sapmarkets.tpd.util.TpdException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;

public class SendMailAsynch {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/SendMailAsynch.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    public static final String PREFIX = "ume.notification.";
    public static final String USER_ACCOUNT_SELFREG_PERFORMED = "selfreg_performed";
    public static final String USER_ACCOUNT_CREATE_REQUEST = "create_request";
    public static final String USER_ACCOUNT_CREATE_APPROVAL = "create_approval";
    public static final String USER_ACCOUNT_CREATE_PERFORMED = "create_performed";
    public static final String USER_PASSWORD_RESET_REQUEST = "pswd_reset_request";
    public static final String USER_PASSWORD_RESET_PERFORMED = "pswd_reset_performed";
    public static final String USER_ACCOUNT_UNLOCK_REQUEST = "unlock_request";
    public static final String USER_ACCOUNT_UNLOCK_PERFORMED = "unlock_performed";
    public static final String USER_ACCOUNT_ACTIVATE_REQUEST = "activate_request";
    public static final String USER_ACCOUNT_ACTIVATE_PERFORMED = "activate_performed";
    public static final String USER_ACCOUNT_LOCK_PERFORMED = "lock_performed";
    public static final String USER_ACCOUNT_CREATE_DENIED = "create_denied";
    public static final String USER_ACCOUNT_CREATE_BY_BATCH_PERFORMED = "create_by_batch_performed";
    public static final String USER_ACCOUNT_UPDATE_BY_BATCH_PERFORMED = "update_by_batch_performed";
    public static final String USER_LOGON_PROBLEM_REQUEST = "user_logon_problem_request";
    public static final String USER_ACCOUNT_DELETE_PERFORMED = "delete_performed";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/SendMailAsynch.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    private static final String SYSTEM_EMAIL = mySAPProperties.get("ume.notification.system_email", "");
    private static final String WORKFLOW_EMAIL = mySAPProperties.get("ume.notification.workflow_email", "");
    private static final String ADMIN_EMAIL = mySAPProperties.get("ume.notification.admin_email", "");

    public static void generateEmailOnUMEvent(IUser userFrom, IUser userTo, String event, String freetext) throws UMException {
        if (freetext == null) {
            freetext = "";
        }
        SendMailAsynch.generateEmailOnUMEvent(userFrom, userTo, event, freetext, "");
    }

    public static void generateEmailOnUMEvent(String uidFrom, String uidTo, String event, String freetext) throws UMException {
        IUserFactory uf = UMFactory.getUserFactory();
        SendMailAsynch.generateEmailOnUMEvent(uf.getUser(uidFrom), uf.getUser(uidTo), event, freetext);
    }

    public static void generateEmailOnUMEvent(String uidFrom, String uidTo, String event, String freetext, String pwd) throws UMException {
        IUserFactory uf = UMFactory.getUserFactory();
        SendMailAsynch.generateEmailOnUMEvent(uf.getUser(uidFrom), uf.getUser(uidTo), event, freetext, pwd);
    }

    public static void generateEmailOnUMEvent(IUser userFrom, IUser userTo, String event, String freetext, String pwd) throws UMException {
        String text;
        String subject;
        if (!EmailPool.isEmailServiceEnabled() || !SendMailAsynch.shouldSend(event)) {
            return;
        }
        int mode = 0;
        String permission = "USER_CREATE";
        String from = null;
        from = userFrom == null ? SYSTEM_EMAIL : userFrom.getEmail();
        String to = userTo.getEmail();
        if (to == null || from == null) {
            trace.errorT("generateEmailOnUMEvent", "cannot send email: either sender or receiver email is null!");
            return;
        }
        trace.debugT("generateEmailOnUMEvent()", "Sending UMEvent", new Object[]{from, to, event, freetext});
        NotificationTextsBean texts = null;
        try {
            texts = new NotificationTextsBean(userTo.getLocale());
        }
        catch (MissingResourceException mre) {
            trace.errorT("generateEmailOnUMEvent", "cannot send emails, resource bundle for texts not found ");
            return;
        }
        Vector userFields = SendMailAsynch.userDataAsVector(userFrom);
        userFields.addAll(SendMailAsynch.userDataAsVector(userTo));
        userFields.add(pwd);
        if (freetext == null) {
            freetext = "";
        }
        userFields.add(freetext);
        if (event.equals(USER_ACCOUNT_SELFREG_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_USER_SELFREG_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_USER_SELFREG_PERFORMED", userFields.toArray()));
            if (SYSTEM_EMAIL.length() > 0) {
                from = SYSTEM_EMAIL;
            } else {
                IUser[] admins = SendMailAsynch.getAdminsOfUserWithPermission(userFrom, "USER_APPROVE");
                if (admins.length > 0) {
                    from = admins[0].getEmail();
                }
            }
        } else if (event.equals(USER_ACCOUNT_CREATE_REQUEST)) {
            subject = texts.print(new Message("SUBJ_CREATE_REQUEST", userFields.toArray()));
            text = texts.print(new Message("TEXT_CREATE_REQUEST", userFields.toArray()));
            mode = 2;
        } else if (event.equals(USER_ACCOUNT_CREATE_APPROVAL)) {
            subject = texts.print(new Message("SUBJ_CREATE_APPROVAL", userFields.toArray()));
            text = texts.print(new Message("TEXT_CREATE_APPROVAL", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_ACCOUNT_CREATE_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_CREATE_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_CREATE_PERFORMED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_PASSWORD_RESET_REQUEST)) {
            subject = texts.print(new Message("SUBJ_PWD_RESET_REQUEST", userFields.toArray()));
            text = texts.print(new Message("TEXT_PWD_RESET_REQUEST", userFields.toArray()));
            mode = 2;
        } else if (event.equals(USER_PASSWORD_RESET_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_PWD_RESET_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_PWD_RESET_PERFORMED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_ACCOUNT_UNLOCK_REQUEST)) {
            subject = texts.print(new Message("SUBJ_UNLOCK_REQUEST", userFields.toArray()));
            text = texts.print(new Message("TEXT_UNLOCK_REQUEST", userFields.toArray()));
            mode = 2;
        } else if (event.equals(USER_ACCOUNT_UNLOCK_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_UNLOCK_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_UNLOCK_PERFORMED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_ACCOUNT_LOCK_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_LOCK_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_LOCK_PERFORMED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_ACCOUNT_CREATE_BY_BATCH_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_CREATE_BY_BATCH_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_CREATE_BY_BATCH_PERFORMED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_ACCOUNT_UPDATE_BY_BATCH_PERFORMED)) {
            subject = texts.print(new Message("SUBJ_UPDATE_BY_BATCH_PERFORMED", userFields.toArray()));
            text = texts.print(new Message("TEXT_UPDATE_BY_BATCH_PERFORMED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_ACCOUNT_CREATE_DENIED)) {
            subject = texts.print(new Message("SUBJ_CREATE_DENIED", userFields.toArray()));
            text = texts.print(new Message("TEXT_CREATE_DENIED", userFields.toArray()));
            mode = 1;
        } else if (event.equals(USER_LOGON_PROBLEM_REQUEST)) {
            subject = texts.print(new Message("SUBJ_USER_LOGON_PROBLEM_REQUEST", userFields.toArray()));
            text = texts.print(new Message("TEXT_USER_LOGON_PROBLEM_REQUEST", userFields.toArray()));
            mode = 1;
        } else {
            throw new UMException("unknown UM mailing event: " + event);
        }
        switch (mode) {
            case 1: {
                if (SYSTEM_EMAIL.length() <= 0) break;
                from = SYSTEM_EMAIL;
                break;
            }
            case 2: {
                if (WORKFLOW_EMAIL.length() > 0) {
                    from = WORKFLOW_EMAIL;
                }
                if (ADMIN_EMAIL.length() <= 0) break;
                to = ADMIN_EMAIL;
            }
        }
        boolean asynch = mySAPProperties.getBoolean("ume.notification.email_asynch", true);
        if (asynch) {
            try {
                EmailPool.getInstance().add(new Email(from, to, subject, text));
            }
            catch (NotificationException ne) {
                trace.warningT("SendMailAsynch", ne.getMessage());
            }
        } else {
            try {
                String[] toArray = new String[]{to};
                trace.infoT("SendMailAsynch", "SYNCHRONIOUS SENDING IS ON!");
                SendMail.sendText(from, toArray, null, subject, text);
            }
            catch (Exception e) {
                trace.warningT("sendMailAsynch", e);
            }
        }
    }

    public static void generateEmailOnUserDeletion(IUser userFrom, String userToString, Locale userToLocale, String freetext) throws UMException {
        if (!EmailPool.isEmailServiceEnabled() || !SendMailAsynch.shouldSend(USER_ACCOUNT_DELETE_PERFORMED)) {
            return;
        }
        NotificationTextsBean texts = null;
        try {
            texts = new NotificationTextsBean(userToLocale);
        }
        catch (MissingResourceException mre) {
            trace.errorT("generateEmailOnUserDeletion", "cannot send emails, resource bundle for texts not found ");
            return;
        }
        String subject = texts.print(new Message("SUBJ_DELETE_PERFORMED"));
        String text = texts.print(new Message("TEXT_DELETE_PERFORMED"));
        try {
            EmailPool.getInstance().add(new Email(userFrom.getEmail(), userToString, subject, text));
        }
        catch (NotificationException ne) {
            trace.warningT("SendMailAsynch", ne.getMessage());
        }
    }

    private static Vector userDataAsVector(IUser user) throws UMException {
        String value;
        Vector<String> fields = new Vector<String>();
        if (user == null) {
            int i = 1;
            while (i <= 4) {
                fields.add("");
                ++i;
            }
            return fields;
        }
        IUserAccount[] accounts = user.getUserAccounts();
        if (accounts != null && accounts.length > 0) {
            value = accounts[0].getLogonUid();
            if (value == null) {
                value = "";
            }
        } else {
            value = user.getDisplayName();
            if (value == null) {
                value = "";
            }
        }
        fields.add(value.trim());
        value = user.getSalutation();
        if (value == null) {
            value = "";
        }
        fields.add(value.trim());
        value = user.getFirstName();
        if (value == null) {
            value = "";
        }
        fields.add(value.trim());
        value = user.getLastName();
        if (value == null) {
            value = "";
        }
        fields.add(value.trim());
        return fields;
    }

    public static void generateEmailToAdminOnUMEvent(IUser userFrom, TradingPartnerInterface company, String event, String freetext) throws UMException {
        if (!EmailPool.isEmailServiceEnabled()) {
            return;
        }
        IUser[] admins = SendMailAsynch.getAdminsOfCompanyWithPermission(company.getPartnerID().toString(), "USER_CREATE");
        int i = 0;
        while (i < admins.length) {
            try {
                SendMailAsynch.generateEmailOnUMEvent(userFrom, admins[i], event, freetext, null);
                if (ADMIN_EMAIL.length() > 0) {
                    break;
                }
            }
            catch (UMException ex) {
                trace.errorT("generateEmailToAdminOnUMEvent", ex);
                throw ex;
            }
            ++i;
        }
    }

    public static void generateEmailToAdminOnUMEvent(IUser userFrom, String event, String freetext) throws UMException {
        if (!EmailPool.isEmailServiceEnabled()) {
            return;
        }
        IUser[] admins = SendMailAsynch.getAdminsOfUserWithPermission(userFrom, "MANAGE_ALL_COMPANIES");
        int i = 0;
        while (i < admins.length) {
            try {
                SendMailAsynch.generateEmailOnUMEvent(userFrom, admins[i], event, freetext, null);
                if (ADMIN_EMAIL.length() > 0) {
                    break;
                }
            }
            catch (UMException ex) {
                trace.errorT("generateEmailToAdminOnUMEvent", ex);
                throw ex;
            }
            ++i;
        }
    }

    private static boolean shouldSend(String event) {
        String methodName = "SendMailAsynch.shouldSend";
        trace.infoT("SendMailAsynch.shouldSend", " send email on ume.notification." + event + "=" + mySAPProperties.getBoolean(PREFIX + event, true));
        boolean shouldSend = mySAPProperties.getBoolean(PREFIX + event, true);
        if (shouldSend) {
            trace.infoT("SendMailAsynch.shouldSend", "sending this event is switched on");
        } else {
            trace.infoT("SendMailAsynch.shouldSend", "sending this event is switched off");
        }
        return shouldSend;
    }

    private static IUser[] getAdminsOfUserWithPermission(IUser user, String permission) throws UMException {
        String cid = null;
        if (user != null) {
            cid = user.getCompany();
        }
        return SendMailAsynch.getAdminsOfCompanyWithPermission(cid, permission);
    }

    private static IUser[] getAdminsOfCompanyWithPermission(String cid, String permission) throws UMException {
        TradingPartnerInterface company = null;
        Set set = new HashSet();
        if (cid != null && cid.length() > 0) {
            try {
                company = TradingPartnerDirectoryCommon.getTPD().getPartner(PartnerID.instantiatePartnerID((String)cid));
            }
            catch (TpdException tpde) {
                throw new UMException(tpde.getMessage());
            }
        }
        if ((set = RoleUtils.getUsersWithPermission((Permission)new UMAdminPermissions(permission), company)) == null || set.size() == 0) {
            trace.infoT("getAdminsOfUserWithPermission", "No admins with permission " + permission + " found for company " + cid);
            return new IUser[0];
        }
        IUser[] admins = new IUser[set.size()];
        admins = set.toArray(admins);
        return admins;
    }
}

