/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.notification;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.notification.ByteArrayDataSource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMail {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/SendMail.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/SendMail.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    private static final boolean DEBUG = false;

    public static void sendText(String from, String[] to, String[] cc, String subject, String text) throws MessagingException, UnknownHostException {
        if (null == text) {
            text = "";
        }
        MimeBodyPart[] parts = new MimeBodyPart[]{SendMail.composeTextPart(text)};
        SendMail.sendMail(from, to, cc, subject, parts);
    }

    public static void sendTextAndFile(String from, String[] to, String[] cc, String subject, String text, String fileName) throws MessagingException, UnknownHostException {
        if (fileName == null || fileName.trim().length() == 0) {
            SendMail.sendText(from, to, cc, subject, text);
            return;
        }
        MimeBodyPart[] parts = new MimeBodyPart[]{SendMail.composeTextPart(text), SendMail.composeFilePart(fileName)};
        SendMail.sendMail(from, to, cc, subject, parts);
    }

    public static void sendTextAndHtml(String from, String[] to, String[] cc, String subject, String text, String html) throws MessagingException, UnknownHostException {
        if (html == null || html.trim().length() == 0) {
            SendMail.sendText(from, to, cc, subject, text);
            return;
        }
        MimeBodyPart[] parts = new MimeBodyPart[]{SendMail.composeTextPart(text), SendMail.composeHtmlPart(html)};
        SendMail.sendMail(from, to, cc, subject, parts);
    }

    public static void sendTextHtmlAndFile(String from, String[] to, String[] cc, String subject, String text, String html, String fileName) throws MessagingException, UnknownHostException {
        if (html == null || html.trim().length() == 0) {
            SendMail.sendTextAndFile(from, to, cc, subject, text, fileName);
            return;
        }
        if (fileName == null || fileName.trim().length() == 0) {
            SendMail.sendTextAndHtml(from, to, cc, subject, text, html);
            return;
        }
        MimeBodyPart[] parts = new MimeBodyPart[]{SendMail.composeTextPart(text), SendMail.composeHtmlPart(html), SendMail.composeFilePart(fileName)};
        SendMail.sendMail(from, to, cc, subject, parts);
    }

    private static MimeBodyPart composeTextPart(String text) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setText(text);
        return mbp;
    }

    private static MimeBodyPart composeFilePart(String fileName) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(fileName);
        mbp.setDataHandler(new DataHandler((DataSource)fds));
        mbp.setFileName(fileName);
        return mbp;
    }

    private static MimeBodyPart composeHtmlPart(String content) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        ByteArrayDataSource bds = new ByteArrayDataSource(content, "text/html");
        mbp.setDataHandler(new DataHandler((DataSource)bds));
        return mbp;
    }

    private static void sendMail(String from, String[] to, String[] cc, String subject, MimeBodyPart[] parts) throws MessagingException, UnknownHostException {
        String methodName = "sendMail";
        if (from == null || from.trim().length() == 0) {
            from = mySAPProperties.get("MAIL_FROM");
        }
        if (null == to || to.length == 0) {
            throw new MessagingException("Can not send to null address!");
        }
        String hostName = mySAPProperties.get("ume.notification.mail_host");
        if (hostName == null || hostName.length() == 0) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ue) {
                trace.errorT(methodName, "sendmail: error retrieving localhost", ue);
                throw ue;
            }
        }
        trace.debugT(methodName, "HostName: ", new Object[]{hostName});
        Properties props = System.getProperties();
        ((Hashtable)props).put("mail.smtp.host", hostName);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(false);
        StringBuffer toList = new StringBuffer(to[0]);
        int i = 1;
        while (i < to.length) {
            toList.append("," + to[i]);
            ++i;
        }
        StringBuffer ccList = null;
        if (null != cc && cc.length != 0) {
            ccList = new StringBuffer(cc[0]);
            int i2 = 1;
            while (i2 < cc.length) {
                ccList.append("," + cc[i2]);
                ++i2;
            }
        }
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] toAddresses = InternetAddress.parse((String)toList.toString());
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            if (null != ccList) {
                InternetAddress[] ccAddresses = InternetAddress.parse((String)ccList.toString());
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
            }
            msg.setSubject(subject);
            trace.debugT(methodName, "Mail: from=" + from + ", to=" + toList.toString() + ", subject=" + subject);
            if (null != ccList) {
                trace.debugT(methodName, "Mail: cc=" + ccList.toString());
            }
            trace.debugT(methodName, "Mail: There are " + parts.length + " parts.");
            MimeMultipart mp = new MimeMultipart();
            int i3 = 0;
            while (i3 < parts.length) {
                mp.addBodyPart((BodyPart)parts[i3]);
                ++i3;
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            trace.errorT(methodName, "sendmail: send failed", mex);
            Exception ex = null;
            ex = mex.getNextException();
            if (ex != null) {
                trace.errorT(methodName, "sendmail: next exception", ex);
            }
            throw mex;
        }
        catch (RuntimeException e) {
            trace.errorT(methodName, "sendmail: send failed", e);
            throw e;
        }
        trace.infoT(methodName, "Mail sent successfully");
    }

    public static void main(String[] args) {
        try {
            String[] to = new String[]{"michael.friedrich@sapmarkets.com"};
            SendMail.sendText("michael.friedrich@sap.com", to, null, "test", "content");
            System.out.println("Mail sent sucessfully!");
        }
        catch (Exception e) {
            trace.errorT("main", e);
            System.out.println("Error sending mail:" + e.toString());
            e.printStackTrace();
        }
    }
}

