/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.notification;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.notification.Email;
import com.sap.security.core.util.notification.EmailPool;
import com.sap.security.core.util.notification.NotificationException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mailer
extends Thread {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/Mailer.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/Mailer.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    private EmailPool fifo;
    private String host = null;
    private final int MAX_ATTEMPTS = 5;
    private final int SLEEP = 10000;

    public Mailer(EmailPool fifo) {
        this.fifo = fifo;
    }

    public Mailer(EmailPool fifo, String host) {
        this.fifo = fifo;
        this.host = host;
    }

    public EmailPool getEmailPool() {
        return this.fifo;
    }

    public String getHost() {
        return this.host;
    }

    private void sendMessage(Message msg) throws MessagingException, UnknownHostException {
        trace.entering("sendMessage");
        Address[] adr = msg.getAllRecipients();
        String recipients = "";
        int i = 0;
        while (i < adr.length) {
            recipients = recipients + adr[i].toString();
            ++i;
        }
        trace.infoT("sendMessage", "Attempting to send email \"" + msg.getSubject() + "\" to " + recipients);
        Transport.send((Message)msg);
        trace.infoT("sendMessage", "email \"" + msg.getSubject() + "\" successfully sent to " + recipients);
        trace.exiting("sendMessage");
    }

    private void send(Email email) throws NotificationException {
        trace.entering("send entered");
        Properties props = System.getProperties();
        ((Hashtable)props).put("mail.smtp.host", this.host);
        Session session = Session.getInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        try {
            try {
                msg.setFrom((Address)new InternetAddress(email.getFrom()));
            }
            catch (Exception ex) {
                throw new NotificationException("Problem setting FROM address" + ex.getMessage());
            }
            String[] to = email.getTo();
            if (to == null || to.length == 0) {
                throw new NotificationException("TO: fields is empty, cannot send email to nowhere!");
            }
            StringBuffer toList = new StringBuffer(to[0]);
            int i = 1;
            while (i < to.length) {
                toList.append("," + to[i]);
                ++i;
            }
            InternetAddress[] toAddresses = InternetAddress.parse((String)toList.toString());
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            String[] cc = email.getCC();
            StringBuffer ccList = null;
            if (null != cc && cc.length != 0) {
                ccList = new StringBuffer(cc[0]);
                int i2 = 1;
                while (i2 < cc.length) {
                    ccList.append("," + cc[i2]);
                    ++i2;
                }
            }
            if (null != ccList) {
                InternetAddress[] ccAddresses = InternetAddress.parse((String)ccList.toString());
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
            }
            String subject = email.getSubject();
            msg.setSubject(subject, "UTF-8");
            MimeBodyPart[] parts = new MimeBodyPart[1];
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setContent((Object)email.getText(), "text/plain;charset=\"UTF-8\"");
            parts[0] = mbp;
            MimeMultipart mp = new MimeMultipart();
            int i3 = 0;
            while (i3 < parts.length) {
                mp.addBodyPart((BodyPart)parts[i3]);
                ++i3;
            }
            msg.setContent((Multipart)mp);
        }
        catch (MessagingException e) {
            trace.warningT("send", "problem occured while constructing email message: " + e.getMessage());
        }
        try {
            this.sendMessage((Message)msg);
            return;
        }
        catch (SendFailedException failede) {
            trace.warningT("send", "SendFailedException while sending email: " + failede.getMessage() + " back to queue");
            if (email.getAttempts() < 5) {
                email.incAttempts();
                this.fifo.add(email);
            } else {
                trace.warningT("send", "MAX_ATTEMPTS reached while sending: " + email.getDescription() + "  not returning to queue");
            }
        }
        catch (MessagingException me) {
            trace.warningT("send", "MessagingException while sending email: " + me.getMessage() + " back to queue");
        }
        catch (UnknownHostException uhe) {
            trace.warningT("send", "UnknownHost while sending email: " + uhe.getMessage() + " back to queue");
        }
        trace.exiting("send");
    }

    public void run() {
        while (true) {
            Email email;
            if ((email = this.fifo.remove()) != null) {
                trace.infoT("run", "Mailer " + this.getHost() + " took an email from the pool");
                try {
                    this.send(email);
                }
                catch (NotificationException ne) {
                    trace.warningT("Mailer:run", ne.getMessage() + ". Email will be deleted without sending");
                }
                continue;
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException ie) {
                trace.debugT("run", ie);
                continue;
            }
            break;
        }
    }
}

