/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.notification;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.notification.Email;
import com.sap.security.core.util.notification.Mailer;
import com.sap.security.core.util.notification.NotificationException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class EmailPool {
    private ArrayList mailers = new ArrayList();
    private LinkedList mails = new LinkedList();
    private static int currentMailer = -1;
    private static EmailPool _instance = null;
    private static final long IDLE_TIME = 60000L;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/EmailPool.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/notification/EmailPool.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();

    public static boolean isEmailServiceEnabled() {
        String hostNames = EmailPool.getMailHost();
        if (hostNames == null || hostNames.trim().length() == 0) {
            trace.infoT("isEmailServiceEnabled", "No mail hosts defined in properties");
            return false;
        }
        trace.infoT("isEmailServiceEnabled", "mailhost is:", new String[]{hostNames});
        return true;
    }

    public static String getMailHost() {
        return mySAPProperties.get("ume.notification.mail_host");
    }

    protected EmailPool() throws NotificationException {
        if (!EmailPool.isEmailServiceEnabled()) {
            throw new NotificationException("No mail hosts defined in properties");
        }
        StringTokenizer t = new StringTokenizer(EmailPool.getMailHost(), ";,", false);
        while (t.hasMoreElements()) {
            this.addMailer(new Mailer(this, ((String)t.nextElement()).trim()));
        }
    }

    public static EmailPool getInstance() throws NotificationException {
        if (null == _instance) {
            _instance = new EmailPool();
        }
        return _instance;
    }

    public void addMailer(Mailer mailer) {
        this.mailers.add(mailer);
        mailer.start();
    }

    public void removeMailer(Mailer mailer) {
        ((AbstractCollection)this.mailers).remove(mailer);
        mailer.interrupt();
    }

    public int size() {
        if (this.mails != null) {
            return this.mails.size();
        }
        return 0;
    }

    public synchronized void add(Email e) {
        e.setLastPutTimeNow();
        this.mails.addLast(e);
        trace.infoT("add", "added email for " + e.getTo()[0].toUpperCase() + " to the pool");
    }

    public synchronized Email remove() {
        if (this.mails.size() > 0) {
            Email e = (Email)this.mails.removeFirst();
            long diff = Calendar.getInstance().getTime().getTime() - e.getLastPutTime();
            if (e.getAttempts() == 0 || e.getAttempts() > 0 && diff > 60000L) {
                return e;
            }
            this.mails.addLast(e);
            return null;
        }
        return null;
    }
}

