/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import java.util.BitSet;

public abstract class XHTMLEncoder {
    private static BitSet toEscape = new BitSet();

    public static String encode(String input) {
        if (input != null) {
            int l = input.length();
            StringBuffer result = new StringBuffer(2 * l);
            String s1 = "&#";
            String s2 = ";";
            int i = 0;
            while (i < l) {
                char c = input.charAt(i);
                if (c > '\u00be' || toEscape.get(c)) {
                    result.append(s1);
                    result.append((int)c);
                    result.append(s2);
                } else {
                    result.append(c);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String decode(String input) {
        int l = input.length();
        StringBuffer result = new StringBuffer(l);
        boolean isEscapeChar = false;
        StringBuffer number = new StringBuffer(3);
        int i = 0;
        while (i < l) {
            char dummy = input.charAt(i);
            if (!isEscapeChar) {
                boolean bl = isEscapeChar = dummy == '&' && i + 1 < l && input.charAt(i + 1) == '#';
                if (!isEscapeChar) {
                    result.append(dummy);
                } else {
                    number = new StringBuffer(3);
                }
            } else if (dummy != ';') {
                number.append(dummy);
            } else {
                result.append((char)Integer.parseInt(number.toString()));
                isEscapeChar = false;
            }
            ++i;
        }
        return result.toString();
    }

    static {
        char[] toBeEscaped = new char[]{'\"', '&', '<', '>', '\u00a7', '\u00a9', '\u00ae', '\u00b6', '\u00bc', '\u00bd', '\u00be'};
        int i = 0;
        while (i < toBeEscaped.length) {
            toEscape.set(toBeEscaped[i]);
            ++i;
        }
    }
}

