/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.api.AttributeList;
import com.sap.security.api.UMRuntimeException;
import iaik.asn1.ASN1Object;
import iaik.asn1.ConstructedType;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;

public class Util {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/Util.java#5 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)";
    public static final String DEFAUL_ENCODING = "ISO-8859-1";
    private static int guidCounter;
    private static int[] _s_days;
    private static int _s_secondsFrom1970To2002;
    public static AttributeList EMPTY_ATTRIBUTE_LIST;
    public static final int REPOSITORY_ABAP_SYSTEM = 1;
    public static final int REPOSITORY_PCD = 2;
    private static int mAvailableRepositories;

    public Util() {
        guidCounter = 0;
    }

    public static boolean isRepositoryAvailable(int repository) {
        return (mAvailableRepositories & repository) == repository;
    }

    public static void setRepositoryAvailable(int repository) {
        mAvailableRepositories |= repository;
    }

    public static long getSecondsFromCalendar(Calendar calendar) {
        int help;
        int year = calendar.get(1);
        boolean bLeapYear = false;
        long total = _s_secondsFrom1970To2002;
        int i = 2003;
        while (i < year) {
            bLeapYear = i % 4 == 0 && (i % 100 != 0 || i % 400 == 0);
            help = 365 + (bLeapYear ? 1 : 0);
            total += (long)(help *= 86400);
            ++i;
        }
        help = calendar.get(2);
        int i2 = 0;
        while (i2 < help) {
            total += Util.getDaysOfMonth(i2, year) * 24L * 60L * 60L;
            ++i2;
        }
        help = calendar.get(5) - 1;
        total += (long)(86400 * help);
        help = calendar.get(11);
        total += (long)(help * 3600);
        help = calendar.get(12);
        total += (long)(help * 60);
        return total += (long)calendar.get(13);
    }

    public static long getDaysOfMonth(int month, int year) {
        boolean bLeapYear;
        boolean bl = bLeapYear = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        if (month != 1) {
            return _s_days[month];
        }
        if (bLeapYear) {
            return 29L;
        }
        return 28L;
    }

    public static boolean isLeapYear(int year) {
        return 29L == Util.getDaysOfMonth(1, year);
    }

    public static String createMD5HashValue(String aString) {
        if (aString == null) {
            return null;
        }
        String result = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            result = new String(md.digest(aString.getBytes()));
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new UMRuntimeException((Throwable)nsaex);
        }
        return result;
    }

    public static byte[] createMD5HashValue(byte[] aByteArray) {
        if (aByteArray == null) {
            return null;
        }
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            result = md.digest(aByteArray);
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new UMRuntimeException((Throwable)nsaex);
        }
        return result;
    }

    public static String getTimeStamp() {
        return Util.getTime(System.currentTimeMillis());
    }

    public static String getTime(long millis) {
        StringBuffer time = new StringBuffer();
        String dummy = "" + millis;
        int length = dummy.length();
        if (length > 16) {
            return "*** Overflow ***";
        }
        if (millis < 0L) {
            time.append("-");
        }
        int i = 0;
        while (i < 16 - length) {
            time.append("0");
            ++i;
        }
        if (millis < 0L) {
            time.append(dummy.substring(1, length));
        } else {
            time.append(dummy);
        }
        return time.toString();
    }

    public static long getHash(String stringToHash) {
        int size = stringToHash.length();
        long hash = size;
        int i = 0;
        while (i < size) {
            hash = hash << 5 ^ hash >>> 27 ^ (long)stringToHash.charAt(i);
            ++i;
        }
        return hash;
    }

    public static String getTimeStampYYYYMMDDHHMMSSMMM() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        StringBuffer b = new StringBuffer(17);
        b.append(c.get(1));
        int h = c.get(2) + 1;
        if (h / 10 == 0) {
            b.append("0");
        }
        b.append(h);
        h = c.get(5);
        if (h / 10 == 0) {
            b.append("0");
        }
        b.append(h);
        h = c.get(11);
        if (h / 10 == 0) {
            b.append("0");
        }
        b.append(h);
        h = c.get(12);
        if (h / 10 == 0) {
            b.append("0");
        }
        b.append(h);
        h = c.get(13);
        if (h / 10 == 0) {
            b.append("0");
        }
        b.append(h);
        h = c.get(14);
        if (h / 10 == 0) {
            b.append("0");
        }
        if (h / 100 == 0) {
            b.append("0");
        }
        b.append(h);
        return b.toString();
    }

    public static synchronized String createGUID() {
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        Random randomizer = new Random();
        long part1 = randomizer.nextLong();
        long part2 = (long)randomizer.nextInt() << 40 | System.currentTimeMillis();
        char[] buf = new char[32];
        int offset = 0;
        int charPos = offset + 16;
        int i = 0;
        while (i < 16) {
            buf[--charPos] = digits[(int)(part1 & 0xFL)];
            part1 >>>= 4;
            ++i;
        }
        offset = 16;
        charPos = offset + 16;
        int i2 = 0;
        while (i2 < 16) {
            buf[--charPos] = digits[(int)(part2 & 0xFL)];
            part2 >>>= 4;
            ++i2;
        }
        StringBuffer guid = new StringBuffer();
        guid.append(buf);
        if (guidCounter < 10) {
            guid.append("000");
            guid.append(guidCounter);
        } else if (guidCounter < 100) {
            guid.append("00");
            guid.append(guidCounter);
        } else if (guidCounter < 1000) {
            guid.append("0");
            guid.append(guidCounter);
        } else if (guidCounter < 10000) {
            guid.append(guidCounter);
        } else {
            guidCounter = -1;
        }
        ++guidCounter;
        return guid.toString();
    }

    public static String encode(String sourceString, boolean humanReadable) {
        byte[] bytes;
        if (humanReadable) {
            return sourceString;
        }
        try {
            bytes = sourceString.getBytes(DEFAUL_ENCODING);
        }
        catch (Exception e) {
            throw new UMRuntimeException((Throwable)e);
        }
        String result = Util.encode(bytes);
        return result;
    }

    public static String encode(byte[] bytes) {
        char[] hexcode = "0123456789ABCDEF".toCharArray();
        char[] encodedString = new char[bytes.length * 2];
        int i = 0;
        while (i < bytes.length) {
            int digit = (bytes[i] + 128) % 16;
            encodedString[i * 2] = hexcode[(bytes[i] + 128 - digit) / 16];
            encodedString[i * 2 + 1] = hexcode[digit];
            ++i;
        }
        return new String(encodedString);
    }

    public static byte[] decodeToByteArray(String encodedString) {
        int endSize = encodedString.length() / 2;
        byte[] decoded = new byte[endSize];
        int num = 0;
        int i = 0;
        while (i < endSize) {
            char digit1 = encodedString.charAt(i * 2);
            char digit2 = encodedString.charAt(i * 2 + 1);
            switch (digit1) {
                case '0': {
                    num = 0;
                    break;
                }
                case '1': {
                    num = 1;
                    break;
                }
                case '2': {
                    num = 2;
                    break;
                }
                case '3': {
                    num = 3;
                    break;
                }
                case '4': {
                    num = 4;
                    break;
                }
                case '5': {
                    num = 5;
                    break;
                }
                case '6': {
                    num = 6;
                    break;
                }
                case '7': {
                    num = 7;
                    break;
                }
                case '8': {
                    num = 8;
                    break;
                }
                case '9': {
                    num = 9;
                    break;
                }
                case 'A': {
                    num = 10;
                    break;
                }
                case 'B': {
                    num = 11;
                    break;
                }
                case 'C': {
                    num = 12;
                    break;
                }
                case 'D': {
                    num = 13;
                    break;
                }
                case 'E': {
                    num = 14;
                    break;
                }
                case 'F': {
                    num = 15;
                }
            }
            num *= 16;
            switch (digit2) {
                case '0': {
                    num += 0;
                    break;
                }
                case '1': {
                    ++num;
                    break;
                }
                case '2': {
                    num += 2;
                    break;
                }
                case '3': {
                    num += 3;
                    break;
                }
                case '4': {
                    num += 4;
                    break;
                }
                case '5': {
                    num += 5;
                    break;
                }
                case '6': {
                    num += 6;
                    break;
                }
                case '7': {
                    num += 7;
                    break;
                }
                case '8': {
                    num += 8;
                    break;
                }
                case '9': {
                    num += 9;
                    break;
                }
                case 'A': {
                    num += 10;
                    break;
                }
                case 'B': {
                    num += 11;
                    break;
                }
                case 'C': {
                    num += 12;
                    break;
                }
                case 'D': {
                    num += 13;
                    break;
                }
                case 'E': {
                    num += 14;
                    break;
                }
                case 'F': {
                    num += 15;
                }
            }
            decoded[i] = (byte)(num - 128);
            ++i;
        }
        return decoded;
    }

    public static String decode(String encodedString, boolean humanReadable) {
        String result;
        if (humanReadable) {
            return encodedString;
        }
        byte[] decoded = Util.decodeToByteArray(encodedString);
        try {
            result = new String(decoded, DEFAUL_ENCODING);
        }
        catch (Exception e) {
            throw new UMRuntimeException((Throwable)e);
        }
        return result;
    }

    public static void dumpByteArray(byte[] b, PrintWriter out) {
        Util.dumpByteArray(b, 0, b.length, out);
    }

    public static void dumpByteArray(byte[] b, int offset, int length, PrintWriter out) {
        int i = offset;
        int j = 0;
        try {
            while (i < length) {
                int x = 0;
                int z = 1;
                j = 0;
                while (j < 8) {
                    x |= b[i] & z;
                    ++j;
                    z *= 2;
                }
                out.print((x < 16 ? "0" : "") + Integer.toHexString(x));
                if (i != length - 1) {
                    out.print(":");
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new UMRuntimeException((Throwable)e);
        }
        out.flush();
    }

    public static void dumpASN1Object(ASN1Object asn, int level, PrintWriter out) throws Exception {
        int i = 0;
        if (!asn.isConstructed()) {
            i = 0;
            while (i < level) {
                out.print("  ");
                ++i;
            }
            out.println("" + asn);
            return;
        }
        Enumeration e = ((ConstructedType)asn).getComponents();
        i = 0;
        while (i < level) {
            out.print("  ");
            ++i;
        }
        out.println("" + asn + " {");
        while (e.hasMoreElements()) {
            Util.dumpASN1Object((ASN1Object)e.nextElement(), level + 1, out);
        }
        i = 0;
        while (i < level) {
            out.print("  ");
            ++i;
        }
        out.println('}');
        out.flush();
    }

    public static void blockByteDump(byte[] b, PrintWriter out) throws Exception {
        Util.blockByteDump(b, 0, b.length, out);
    }

    public static void blockByteDump(byte[] b, int offset, int length, PrintWriter out) throws Exception {
        int i = 0;
        int j = 0;
        j = offset;
        while (j < (length < j + 16 ? length : j + 16)) {
            String hexAddress = Integer.toHexString(i);
            if (hexAddress.length() < 16) {
                int ii = 0;
                while (ii < 16 - hexAddress.length()) {
                    hexAddress = "0" + hexAddress;
                    ++ii;
                }
            }
            out.print(hexAddress);
            out.print(' ');
            Util.dumpByteArray(b, j, length < j + 16 ? length : j + 16, out);
            int iii = 0;
            while (iii < j + 16 - length) {
                out.print("   ");
                ++iii;
            }
            out.print("  ");
            int ii = j;
            while (ii < (length < j + 16 ? length : j + 16)) {
                char c = (char)b[ii];
                if (Util.isCharOk(c)) {
                    out.print(c);
                } else {
                    out.print('.');
                }
                ++ii;
            }
            out.print('\n');
            j += 16;
        }
        out.flush();
    }

    public static void blockByteDump(InputStream is, PrintWriter out) throws Exception {
        byte[] b = new byte[16];
        int iLastRead = is.read();
        int counter = 0;
        while (true) {
            if (iLastRead == -1) break;
            if (counter == 16) {
                Util.blockByteDump(b, out);
                counter = 0;
                continue;
            }
            b[counter++] = (byte)iLastRead;
            iLastRead = is.read();
        }
        Util.blockByteDump(b, 0, counter, out);
    }

    public static String upperCaseABAP(String value) {
        if (value == null) {
            throw new NullPointerException("value must not be null.");
        }
        char[] chs = value.toCharArray();
        char[] ucchs = new char[chs.length];
        int i = 0;
        while (i < chs.length) {
            ucchs[i] = Character.isLetter(chs[i]) && !Character.isIdentifierIgnorable(chs[i]) ? Character.toUpperCase(chs[i]) : chs[i];
            ++i;
        }
        return new String(ucchs);
    }

    public static String trimTrailingSpaces(String value) {
        if (value == null) {
            throw new NullPointerException("value must not be null.");
        }
        int idx = value.length() - 1;
        char[] chars = value.toCharArray();
        while (idx >= 0 && chars[idx] == ' ') {
            --idx;
        }
        return value.substring(0, idx + 1);
    }

    private static boolean isCharOk(char c) {
        byte b = (byte)c;
        if ((0x80 & b) == 128) {
            return false;
        }
        return b > 15;
    }

    static {
        _s_days = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        _s_secondsFrom1970To2002 = 1041379200;
        EMPTY_ATTRIBUTE_LIST = new AttributeList(false);
        mAvailableRepositories = 0;
    }
}

