/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class UMTrace_EX
implements IUMTrace {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/UMTrace_EX.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMParameters props = UMFactory.getProperties();
    private Location loc;
    private Category cat;
    private String className = null;
    private static final String DEFAULT_UM_LOCATION = "com.sap.security.core.usermanagement";
    private static final String DEFAULT_CATEGORY = "/System/Security/Audit";
    private static final String EXLOG_CONFIG_FILE = "ume.trace.external_config_file";
    private static final String DEBUGLEVEL_PROPERTY = "ume.trace.trace_level";
    private static final String DEBUG_EXCEPTION_LEVEL_PROPERTY = "ume.trace.debug_exception_level";
    private static int logLevel;
    private static int exception_level;
    private static String TRACE_FILE_PROPERTY;
    private static String default_trace_file;
    private static String traceFileName;
    private static FileLog traceFile;
    private static String LOG_FILE_PROPERTY;
    private static String default_log_file;
    private static String logFileName;
    private static FileLog logFile;
    private static boolean useExConfigFile;
    private static int MAX_ARGUMENTS_LENGTH;
    private String _additionalName = null;
    private static final String ID_TOKEN = "$Id: ";
    private static final String DATETIME_TOKEN = "$DateTime: ";
    private static final String CHANGELIST_TOKEN = "$Change: ";
    private static final String DATETIME_PREFIX = ": ";
    private static final String DATETIME_POSTFIX = " $";
    private static final String CHANGELIST_PREFIX = ": ";
    private static final String CHANGELIST_POSTFIX = " $";
    private static final String VERSION_PREFIX = "#";
    private static final String VERSION_POSTFIX = " $";
    private static final String LOCATION_PREFIX = ": ";
    private static final String LOCATION_POSTFIX = "#";
    private static final String CLASSNAME_PREFIX = "com/";
    private static final String CLASSNAME_POSTFIX = ".java#";
    private String version = null;
    private String changelist = null;
    private String datetime = null;
    private String location = null;

    public String toString() {
        StringBuffer sb = new StringBuffer("Class: UMTrace; ");
        sb.append("className : " + this.className).append(" \n");
        sb.append("tracefile : " + traceFile).append(" \n");
        sb.append("internal log level : " + logLevel).append(" \n");
        sb.append("debug exception level : " + exception_level).append(" \n");
        return sb.toString();
    }

    public boolean beDebug() {
        return this.loc.beDebug();
    }

    public boolean beInfo() {
        return this.loc.beInfo();
    }

    public boolean bePath() {
        return this.loc.bePath();
    }

    public boolean beWarning() {
        return this.loc.beWarning();
    }

    public boolean beError() {
        return this.loc.beError();
    }

    public void debugT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.debugT("{" + this._additionalName + "}" + methodName, message);
    }

    public void debugT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        String adjustedMessage = this.adjustParameters(message, args);
        this.loc.debugT(methodName, adjustedMessage, args);
    }

    public void debugT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        methodName = methodName + " Exception : {0} ";
        if (exception_level >= 5) {
            String stackTrace = this.getStackTrace(exc);
            methodName = methodName + " {1} ";
            this.loc.debugT(methodName, new Object[]{exc, stackTrace});
        } else {
            this.loc.debugT(methodName, new Object[]{exc});
        }
    }

    public void debugT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        message = message + " Exception : {0} ";
        if (exception_level >= 5) {
            String stackTrace = this.getStackTrace(exc);
            message = message + " {1} ";
            this.loc.debugT(methodName, message, new Object[]{exc, stackTrace});
        } else {
            this.loc.debugT(methodName, message, new Object[]{exc});
        }
    }

    public void entering(String methodName) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.entering(methodName);
    }

    public void entering(String methodName, Object[] arguments) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.entering(methodName, arguments);
    }

    public void exiting(String methodName, Object result) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.exiting(methodName, result);
    }

    public void exiting(String methodName) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.exiting(methodName);
    }

    public void infoT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.infoT(methodName, message);
    }

    public void infoT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        String adjustedMessage = this.adjustParameters(message, args);
        this.loc.infoT(methodName, adjustedMessage, args);
    }

    public void infoT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        methodName = methodName + " Exception : {0} ";
        if (exception_level >= 3) {
            String stackTrace = this.getStackTrace(exc);
            methodName = methodName + " {1} ";
            this.loc.infoT(methodName, new Object[]{exc, stackTrace});
        } else {
            this.loc.infoT(methodName, new Object[]{exc});
        }
    }

    public void infoT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        message = message + " Exception : {0} ";
        if (exception_level >= 3) {
            String stackTrace = this.getStackTrace(exc);
            message = message + " {1} ";
            this.loc.infoT(methodName, message, new Object[]{exc, stackTrace});
        } else {
            this.loc.infoT(methodName, message, new Object[]{exc});
        }
    }

    public void warningT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.warningT(methodName, message);
    }

    public void warningT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        String adjustedMessage = this.adjustParameters(message, args);
        this.loc.warningT(methodName, adjustedMessage);
    }

    public void warningT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        methodName = methodName + " Exception : {0} ";
        if (exception_level >= 2) {
            String stackTrace = this.getStackTrace(exc);
            methodName = methodName + " {1} ";
            this.loc.warningT(methodName, new Object[]{exc, stackTrace});
        } else {
            this.loc.warningT(methodName, new Object[]{exc});
        }
    }

    public void warningT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        message = message + " Exception : {0} ";
        if (exception_level >= 2) {
            String stackTrace = this.getStackTrace(exc);
            message = message + " {1} ";
            this.loc.warningT(methodName, message, new Object[]{exc, stackTrace});
        } else {
            this.loc.warningT(methodName, message, new Object[]{exc});
        }
    }

    public void errorT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.errorT(methodName, message);
    }

    public void errorT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        String adjustedMessage = this.adjustParameters(message, args);
        this.loc.errorT(methodName, adjustedMessage);
    }

    public void errorT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        methodName = methodName + " Exception : {0} ";
        if (exception_level >= 1) {
            String stackTrace = this.getStackTrace(exc);
            methodName = methodName + " {1} ";
            this.loc.errorT(methodName, new Object[]{exc, stackTrace});
        } else {
            this.loc.errorT(methodName, new Object[]{exc});
        }
    }

    public void errorT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        message = message + " Exception : {0} ";
        if (exception_level >= 1) {
            String stackTrace = this.getStackTrace(exc);
            message = message + " {1} ";
            this.loc.errorT(methodName, message, new Object[]{exc, stackTrace});
        } else {
            this.loc.errorT(methodName, message, new Object[]{exc});
        }
    }

    public void fatalT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.fatalT(methodName, message);
    }

    public void fatalT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        String adjustedMessage = this.adjustParameters(message, args);
        this.loc.fatalT(methodName, adjustedMessage);
    }

    public void fatalT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        methodName = methodName + " Exception : {0} ";
        if (exception_level >= 0) {
            String stackTrace = this.getStackTrace(exc);
            methodName = methodName + " {1} ";
            this.loc.fatalT(methodName, new Object[]{exc, stackTrace});
        } else {
            this.loc.fatalT(methodName, new Object[]{exc});
        }
    }

    public void fatalT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        message = message + " Exception : {0} ";
        if (exception_level >= 0) {
            String stackTrace = this.getStackTrace(exc);
            message = message + " {1} ";
            this.loc.fatalT(methodName, message, new Object[]{exc, stackTrace});
        } else {
            this.loc.fatalT(methodName, message, new Object[]{exc});
        }
    }

    public void log(int level, String methodName, String message) {
        int severityLevel = UMTrace_EX.getSeverity(level);
        this.cat.logT(severityLevel, this.loc, methodName, message);
    }

    public void assertion(String methodName, boolean assertion, String message) {
        methodName = this.adjustMessage(methodName);
        if (this._additionalName != null) {
            methodName = "{" + this._additionalName + "}" + methodName;
        }
        this.loc.assertion(methodName, assertion, message);
    }

    public void init(String cName, int component) {
        this.init(cName);
    }

    public void init(String cName, String additionalName) {
        cName = this.getClassName(cName);
        cName = this.adjustClassName(cName);
        this._additionalName = additionalName;
        this.className = cName;
        try {
            this.cat = Category.getCategory((String)DEFAULT_CATEGORY);
            if (!this.className.startsWith("com.sap.security")) {
                String tk = "com.sapportals.portal.";
                if (this.className.startsWith(tk)) {
                    String _mName = "com.sap.security.portal." + this.className.substring(tk.length());
                    this.loc = Location.getLocation((String)_mName);
                } else {
                    this.loc = Location.getLocation((String)("com.sap.security.core.usermanagement." + cName));
                }
            } else {
                this.loc = Location.getLocation((String)cName);
            }
        }
        catch (Exception ex) {
            String msg = "UMTrace_EX.java:Classname = " + cName + " to get the Location Object is illegal";
            System.err.println(msg);
            System.out.println(msg);
            this.cat = Category.getCategory((String)DEFAULT_CATEGORY);
            this.loc = Location.getLocation((String)DEFAULT_UM_LOCATION);
        }
        if (!useExConfigFile) {
            logLevel = props.getNumber(DEBUGLEVEL_PROPERTY, 2);
            int _lvl = UMTrace_EX.getSeverity(logLevel);
            this.loc.setEffectiveSeverity(_lvl);
            this.cat.setEffectiveSeverity(_lvl);
            if (traceFile != null) {
                this.loc.addLog((Log)traceFile);
            }
            if (logFile != null) {
                this.cat.addLog((Log)logFile);
            }
        }
    }

    public void init(String className) {
        this.init(className, null);
    }

    private String getClassName(String versionString) {
        int idPos = versionString.indexOf(ID_TOKEN);
        if (idPos != -1) {
            this.parseVersionString(versionString, idPos);
        } else {
            this.className = versionString;
        }
        return this.className;
    }

    private void parseVersionString(String versionString, int idPos) {
        try {
            int changelistPos;
            int datetimePos = versionString.indexOf(DATETIME_TOKEN);
            if (datetimePos != -1) {
                this.datetime = versionString.substring(versionString.indexOf(": ", datetimePos) + 2, versionString.indexOf(" $", datetimePos + 1));
            }
            if ((changelistPos = versionString.indexOf(CHANGELIST_TOKEN)) != -1) {
                this.changelist = versionString.substring(versionString.indexOf(": ", changelistPos) + 2, versionString.indexOf(" $", changelistPos + 1));
            }
            this.version = versionString.substring(versionString.indexOf("#", idPos) + 1, versionString.indexOf(" $", idPos + 1));
            this.location = versionString.substring(versionString.indexOf(": ", idPos) + 2, versionString.indexOf("#", idPos + 1));
            this.className = versionString.substring(versionString.indexOf(CLASSNAME_PREFIX, idPos), versionString.indexOf(CLASSNAME_POSTFIX, idPos)).replace('/', '.');
        }
        catch (Exception exception) {
            this.loc.traceThrowableT(500, "parseVersionString(String versionString, int idPos)", (Throwable)exception);
            exception.printStackTrace();
        }
    }

    private static final int getSeverity(int level) {
        switch (level) {
            case 0: {
                return 600;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 400;
            }
            case 3: {
                return 300;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 100;
            }
        }
        return 500;
    }

    private String adjustClassName(String className) {
        String _cName = className;
        String startToken = "com";
        String endToken = ".java";
        int index1 = className.indexOf(startToken);
        int index2 = className.indexOf(endToken);
        if (index1 != -1 && index2 != -1 && index1 < index2) {
            _cName = className.substring(index1, index2);
            _cName = _cName.replace('/', '-');
        }
        return _cName;
    }

    private String adjustParameters(String message, Object[] args) {
        if (null == args || message.indexOf(123) != -1) {
            return message;
        }
        StringBuffer msgSB = new StringBuffer(message);
        int length = args.length;
        boolean tooLong = false;
        if (args.length > MAX_ARGUMENTS_LENGTH) {
            length = MAX_ARGUMENTS_LENGTH;
            tooLong = true;
        }
        int i = 0;
        while (i < length) {
            msgSB.append(" {" + i + "}, ");
            ++i;
        }
        if (tooLong) {
            msgSB.append(" Array too large, only the first 10 objects were outputted.");
            return msgSB.toString();
        }
        message = msgSB.toString();
        int index = message.lastIndexOf(44);
        if (index != -1) {
            message = message.substring(0, index - 1) + "}";
        }
        return message;
    }

    private String getStackTrace(Throwable exc) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.println("------ [BEGIN] Exception ------");
        exc.printStackTrace(pw);
        pw.println("------ [END] Exception ------");
        String stacktrace_string = sw.toString();
        sw.flush();
        return stacktrace_string;
    }

    private String adjustMessage(String message) {
        if (logLevel >= 4) {
            StringBuffer sb = new StringBuffer(message);
            sb.append("[cl=").append(this.changelist).append("]");
            return sb.toString();
        }
        return message;
    }

    public void logInfoT(String message, Object[] arguments) {
        this.cat.infoT(this.loc, message, arguments);
    }

    public void logWarningT(String message, Object[] arguments) {
        this.cat.warningT(this.loc, message, arguments);
    }

    public void logErrorT(String message, Object[] arguments) {
        this.cat.errorT(this.loc, message, arguments);
    }

    public void logFatalT(String message, Object[] arguments) {
        this.cat.fatalT(this.loc, message, arguments);
    }

    static {
        exception_level = 1;
        TRACE_FILE_PROPERTY = "ume.trace.trace_file";
        default_trace_file = "sapum.trace";
        traceFileName = null;
        traceFile = null;
        LOG_FILE_PROPERTY = "logFile";
        default_log_file = "sapum.log";
        logFileName = null;
        logFile = null;
        useExConfigFile = false;
        MAX_ARGUMENTS_LENGTH = 10;
        traceFileName = props.get(TRACE_FILE_PROPERTY, default_trace_file);
        traceFile = new FileLog(traceFileName);
        TraceFormatter traceFormatter = new TraceFormatter("%24d %l [%t] %s: %m");
        traceFile.setFormatter((Formatter)traceFormatter);
        logFileName = props.get(LOG_FILE_PROPERTY, default_log_file);
        logFile = new FileLog(logFileName);
        TraceFormatter logFormatter = new TraceFormatter("%24d %l %c [%t] %s: %m");
        logFile.setFormatter((Formatter)logFormatter);
        String configFile = props.getFile(EXLOG_CONFIG_FILE, null);
        if (configFile == null || configFile.equals("")) {
            useExConfigFile = false;
        } else {
            useExConfigFile = true;
            PropertiesConfigurator propConfig = new PropertiesConfigurator(new File(configFile));
            propConfig.configure();
            int reloadtime = props.getNumber("ume.trace.reload_time", 5);
            propConfig.setPeriodicity(reloadtime);
        }
        try {
            exception_level = props.getNumber(DEBUG_EXCEPTION_LEVEL_PROPERTY, exception_level);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

