/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.StringTokenizer;
import java.util.Vector;

public class UMTrace_630
implements IUMTrace {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/UMTrace_630.java#6 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static final IUMParameters props = UMFactory.getProperties();
    private static final String ID_TOKEN = "$Id: ";
    private static final String DATETIME_TOKEN = "$DateTime: ";
    private static final String CHANGELIST_TOKEN = "$Change: ";
    private static final String DATETIME_PREFIX = ": ";
    private static final String DATETIME_POSTFIX = " $";
    private static final String CHANGELIST_PREFIX = ": ";
    private static final String CHANGELIST_POSTFIX = " $";
    private static final String VERSION_PREFIX = "#";
    private static final String VERSION_POSTFIX = " $";
    private static final String LOCATION_PREFIX = ": ";
    private static final String LOCATION_POSTFIX = "#";
    private static final String CLASSNAME_PREFIX = "com/";
    private static final String CLASSNAME_POSTFIX = ".java#";
    private Location loc;
    private Category cat;
    private static final String LOCATION_DEFAULT = "com.sap.security.core.imp";
    private static final String LOCATION_PERSISTENCE = "com.sap.security.core.persistence";
    private static final String LOCATION_ACL = "com.sap.security.core.acl";
    private static final String LOCATION_ROLE = "com.sap.security.core.role";
    private static final String LOCATION_SESSION = "com.sap.security.core.session";
    private static final String LOCATION_TICKET = "com.sap.security.core.ticket";
    private static final String LOCATION_UMAP = "com.sap.security.core.umap";
    private static final String LOCATION_UTIL = "com.sap.security.core.util";
    private static final String LOCATION_VAULT = "com.sap.security.core.vault";
    private static final String LOCATION_API = "com.sap.security.api";
    private static final String LOCATION_WEBAPP = "com.sap.security.core.admin";
    private static final String PACKAGE_WRAPPER_EP5 = "com.sapportals.portal.security.usermanagement";
    private static final String PACKAGE_WRAPPER_SAPMARKETS = "com.sapmarkets.usermanagement";
    private static final String LOCATION_WRAPPER_EP5 = "com.sap.security.wrapper.ep5";
    private static final String LOCATION_WRAPPER_SAPMARKETS = "com.sap.security.wrapper.sapmarkets";
    private static final String PACKAGE_EP6_SRV_USERMGMT = "com.sapportals.portal.prt.service.usermanagement";
    private static final String PACKAGE_EP6_SRV_UMAP = "com.sapportals.portal.prt.service.usermapping";
    private static final String PACKAGE_EP6_APP_USERMGMT = "com.sapportals.portal.prt.component.usermanagement";
    private static final String PACKAGE_EP6_APP_SECURITY = "com.sapportals.portal.prt.component.security";
    private static final String PACKAGE_EP6_LICENSING = "com.sapportals.portal.license";
    private static final String LOCATION_EP6_SRV_USERMGMT = "com.sap.security.portal.service.usermanagement";
    private static final String LOCATION_EP6_SRV_UMAP = "com.sap.security.portal.service.usermapping";
    private static final String LOCATION_EP6_APP_USERMGMT = "com.sap.security.portal.application.usermanagement";
    private static final String LOCATION_EP6_APP_SECURITY = "com.sap.security.portal.application.keystore";
    private static final String LOCATION_EP6_LICENSING = "com.sap.security.portal.service.license";
    private static final String LOCATION_NOTRACING = "com.sap.security.core.developer";
    private static final String UME_CATEGORY = "Usermanagement";
    private String _classname;
    private int _classnameLength;
    private String _changelist;
    private int _changelistLength;
    private String _datetime;
    private String _version;
    private String _location;
    private Vector _additionalLocations = new Vector();
    private Vector _notallowedtotrace;

    public UMTrace_630() {
        String addLoc = props.get("ume.trace.additional_locations");
        if (addLoc != null && addLoc.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(addLoc, ",", false);
            while (tokenizer.hasMoreTokens()) {
                this._additionalLocations.add(tokenizer.nextToken());
            }
        }
        this._notallowedtotrace = new Vector();
        this._notallowedtotrace.add("com.sap.security.core.persistence.datasource.imp.DataSourceBaseImplementation");
        this._notallowedtotrace.add("com.sap.security.core.persistence.datasource.imp.DSConfigurationModel");
        this._notallowedtotrace.add("com.sap.security.core.persistence.datasource.imp.DSAttributeModel");
        this._notallowedtotrace.add("com.sap.security.core.persistence.datasource.imp.DSNameSpaceModel");
        this._notallowedtotrace.add("com.sap.security.core.persistence.datasource.imp.DSPrincipalModel");
        this._notallowedtotrace.add("com.sap.security.core.persistence.datasource.imp.DSPrivatePropertyModel");
        String noTrace = props.get("ume.trace.no_tracing_allowed");
        if (noTrace != null && noTrace.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(noTrace, ",", false);
            while (tokenizer.hasMoreTokens()) {
                this._notallowedtotrace.add(tokenizer.nextToken());
            }
        }
    }

    public boolean beDebug() {
        return this.loc.beDebug();
    }

    public boolean bePath() {
        return this.loc.bePath();
    }

    public boolean beInfo() {
        return this.loc.beInfo();
    }

    public boolean beWarning() {
        return this.loc.beWarning();
    }

    public boolean beError() {
        return this.loc.beError();
    }

    public void debugT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        this.loc.debugT(methodName, message);
    }

    public void debugT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        this.loc.debugT(methodName, message, args);
    }

    public void debugT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(100, methodName, (String)null, exc);
    }

    public void debugT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(100, methodName, message, exc);
    }

    public void entering(String methodName) {
        methodName = this.adjustMessage(methodName);
        this.loc.pathT(methodName, "entering");
    }

    public void entering(String methodName, Object[] arguments) {
        methodName = this.adjustMessage(methodName);
        this.loc.pathT(methodName, "entering", arguments);
    }

    public void exiting(String methodName, Object result) {
        methodName = this.adjustMessage(methodName);
        this.loc.pathT(methodName, "exiting", new Object[]{result});
    }

    public void exiting(String methodName) {
        methodName = this.adjustMessage(methodName);
        this.loc.pathT(methodName, "exiting");
    }

    public void infoT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        this.loc.infoT(methodName, message);
    }

    public void infoT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        this.loc.infoT(methodName, message, args);
    }

    public void infoT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(300, methodName, (String)null, exc);
    }

    public void infoT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(300, methodName, message, exc);
    }

    public void warningT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        this.loc.warningT(methodName, message);
    }

    public void warningT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        this.loc.warningT(methodName, message, args);
    }

    public void warningT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(400, methodName, (String)null, exc);
    }

    public void warningT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(400, methodName, message, exc);
    }

    public void errorT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        this.loc.errorT(methodName, message);
    }

    public void errorT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        this.loc.errorT(methodName, message, args);
    }

    public void errorT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(500, methodName, (String)null, exc);
    }

    public void errorT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(500, methodName, message, exc);
    }

    public void fatalT(String methodName, String message) {
        methodName = this.adjustMessage(methodName);
        this.loc.fatalT(methodName, message);
    }

    public void fatalT(String methodName, String message, Object[] args) {
        methodName = this.adjustMessage(methodName);
        this.loc.fatalT(methodName, message, args);
    }

    public void fatalT(String methodName, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(600, methodName, (String)null, exc);
    }

    public void fatalT(String methodName, String message, Throwable exc) {
        methodName = this.adjustMessage(methodName);
        this.loc.traceThrowableT(600, methodName, message, exc);
    }

    public void log(int level, String methodName, String message) {
        int severityLevel = UMTrace_630.getSeverity(level);
        this.cat.logT(severityLevel, this.loc, methodName, message);
    }

    public void assertion(String methodName, boolean assertion, String message) {
        methodName = this.adjustMessage(methodName);
        this.loc.assertion(methodName, assertion, message);
    }

    public void init(String versionString, int component) {
        this.init(versionString);
    }

    public void init(String versionString) {
        String mn = "init(String versionString)";
        this._classname = this.getClassName(versionString);
        this._classname = this.adjustClassName(this._classname);
        this._classnameLength = this._classname == null ? 0 : this._classname.length();
        this._changelistLength = this._changelist == null ? 0 : this._changelist.length();
        String _umLocation = this.getUMLocation(this._classname);
        try {
            this.loc = Location.getLocation((String)_umLocation);
            this.cat = Category.getCategory((Category)LoggingHelper.SYS_SECURITY, (String)UME_CATEGORY);
        }
        catch (Exception e) {
            this.loc = Location.getLocation((String)LOCATION_DEFAULT);
            LoggingHelper.traceThrowable((int)100, (Location)this.loc, (String)mn, (Throwable)e);
        }
    }

    public void init(String versionString, String additionalName) {
        this.init(versionString);
    }

    private String getUMLocation(String classname) {
        int i = 0;
        while (i < this._notallowedtotrace.size()) {
            if (classname.startsWith((String)this._notallowedtotrace.elementAt(i))) {
                return LOCATION_NOTRACING;
            }
            ++i;
        }
        if (classname.startsWith(LOCATION_DEFAULT)) {
            return LOCATION_DEFAULT;
        }
        if (classname.startsWith(LOCATION_ACL)) {
            return LOCATION_ACL;
        }
        if (classname.startsWith(LOCATION_API)) {
            return LOCATION_API;
        }
        if (classname.startsWith(LOCATION_PERSISTENCE)) {
            return LOCATION_PERSISTENCE;
        }
        if (classname.startsWith(LOCATION_ROLE)) {
            return LOCATION_ROLE;
        }
        if (classname.startsWith(LOCATION_SESSION)) {
            return LOCATION_SESSION;
        }
        if (classname.startsWith(LOCATION_TICKET)) {
            return LOCATION_TICKET;
        }
        if (classname.startsWith(LOCATION_UMAP)) {
            return LOCATION_UMAP;
        }
        if (classname.startsWith(LOCATION_UTIL)) {
            return LOCATION_UTIL;
        }
        if (classname.startsWith(LOCATION_VAULT)) {
            return LOCATION_VAULT;
        }
        if (classname.startsWith(LOCATION_WEBAPP)) {
            return LOCATION_WEBAPP;
        }
        if (classname.startsWith(PACKAGE_WRAPPER_EP5)) {
            return LOCATION_WRAPPER_EP5;
        }
        if (classname.startsWith(PACKAGE_WRAPPER_SAPMARKETS)) {
            return LOCATION_WRAPPER_SAPMARKETS;
        }
        if (classname.startsWith(PACKAGE_EP6_SRV_USERMGMT)) {
            return LOCATION_EP6_SRV_USERMGMT;
        }
        if (classname.startsWith(PACKAGE_EP6_SRV_UMAP)) {
            return LOCATION_EP6_SRV_UMAP;
        }
        if (classname.startsWith(PACKAGE_EP6_APP_USERMGMT)) {
            return LOCATION_EP6_APP_USERMGMT;
        }
        if (classname.startsWith(PACKAGE_EP6_APP_SECURITY)) {
            return LOCATION_EP6_APP_SECURITY;
        }
        if (classname.startsWith(PACKAGE_EP6_LICENSING)) {
            return LOCATION_EP6_LICENSING;
        }
        int i2 = 0;
        while (i2 < this._additionalLocations.size()) {
            if (classname.startsWith((String)this._additionalLocations.elementAt(i2))) {
                return (String)this._additionalLocations.elementAt(i2);
            }
            ++i2;
        }
        return LOCATION_DEFAULT;
    }

    private String getClassName(String versionString) {
        int idPos = versionString.indexOf(ID_TOKEN);
        if (idPos != -1) {
            this.parseVersionString(versionString, idPos);
        } else {
            this._classname = versionString;
        }
        return this._classname;
    }

    private void parseVersionString(String versionString, int idPos) {
        String mn = "parseVersionString(String versionString, int idPos)";
        try {
            int changelistPos;
            int datetimePos = versionString.indexOf(DATETIME_TOKEN);
            if (datetimePos != -1) {
                this._datetime = versionString.substring(versionString.indexOf(": ", datetimePos) + 2, versionString.indexOf(" $", datetimePos + 1));
            }
            if ((changelistPos = versionString.indexOf(CHANGELIST_TOKEN)) != -1) {
                this._changelist = versionString.substring(versionString.indexOf(": ", changelistPos) + 2, versionString.indexOf(" $", changelistPos + 1));
            }
            this._version = versionString.substring(versionString.indexOf("#", idPos) + 1, versionString.indexOf(" $", idPos + 1));
            this._location = versionString.substring(versionString.indexOf(": ", idPos) + 2, versionString.indexOf("#", idPos + 1));
            this._classname = versionString.substring(versionString.indexOf(CLASSNAME_PREFIX, idPos), versionString.indexOf(CLASSNAME_POSTFIX, idPos)).replace('/', '.');
        }
        catch (Exception exception) {
            LoggingHelper.traceThrowable((int)500, (Location)this.loc, (String)mn, (Throwable)exception);
        }
    }

    private static final int getSeverity(int level) {
        switch (level) {
            case 0: {
                return 600;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 400;
            }
            case 3: {
                return 300;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 100;
            }
        }
        return 500;
    }

    private String adjustClassName(String className) {
        String _cName = className;
        String startToken = "com";
        String endToken = ".java";
        int index1 = className.indexOf(startToken);
        int index2 = className.indexOf(endToken);
        if (index1 != -1 && index2 != -1 && index1 < index2) {
            _cName = className.substring(index1, index2);
            _cName = _cName.replace('/', '-');
        }
        return _cName;
    }

    private String adjustMessage(String message) {
        StringBuffer sb = new StringBuffer(this._classnameLength + message.length() + this._changelistLength + 15);
        sb.append("[cf=").append(this._classname).append("]");
        sb.append("[md=").append(message).append("]");
        sb.append("[cl=").append(this._changelist).append("]");
        return sb.toString();
    }

    public void logInfoT(String message, Object[] arguments) {
        this.cat.infoT(this.loc, message, arguments);
    }

    public void logWarningT(String message, Object[] arguments) {
        this.cat.warningT(this.loc, message, arguments);
    }

    public void logErrorT(String message, Object[] arguments) {
        this.cat.errorT(this.loc, message, arguments);
    }

    public void logFatalT(String message, Object[] arguments) {
        this.cat.fatalT(this.loc, message, arguments);
    }
}

