/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.core.util.IUMTrace;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;

public class UMTrace
implements IUMTrace {
    private static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/UMTrace.java#3 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final boolean useExTrace = true;
    private static String traceFile = "";
    private static final String FILESEPARATOR = "/";
    private static int internalLogLevel;
    private static int debugExceptionLevel;
    private static PrintStream output;
    private static final String EXTERNAL_TRACE_CLASS = "com.sap.security.core.util.imp.UMTrace_630";
    private static final String TRACE_FILE_PROPERTY = "ume.trace.trace_file";
    private static final String DEBUG_LEVEL_PROPERTY = "ume.trace.trace_level";
    private static final String USE_INTERNAL_TRACE = "ume.trace.internal_trace";
    private static final int DEFAULT_DEBUG_LEVEL = 2;
    private static final String DEBUG_EXCEPTION_LEVEL = "ume.trace.debug_exception_level";
    private static final int DEFAULT_EXCEP_LEVEL = 4;
    private static final int TRACEMAXLINECOUNT = 10000;
    private static final int LEVELCACHETIME = 10000;
    private static int tracelinecount;
    private static final String DEFAULT_CATEGORY = "/System/Security/Audit";
    private static final String DEBUGLEVEL_PROPERTY = "ume.trace.trace_level";
    private static final String LOG_FILE_PROPERTY = "logFile";
    private static final String DEFAULT_LOG_FILE = "sapum.log";
    private static String logFileName;
    private static FileLog logFile;
    private static int logLevel;
    private static Category cat;
    private boolean _isPath = false;
    private boolean _isDebug = false;
    private boolean _isInfo = false;
    private boolean _isError = false;
    private boolean _isWarning = false;
    private long _debugTimeStamp = 0L;
    private long _pathTimeStamp = 0L;
    private long _infoTimeStamp = 0L;
    private long _warningTimeStamp = 0L;
    private long _errorTimeStamp = 0L;
    private IUMTrace externalTrace = null;
    private static final int USERMANAGEMENT_COMPONENT = 0;
    private static final String ID_TOKEN = "$Id: ";
    private static final String DATETIME_TOKEN = "$DateTime: ";
    private static final String CHANGELIST_TOKEN = "$Change: ";
    private static final String DATETIME_PREFIX = ": ";
    private static final String DATETIME_POSTFIX = " $";
    private static final String CHANGELIST_PREFIX = ": ";
    private static final String CHANGELIST_POSTFIX = " $";
    private static final String VERSION_PREFIX = "#";
    private static final String VERSION_POSTFIX = " $";
    private static final String LOCATION_PREFIX = ": ";
    private static final String LOCATION_POSTFIX = "#";
    private static final String CLASSNAME_PREFIX = "com/";
    private static final String CLASSNAME_POSTFIX = ".java#";
    private String version = null;
    private String changelist = null;
    private String datetime = null;
    private String location = null;
    private String className = null;

    public void init(String versionName, int component) {
        this.init(versionName);
    }

    public void init(String versionName) {
        this.className = this.getClassName(versionName);
        try {
            Class<?> exTraceClass = Class.forName(EXTERNAL_TRACE_CLASS);
            this.externalTrace = (IUMTrace)exTraceClass.newInstance();
            this.externalTrace.init(versionName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(String versionName, String additionalName) {
        this.init(versionName);
    }

    public String toString() {
        String message = this.externalTrace.toString();
        StringBuffer sb = new StringBuffer(this.externalTrace.toString());
        sb.append("changelist : " + this.changelist).append("\n");
        sb.append("datetime : " + this.datetime).append("\n");
        return sb.toString();
    }

    public boolean beDebug() {
        if (System.currentTimeMillis() > this._debugTimeStamp) {
            this._isDebug = this.externalTrace.beDebug();
            this._debugTimeStamp = System.currentTimeMillis() + 10000L;
        }
        return this._isDebug;
    }

    public boolean bePath() {
        if (System.currentTimeMillis() > this._pathTimeStamp) {
            this._isPath = this.externalTrace.bePath();
            this._pathTimeStamp = System.currentTimeMillis() + 10000L;
        }
        return this._isPath;
    }

    public boolean beInfo() {
        if (System.currentTimeMillis() > this._infoTimeStamp) {
            this._isInfo = this.externalTrace.beInfo();
            this._infoTimeStamp = System.currentTimeMillis() + 10000L;
        }
        return this._isInfo;
    }

    public boolean beWarning() {
        if (System.currentTimeMillis() > this._warningTimeStamp) {
            this._isWarning = this.externalTrace.beWarning();
            this._warningTimeStamp = System.currentTimeMillis() + 10000L;
        }
        return this._isWarning;
    }

    public boolean beError() {
        if (System.currentTimeMillis() > this._errorTimeStamp) {
            this._isError = this.externalTrace.beError();
            this._errorTimeStamp = System.currentTimeMillis() + 10000L;
        }
        return this._isError;
    }

    public void debugT(String methodName, String message) {
        if (this.beDebug()) {
            this.externalTrace.debugT(methodName, message);
        }
    }

    public void debugT(String methodName, String message, Object[] args) {
        if (this.beDebug()) {
            this.externalTrace.debugT(methodName, message, args);
        }
    }

    public void debugT(String methodName, Throwable exc) {
        if (this.beDebug()) {
            this.externalTrace.debugT(methodName, exc);
        }
    }

    public void debugT(String methodName, String message, Throwable exc) {
        if (this.beDebug()) {
            this.externalTrace.debugT(methodName, message, exc);
        }
    }

    public void entering(String methodName) {
        if (this.bePath()) {
            this.externalTrace.entering(methodName);
        }
    }

    public void entering(String methodName, Object[] arguments) {
        if (this.bePath()) {
            this.externalTrace.entering(methodName, arguments);
        }
    }

    public void exiting(String methodName) {
        if (this.bePath()) {
            this.externalTrace.exiting(methodName);
        }
    }

    public void exiting(String methodName, Object result) {
        if (this.bePath()) {
            this.externalTrace.exiting(methodName, result);
        }
    }

    public void infoT(String methodName, String message) {
        if (this.beInfo()) {
            this.externalTrace.infoT(methodName, message);
        }
    }

    public void infoT(String methodName, String message, Object[] args) {
        if (this.beInfo()) {
            this.externalTrace.infoT(methodName, message, args);
        }
    }

    public void infoT(String methodName, Throwable exc) {
        if (this.beInfo()) {
            this.externalTrace.infoT(methodName, exc);
        }
    }

    public void infoT(String methodName, String message, Throwable exc) {
        if (this.beInfo()) {
            this.externalTrace.infoT(methodName, message, exc);
        }
    }

    public void warningT(String methodName, String message) {
        if (this.beWarning()) {
            this.externalTrace.warningT(methodName, message);
        }
    }

    public void warningT(String methodName, String message, Object[] args) {
        if (this.beWarning()) {
            this.externalTrace.warningT(methodName, message, args);
        }
    }

    public void warningT(String methodName, Throwable exc) {
        if (this.beWarning()) {
            this.externalTrace.warningT(methodName, exc);
        }
    }

    public void warningT(String methodName, String message, Throwable exc) {
        if (this.beWarning()) {
            this.externalTrace.warningT(methodName, message, exc);
        }
    }

    public void errorT(String methodName, String message) {
        this.externalTrace.errorT(methodName, message);
    }

    public void errorT(String methodName, String message, Object[] args) {
        this.externalTrace.errorT(methodName, message, args);
    }

    public void errorT(String methodName, Throwable exc) {
        this.externalTrace.errorT(methodName, exc);
    }

    public void errorT(String methodName, String message, Throwable exc) {
        this.externalTrace.errorT(methodName, message, exc);
    }

    public void log(int msgLevel, String methodName, String message) {
        String newMethodName = this.adjustMethodName(methodName);
        this.externalTrace.log(msgLevel, newMethodName, message);
    }

    public void assertion(String methodName, boolean assertion, String message) {
        String newMethodName = this.adjustMethodName(methodName);
        this.externalTrace.assertion(newMethodName, assertion, message);
    }

    public void fatalT(String methodName, String message) {
        this.externalTrace.fatalT(methodName, message);
    }

    public void fatalT(String methodName, String message, Object[] args) {
        this.externalTrace.fatalT(methodName, message, args);
    }

    public void fatalT(String methodName, String message, Throwable exc) {
        this.externalTrace.fatalT(methodName, message, exc);
    }

    public void fatalT(String methodName, Throwable exc) {
        this.externalTrace.fatalT(methodName, exc);
    }

    private boolean isDebug() {
        return 5 <= internalLogLevel;
    }

    private boolean isPath() {
        return 4 <= internalLogLevel;
    }

    private boolean isInfo() {
        return 3 <= internalLogLevel;
    }

    private boolean isWarning() {
        return 2 <= internalLogLevel;
    }

    private boolean isError() {
        return 1 <= internalLogLevel;
    }

    private String getClassName(String versionString) {
        int idPos = versionString.indexOf(ID_TOKEN);
        if (idPos != -1) {
            this.parseVersionString(versionString, idPos);
        } else {
            this.className = versionString;
        }
        return this.className;
    }

    private void parseVersionString(String versionString, int idPos) {
        try {
            int changelistPos;
            int datetimePos = versionString.indexOf(DATETIME_TOKEN);
            if (datetimePos != -1) {
                this.datetime = versionString.substring(versionString.indexOf(": ", datetimePos) + 2, versionString.indexOf(" $", datetimePos + 1));
            }
            if ((changelistPos = versionString.indexOf(CHANGELIST_TOKEN)) != -1) {
                this.changelist = versionString.substring(versionString.indexOf(": ", changelistPos) + 2, versionString.indexOf(" $", changelistPos + 1));
            }
            this.version = versionString.substring(versionString.indexOf("#", idPos) + 1, versionString.indexOf(" $", idPos + 1));
            this.location = versionString.substring(versionString.indexOf(": ", idPos) + 2, versionString.indexOf("#", idPos + 1));
            this.className = versionString.substring(versionString.indexOf(CLASSNAME_PREFIX, idPos), versionString.indexOf(CLASSNAME_POSTFIX, idPos)).replace('/', '.');
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getDate() {
        StringBuffer b = new StringBuffer();
        Date currentDate = new Date(System.currentTimeMillis());
        b.append(DateFormat.getDateInstance(3).format(currentDate) + ' ');
        b.append(DateFormat.getTimeInstance().format(currentDate) + ' ');
        return b.toString();
    }

    private String getSeverityMsg(int level) {
        String msg = null;
        switch (level) {
            case 5: {
                msg = "DEBUG";
                break;
            }
            case 4: {
                msg = "PATH";
                break;
            }
            case 3: {
                msg = "INFO";
                break;
            }
            case 2: {
                msg = "WARNING";
                break;
            }
            case 1: {
                msg = "ERROR";
                break;
            }
            case 0: {
                msg = "FATAL";
                break;
            }
            default: {
                msg = "ALL";
            }
        }
        return msg;
    }

    private static int getSeverity(int level) {
        switch (level) {
            case 0: {
                return 600;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 400;
            }
            case 3: {
                return 300;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 100;
            }
        }
        return 500;
    }

    private synchronized void debug(String message) {
        if (traceFile != null && tracelinecount++ > 10000) {
            System.err.println("starting new trace file");
            try {
                tracelinecount = 0;
                if (output != null && output != System.out) {
                    output.close();
                }
                output = null;
                File file = new File(traceFile);
                String date = Long.toString(System.currentTimeMillis());
                StringBuffer sb = new StringBuffer();
                sb.append(traceFile).append("_").append(date);
                File bakfile = new File(sb.toString());
                bakfile.delete();
                file.renameTo(bakfile);
                file.delete();
                output = new PrintStream(new FileOutputStream(traceFile, true));
            }
            catch (IOException e) {
                System.err.println(e);
            }
            if (output == null) {
                output = System.out;
            }
        }
        output.println(message);
    }

    private void debug(int level, String methodName, String message, Object[] args) {
        if (level <= internalLogLevel) {
            if (message == null) {
                message = "null";
            }
            StringBuffer msgT = new StringBuffer();
            msgT.append(message).append("|");
            msgT.append("arguments = {");
            if (args.length == 0) {
                msgT.append("null");
            } else {
                int i = 0;
                while (i < args.length) {
                    if (args[i] != null) {
                        msgT.append(args[i].toString()).append(",");
                    } else {
                        msgT.append("null");
                    }
                    ++i;
                }
            }
            msgT.append("}");
            this.debug(level, methodName, msgT.toString());
        }
    }

    private void debug(int level, String methodName, Object[] args) {
        if (level <= internalLogLevel) {
            StringBuffer msgT = new StringBuffer();
            msgT.append("arguments = {");
            if (args.length == 0) {
                msgT.append("null");
            } else {
                int i = 0;
                while (i < args.length) {
                    if (args[i] != null) {
                        msgT.append(args[i].toString()).append(",");
                    } else {
                        msgT.append("null");
                    }
                    ++i;
                }
            }
            msgT.append("}");
            this.debug(level, methodName, msgT.toString());
        }
    }

    private void debug(int level, Throwable exc) {
        if (level <= internalLogLevel) {
            if (level <= debugExceptionLevel) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("------ [BEGIN] Exception ------");
                exc.printStackTrace(pw);
                pw.println("------ [END] Exception ------");
                sw.flush();
                this.debug(sw.toString());
            } else {
                this.debug("------ Exception: " + exc.toString());
            }
        }
    }

    private void debug(int level, String methodName) {
        if (level <= internalLogLevel) {
            StringBuffer msgT = new StringBuffer(this.getDate());
            msgT.append(" | ");
            msgT.append(this.getSeverityMsg(level));
            msgT.append(" | ");
            msgT.append(this.className);
            msgT.append(".");
            msgT.append(methodName);
            this.debug(msgT.toString());
        }
    }

    private void debug(int level, String methodName, String message) {
        if (level <= internalLogLevel) {
            if (message == null) {
                message = "null";
            }
            StringBuffer msgT = new StringBuffer(this.getDate());
            msgT.append(" | ");
            msgT.append(this.getSeverityMsg(level));
            msgT.append(" | ");
            msgT.append(this.className);
            msgT.append("|");
            msgT.append(methodName);
            msgT.append(": MSG=\"");
            msgT.append(message);
            msgT.append("\"");
            this.debug(msgT.toString());
        }
    }

    private String adjustMethodName(String methodName) {
        StringBuffer sb = new StringBuffer(methodName);
        if (internalLogLevel >= 4) {
            sb.append("[cl:").append(this.changelist).append("]");
        }
        return sb.toString();
    }

    public void logInfoT(String message, Object[] arguments) {
        this.externalTrace.logInfoT(message, arguments);
    }

    public void logWarningT(String message, Object[] arguments) {
        this.externalTrace.logWarningT(message, arguments);
    }

    public void logErrorT(String message, Object[] arguments) {
        this.externalTrace.logErrorT(message, arguments);
    }

    public void logFatalT(String message, Object[] arguments) {
        this.externalTrace.logFatalT(message, arguments);
    }

    static {
        output = null;
        tracelinecount = 0;
        logFileName = null;
        logFile = null;
    }
}

