/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.codesecurity.permission.ProtectedCallPermission;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.vault.SecretKeyGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class UMParameters
implements IUMParameters {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/UMParameters.java#4 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static final String SM_CLASSNAME = (class$com$sap$security$core$util$imp$UMParameters == null ? (class$com$sap$security$core$util$imp$UMParameters = UMParameters.class$("com.sap.security.core.util.imp.UMParameters")) : class$com$sap$security$core$util$imp$UMParameters).getName();
    private static final String SM_METH_GETPASSWORD = "getPassword";
    private static String FILESEPARATOR = File.separator;
    private static final boolean PROPS_DEFAULT_READ_ONLY = true;
    private static String VERBOSE = "ume.trace.verbose";
    private static final String PROPS_READ_ONLY = "ume.properties_readonly";
    private static Properties privateProps = null;
    private static Properties publicProps = null;
    private static HashMap pcdfiles = new HashMap();
    private static IUMTrace _trace = null;
    private HashMap logProp = new HashMap();
    private HashMap logFiles = new HashMap();
    private static Properties myPropsWhichAreNotFound = null;
    private static File myPropsWhichAreNotFoundFile = null;
    private static String[] changeableProperties = new String[]{"ume.logon.security_policy.useridminlength", "ume.logon.security_policy.useridmaxlength", "ume.logon.security_policy.userid_in_password_allowed", "ume.logon.security_policy.oldpass_in_newpass_allowed", "ume.logon.security_policy.password_min_length", "ume.logon.security_policy.password_max_length", "ume.logon.security_policy.password_mix_case_required", "ume.logon.security_policy.password_alpha_numeric_required", "ume.logon.security_policy.password_special_char_required", "ume.logon.security_policy.password_change_allowed", "ume.logon.security_policy.lock_after_invalid_attempts", "ume.logon.security_policy.auto_unlock_time", "ume.logon.security_policy.password_expire_days", "ume.logon.security_policy.cert_logon_required", "ume.logon.security_policy.cookie_life_time"};
    private Vector changeables = null;
    private static String[] secureProperties = new String[]{"ume.db.jdbc_password", "ume.ldap.access.password", "ume.superadmin.password", "ume.ldap.access.additional_password.*", "ume.r3.connection.*.passwd"};
    static /* synthetic */ Class class$com$sap$security$core$util$imp$UMParameters;

    public UMParameters() {
        if (FILESEPARATOR == null) {
            FILESEPARATOR = "/";
        }
    }

    public String getPassword(String property) {
        SecurityManager sm = UMFactory.getSecurityManager();
        if (sm != null) {
            ProtectedCallPermission p = new ProtectedCallPermission(SM_CLASSNAME, SM_METH_GETPASSWORD);
            sm.checkPermission((Permission)p);
        }
        return this.getPasswordDecode(this.get(property));
    }

    public String getPasswordDecode(String passwd) {
        String ret;
        SecurityManager sm = UMFactory.getSecurityManager();
        if (sm != null) {
            ProtectedCallPermission p = new ProtectedCallPermission(SM_CLASSNAME, SM_METH_GETPASSWORD);
            sm.checkPermission((Permission)p);
        }
        if ((ret = ec.d(passwd)) == null) {
            ret = "";
            this.doTrace("getPasswordDecode", "Error decoding password: " + passwd);
        }
        return ret;
    }

    public String returnPasswordEncode(String passwd) {
        SecurityManager sm = UMFactory.getSecurityManager();
        if (sm != null) {
            ProtectedCallPermission p = new ProtectedCallPermission(SM_CLASSNAME, SM_METH_GETPASSWORD);
            sm.checkPermission((Permission)p);
        }
        return ec.e(passwd);
    }

    public String get(String property) {
        String value = privateProps.getProperty(property);
        if (value != null) {
            value = value.trim();
        }
        this.writePropertyWhichAreNotFound(property, "");
        if (value == null && myPropsWhichAreNotFound != null) {
            myPropsWhichAreNotFound.setProperty(property, "");
        }
        return value;
    }

    public String get(String property, String dflt) {
        String value = privateProps.getProperty(property, dflt);
        if (value != null) {
            value = value.trim();
        }
        if (value == null && myPropsWhichAreNotFound != null) {
            myPropsWhichAreNotFound.setProperty(property, dflt != null ? dflt : "null");
        }
        return value;
    }

    public int getNumber(String property, int dflt) {
        block3: {
            String valuestring = this.get(property);
            if (valuestring != null) {
                valuestring = valuestring.trim();
                try {
                    int i = Integer.parseInt(valuestring.trim());
                    return i;
                }
                catch (NumberFormatException e) {
                    if (!_trace.beDebug()) break block3;
                    _trace.debugT("getNumber", "UME: Couldn't parse " + property + ": " + valuestring, e);
                }
            }
        }
        return dflt;
    }

    public boolean getBoolean(String property, boolean dflt) {
        String value = privateProps.getProperty(property);
        if (value != null) {
            if ((value = value.trim()).equalsIgnoreCase("false") || value.equalsIgnoreCase("0")) {
                return false;
            }
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            try {
                int boolInt = Integer.parseInt(value);
                return boolInt >= 1;
            }
            catch (Exception e) {
                if (_trace.beDebug()) {
                    _trace.debugT("getBoolean", "wrong value for the boolean property " + property + ", return the default value", e);
                }
                return dflt;
            }
        }
        return dflt;
    }

    public boolean getBoolean(String property) {
        return this.getBoolean(property, false);
    }

    public String getFile(String property, String dflt) {
        this.initTrace();
        this.doTrace("getFile", "for property " + property);
        String filename = privateProps.getProperty(property, dflt);
        this.doTrace("getFile", "for file " + filename);
        if (filename == null) {
            if (_trace != null) {
                _trace.warningT("getFile", "Property " + property + " not found");
            } else {
                System.out.println("Property " + property + " not found");
            }
            return null;
        }
        return this.getFile2(filename.trim());
    }

    private String getFile2(String filename) {
        this.initTrace();
        File f = new File(filename);
        if (f.isAbsolute()) {
            this.doTrace("getFile", "Found (file is absolute): " + filename);
            return filename;
        }
        if (filename.startsWith("/") || filename.startsWith("\\")) {
            filename = f.getAbsolutePath();
        }
        this.doTrace("getFile2", "Found " + filename);
        return filename;
    }

    public Properties getProperties() {
        return publicProps;
    }

    public InputStream getInputStream(String name) {
        this.initTrace();
        return this.getInputStream_noTrace(name);
    }

    public InputStream getInputStream_noTrace(String name) {
        byte[] data;
        File f = new File(name);
        String fname = f.getName();
        this.doTrace("getInputStream", "requesting file: " + name + ": " + fname);
        if (!fname.equals(name)) {
            if (_trace != null) {
                _trace.warningT("getInputStream", "ignoring path for file '" + name + "'");
            } else {
                System.out.println("Warning: ignoring path for file '" + name + "'");
            }
        }
        if (pcdfiles != null && (data = (byte[])pcdfiles.get(fname)) != null) {
            return new ByteArrayInputStream(data);
        }
        if (_trace != null) {
            _trace.errorT("getInputStream", "file not found '" + name + "'");
        }
        System.err.println("Error: file not found '" + name + "'");
        return null;
    }

    private void initTrace() {
        if (_trace == null && (_trace = InternalUMFactory.getTrace(VERSIONSTRING)) != null && !this.logProp.isEmpty()) {
            Map.Entry entry;
            this.doTrace("initTrace", "========================================");
            this.doTrace("initTrace", "SUMMARAY using the following properties:");
            this.doTrace("initTrace", "========================================");
            Set propSet = this.logProp.entrySet();
            Iterator it = propSet.iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.doTrace("initTrace", (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            this.doTrace("initTrace", "===================================");
            this.doTrace("initTrace", "SUMMARAY using the following files:");
            this.doTrace("initTrace", "===================================");
            propSet = this.logFiles.entrySet();
            it = propSet.iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.doTrace("initTrace", (String)entry.getKey() + " from " + (String)entry.getValue());
            }
            this.doTrace("initTrace", "===================================");
        }
    }

    private void doTrace(String method, String msg) {
        String val;
        if (_trace != null) {
            _trace.debugT(method, msg);
        } else if (privateProps != null && (val = privateProps.getProperty(VERBOSE)) != null && val.equalsIgnoreCase("true")) {
            System.out.println(method + ": " + msg);
        }
    }

    public void init(Properties prop, HashMap files) {
        boolean bReadOnlyProps;
        this.doTrace("init", "UM init with HashMap");
        privateProps = prop;
        String readOnlyProps = prop.getProperty(PROPS_READ_ONLY);
        if (readOnlyProps == null) {
            bReadOnlyProps = true;
        } else if ((readOnlyProps = readOnlyProps.trim()).equalsIgnoreCase("true") || readOnlyProps.equalsIgnoreCase("1")) {
            bReadOnlyProps = true;
        } else if (readOnlyProps.equalsIgnoreCase("false") || readOnlyProps.equalsIgnoreCase("0")) {
            bReadOnlyProps = false;
        } else {
            this.doTrace("init", "Invalid value for property \"ume.properties_readonly\"; using default \"true\"");
            bReadOnlyProps = true;
        }
        if (bReadOnlyProps) {
            publicProps = new ReadOnlyProperties();
            Iterator propKeys = ((Hashtable)privateProps).keySet().iterator();
            while (propKeys.hasNext()) {
                String key = (String)propKeys.next();
                if (UMParameters.isSecureProperty(key)) continue;
                publicProps.setProperty(key, privateProps.getProperty(key));
            }
            if (bReadOnlyProps) {
                ((ReadOnlyProperties)publicProps).lock();
            }
        } else {
            publicProps = privateProps;
        }
        Set keys = files.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.doTrace("init", "loading file = " + (String)it.next());
        }
        pcdfiles.putAll(files);
        this.debugFeature();
    }

    private void debugFeature() {
        String myPropsWhichAreNotFoundFileName = this.get("savePropertiesWhichAreNotFound");
        if (myPropsWhichAreNotFoundFileName != null) {
            try {
                File tempMyPropsWhichAreNotFoundFile = new File(myPropsWhichAreNotFoundFileName);
                if (myPropsWhichAreNotFoundFile.canWrite()) {
                    myPropsWhichAreNotFound = new Properties();
                    myPropsWhichAreNotFoundFile = tempMyPropsWhichAreNotFoundFile;
                }
            }
            catch (Exception ex) {
                System.err.println("tried to write properties which are not found into a file.\nFailure:");
                System.err.println(ex.getMessage());
            }
        }
    }

    private synchronized void writePropertyWhichAreNotFound(String property, String value) {
        if (value == null && myPropsWhichAreNotFound != null) {
            myPropsWhichAreNotFound.setProperty(property, value);
            try {
                myPropsWhichAreNotFound.store(new FileOutputStream(myPropsWhichAreNotFoundFile), "properties which are not found");
            }
            catch (Exception ex) {
                System.err.println("tried to write properties which are not found into a file.\nFailure:");
                System.err.println(ex.getMessage());
            }
        }
    }

    public void addFile(String name, byte[] data) {
        this.doTrace("addFile", "file " + name);
        pcdfiles.put(name, data);
    }

    public String[] listFiles() {
        return pcdfiles.keySet().toArray(new String[0]);
    }

    public void changeProperty(String name, Object value) {
        if (this.changeables == null) {
            this.changeables = new Vector();
            int i = 0;
            while (i < changeableProperties.length) {
                this.changeables.add(changeableProperties[i]);
                ++i;
            }
        }
        if (this.changeables.contains(name)) {
            if (((Hashtable)privateProps).containsKey(name)) {
                ((Hashtable)privateProps).remove(name);
            }
            ((Hashtable)privateProps).put(name, value);
            if (publicProps != privateProps) {
                if (((Hashtable)publicProps).containsKey(name)) {
                    ((Hashtable)publicProps).remove(name);
                }
                ((Hashtable)publicProps).put(name, value);
            }
        }
    }

    public static boolean isSecureProperty(String property) {
        int i = 0;
        while (i < secureProperties.length) {
            String secretProp = secureProperties[i];
            if (secretProp.equals(property)) {
                return true;
            }
            int pos = secretProp.indexOf("*");
            if (pos >= 0 && (pos == 0 ? property.endsWith(secretProp.substring(pos + 1)) : (pos == secretProp.length() - 1 ? property.startsWith(secretProp.substring(0, pos - 1)) : property.startsWith(secretProp.substring(0, pos - 1)) && property.endsWith(secretProp.substring(pos + 1))))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ReadOnlyProperties
    extends Properties {
        boolean _initializing = true;

        ReadOnlyProperties() {
        }

        ReadOnlyProperties(Properties props) {
            this.putAll((Map)props);
            this._initializing = false;
        }

        public void lock() {
            this._initializing = false;
        }

        public void clear() {
            if (this._initializing) {
                super.clear();
            } else {
                this.forbid();
            }
        }

        public void load(InputStream inStream) throws IOException {
            if (this._initializing) {
                super.load(inStream);
            } else {
                this.forbid();
            }
        }

        public Object put(Object key, Object value) {
            if (this._initializing) {
                return super.put(key, value);
            }
            this.forbid();
            return null;
        }

        public void putAll(Map props) {
            if (this._initializing) {
                super.putAll(props);
            } else {
                this.forbid();
            }
        }

        public Object remove(Object key) {
            if (this._initializing) {
                return super.remove(key);
            }
            this.forbid();
            return null;
        }

        public Object setProperty(String key, String value) {
            if (this._initializing) {
                return super.setProperty(key, value);
            }
            this.forbid();
            return null;
        }

        public void forbid() {
            throw new UnsupportedOperationException("Attempt to change UME properties was refused.");
        }
    }

    private static class ec {
        static char[] cs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        static byte[] iv = new byte[]{-100, -32, 107, 21, 28, -81, 37, -83};
        static IUMTrace _trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/UMParameters.java#4 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");

        private ec() {
        }

        static Key getOrCreateKey() throws IOException, NoSuchAlgorithmException {
            String key_file = System.getProperty("ume.crypt.keyfile");
            if (key_file == null) {
                key_file = System.getProperty("user.home") + File.separator + ".keyfile";
            }
            if (new File(key_file).exists()) {
                FileInputStream fis = new FileInputStream(key_file);
                try {
                    return (Key)AccessController.doPrivileged(new PrivilegedExceptionAction(fis){
                        private final /* synthetic */ FileInputStream val$fis;
                        {
                            this.val$fis = val$fis;
                        }

                        public Object run() {
                            return ec.readKeyFromFile(this.val$fis);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    _trace.warningT("ec.getOrCreateKey", "priviledged action exception", e);
                    return null;
                }
            }
            KeyGenerator keyGen = KeyGenerator.getInstance("3DES");
            keyGen.init(SecretKeyGenerator.getRandom());
            SecretKey key = keyGen.generateKey();
            System.out.println("Klasse des generierten Keys ist " + key.getClass().getName());
            FileOutputStream fos = new FileOutputStream(key_file);
            try {
                fos.write(key.getEncoded());
                fos.flush();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                fos.close();
                throw throwable;
            }
            fos.close();
            return key;
        }

        static Key getKey() throws IOException, NoSuchAlgorithmException {
            String key_file = System.getProperty("ume.crypt.keyfile");
            if (key_file == null) {
                key_file = System.getProperty("user.home") + File.separator + ".keyfile";
            }
            if (new File(key_file).exists()) {
                FileInputStream fis = new FileInputStream(key_file);
                try {
                    return (Key)AccessController.doPrivileged(new PrivilegedExceptionAction(fis){
                        private final /* synthetic */ FileInputStream val$fis;
                        {
                            this.val$fis = val$fis;
                        }

                        public Object run() {
                            return ec.readKeyFromFile(this.val$fis);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    _trace.warningT("ec.getKey", "privileged action exception", e);
                    return null;
                }
            }
            throw new RuntimeException("No keyfile present for decryption.");
        }

        static byte[] decrypt(byte[] b, Key key) throws Exception {
            Cipher cipher = Cipher.getInstance("3DES/CBC/PKCS5Padding");
            cipher.init(2, key, new IvParameterSpec(iv));
            byte[] e = cipher.doFinal(b);
            return e;
        }

        static byte[] encrypt(byte[] b, Key key) throws Exception {
            Cipher cipher = Cipher.getInstance("3DES/CBC/PKCS5Padding");
            cipher.init(1, key, new IvParameterSpec(iv));
            byte[] e = cipher.doFinal(b);
            return e;
        }

        public static String d(String s) {
            try {
                if (s != null) {
                    if (s.startsWith("{base64}")) {
                        _trace.debugT("ec.d", "Property is Base64 encoded according to its prefix.");
                        return new String(Base64.decode(s.substring(8)), "UTF8");
                    }
                    if (s.startsWith("{encrypted}")) {
                        _trace.debugT("ec.d", "Property is encrypted according to its prefix.");
                        return new String(ec.decrypt(Base64.decode(s.substring(11)), ec.getOrCreateKey()), "UTF8");
                    }
                    if (s.startsWith("{text}")) {
                        _trace.debugT("ec.d", "Property is cleartext according to its prefix.");
                        return s.substring(6);
                    }
                    _trace.debugT("ec.d", "Property has no prefix. Assuming it's cleartext.");
                    return s;
                }
                _trace.debugT("ec.d", "No parameter value available. Nothing to decrypt.");
                return null;
            }
            catch (UnsupportedEncodingException e) {
                _trace.errorT("ec.d", "unsupported encoding exception", e);
                return null;
            }
            catch (IllegalBlockSizeException e) {
                _trace.infoT("ec.d", "IllegalBlockSizeException ", e);
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                _trace.debugT("ec.d", "Decryption failed because of missing algorithm implementation / wrong JCE provider.", e);
                return null;
            }
            catch (GeneralSecurityException e) {
                _trace.debugT("ec.d", "A general security exception occured during decryption.", e);
                return null;
            }
            catch (IOException e) {
                _trace.errorT("ec.d", "io exception", e);
                return null;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException && -1 != e.toString().indexOf("miscalculated data length!")) {
                    _trace.debugT("ec.d", "An exception occured during Base64 decoding.", e);
                    return null;
                }
                if (e instanceof SecurityException && -1 != e.toString().indexOf("Unsupported keysize or algorithm parameters")) {
                    _trace.debugT("ec.d", "Decryption failed because of missing JCE policy files for strong cryptography.", e);
                    return null;
                }
                _trace.warningT("ec.d", "general exception ", e);
                return null;
            }
        }

        static String e(String s) {
            try {
                return "{encrypted}" + Base64.encode(ec.encrypt(s.getBytes("UTF8"), ec.getOrCreateKey()));
            }
            catch (UnsupportedEncodingException e) {
                if (_trace.beDebug()) {
                    _trace.debugT("e", e);
                }
                return s;
            }
            catch (GeneralSecurityException e) {
                if (_trace.beDebug()) {
                    _trace.debugT("e", e);
                }
                return s;
            }
            catch (IOException e) {
                if (_trace.beDebug()) {
                    _trace.debugT("e", e);
                }
                return s;
            }
            catch (Exception e) {
                if (_trace.beDebug()) {
                    _trace.debugT("e", e);
                }
                return s;
            }
        }

        static Key readKeyFromFile(FileInputStream fis) throws IllegalStateException {
            try {
                Vector<Byte> v = new Vector<Byte>(50);
                try {
                    int i = fis.read();
                    while (i != -1) {
                        v.add(new Byte((byte)i));
                        i = fis.read();
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                byte[] b = new byte[v.size()];
                int ii = 0;
                while (ii < v.size()) {
                    b[ii] = (Byte)v.elementAt(ii);
                    ++ii;
                }
                SecretKeySpec keySpec = new SecretKeySpec(b, 0, b.length, "3DES");
                return keySpec;
            }
            catch (Exception e) {
                _trace.errorT("ec.readKeyFromFile", "general exception ", e);
                throw new IllegalStateException(e.toString());
            }
        }
    }
}

