/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.imp.Util;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class SSOUtils {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/dev/src/_core/java/com/sap/security/core/util/imp/SecurityUtil.java#3 $ from $DateTime: 2003/09/04 10:10:48 $ ($Change: 11822 $)";
    private static IUMTrace _trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/dev/src/_core/java/com/sap/security/core/util/imp/SecurityUtil.java#3 $ from $DateTime: 2003/09/04 10:10:48 $ ($Change: 11822 $)");
    private static final String[] _unallowedR3Users = new String[]{"SAP*", "DDIC"};

    public static String getSSOCookieDomain(String strUserAgent, String domain) {
        String domain1 = UMFactory.getProperties().get("ume.logon.security.cookie_domain");
        int relax_level = UMFactory.getProperties().getNumber("ume.logon.security.relax_domain.level", 1);
        if (relax_level < 1) {
            _trace.infoT("getSSOCookieDomain", "Domain Relax Level in properties is zero or negative.");
            return null;
        }
        boolean bIsInternetExplorer = true;
        if (strUserAgent != null && strUserAgent.indexOf("MSIE") == -1 && strUserAgent.indexOf("msie") == -1) {
            bIsInternetExplorer = false;
        }
        if (null == domain1) {
            int firstdot = domain.indexOf(46);
            int lastdot = domain.lastIndexOf(46);
            int lastdotcolumn = domain.lastIndexOf(58);
            if (-1 != lastdotcolumn) {
                domain = domain.substring(0, lastdotcolumn);
            }
            boolean isIP = true;
            int i = lastdot + 1;
            while (i < domain.length()) {
                if ("1234567890".indexOf(domain.charAt(i)) == -1) {
                    isIP = false;
                    break;
                }
                ++i;
            }
            if (isIP) {
                return null;
            }
            Vector<Integer> v = new Vector<Integer>(5);
            int i2 = 0;
            while (i2 < domain.length()) {
                if (domain.charAt(i2) == '.') {
                    v.add(new Integer(i2));
                }
                ++i2;
            }
            int count = v.size();
            if (count < relax_level + 1) {
                if (firstdot == -1 && lastdot == -1) {
                    domain = null;
                } else if (firstdot != -1 && firstdot < domain.length() - 1 && firstdot != lastdot) {
                    domain = domain.substring(firstdot + (bIsInternetExplorer ? 1 : 0));
                }
            } else {
                domain = domain.substring((Integer)v.elementAt(relax_level - 1) + (bIsInternetExplorer ? 1 : 0));
            }
        } else {
            if (!domain.endsWith(domain1)) {
                _trace.warningT("getCookieDomain", "Setting cookie with different domain than host domain: " + domain + ", " + domain1);
            }
            domain = domain1;
        }
        return domain;
    }

    public static String getSSOCookieDomain(HttpServletRequest req) {
        return SSOUtils.getSSOCookieDomain(req.getHeader("User-Agent"), req.getServerName());
    }

    public static void main(String[] args) {
    }

    public static String filterUnallowedR3Users(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() > 12) {
            _trace.warningT("filterUnallowedR3Users", "Too long for an R/3 user: " + name);
            return null;
        }
        if (name.length() > 0 && name.charAt(name.length() - 1) == ' ') {
            _trace.warningT("filterUnallowedR3Users", "User is ending with spaces: Potential for mix up in R/3: " + name);
            return null;
        }
        String canonicalizedUser = Util.upperCaseABAP(name);
        int i = 0;
        while (i < _unallowedR3Users.length) {
            if (_unallowedR3Users[i].equals(canonicalizedUser)) {
                return null;
            }
            ++i;
        }
        return canonicalizedUser;
    }
}

