/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class PasswordHash {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/PasswordHash.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)";
    public static final IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/PasswordHash.java#3 $ from $DateTime: 2004/07/30 14:01:42 $ ($Change: 16956 $)");
    private String _user = null;
    private String _password = null;
    private String _extra = null;
    public static final String ALGID_SAPSHA = "{SAPSHA}";
    public static final String ALGID_SHA = "{SHA}";
    public static final String ALGID_SSHA = "{SSHA}";

    public PasswordHash(String user, String password) {
        this._user = user;
        this._password = password;
        this._extra = null;
    }

    public PasswordHash(String user, String password, String extra) {
        this._user = user;
        this._password = password;
        this._extra = extra;
    }

    public String getHash() {
        IUMParameters props = UMFactory.getProperties();
        if (props != null && props.getBoolean("ume.admin.password.migration", false) && this._password != null && this._password.startsWith("{")) {
            return this._password;
        }
        byte[] salt = new byte[6];
        Random random = new Random();
        random.nextBytes(salt);
        String hash = this.createHash01(salt);
        if (hash == null) {
            return null;
        }
        return ALGID_SSHA + hash;
    }

    public boolean checkHash(String Hash) {
        if (Hash == null || Hash.length() == 0) {
            return false;
        }
        if (Hash.startsWith(ALGID_SAPSHA)) {
            String myhash = Hash.substring(ALGID_SAPSHA.length(), ALGID_SAPSHA.length() + 28);
            String salt = Hash.substring(ALGID_SAPSHA.length() + 28);
            return myhash.equals(this.createHashOld(salt));
        }
        if (Hash.startsWith(ALGID_SSHA)) {
            String myhash = Hash.substring(ALGID_SSHA.length(), Hash.length());
            byte[] decodedhash = null;
            try {
                decodedhash = Base64.decode(myhash);
            }
            catch (Throwable e) {
                if (mTrace.beInfo()) {
                    mTrace.infoT("checkHash", e);
                }
                return false;
            }
            byte[] salt = new byte[decodedhash.length - 20];
            System.arraycopy(decodedhash, 20, salt, 0, salt.length);
            return myhash.equals(this.createHash01(salt));
        }
        if (Hash.startsWith(ALGID_SHA)) {
            String myhash = Hash.substring(ALGID_SHA.length(), Hash.length());
            byte[] decodedhash = null;
            try {
                decodedhash = Base64.decode(myhash);
            }
            catch (Throwable e) {
                if (mTrace.beInfo()) {
                    mTrace.infoT("checkHash", e);
                }
                return false;
            }
            byte[] salt = new byte[decodedhash.length - 20];
            System.arraycopy(decodedhash, 20, salt, 0, salt.length);
            return myhash.equals(this.createHash01(salt));
        }
        return Hash.equals(this._password);
    }

    private String createHash01(byte[] salt) {
        if (this._password == null) {
            return null;
        }
        byte[] output = null;
        byte[] pass_n_salt = null;
        try {
            output = this._password.getBytes("UTF8");
            pass_n_salt = new byte[output.length + salt.length];
            System.arraycopy(output, 0, pass_n_salt, 0, output.length);
            System.arraycopy(salt, 0, pass_n_salt, output.length, salt.length);
        }
        catch (UnsupportedEncodingException e) {
            if (mTrace.beInfo()) {
                mTrace.infoT("createHash01", "UTF8 encoding not supported.", e);
            }
            return null;
        }
        pass_n_salt = this.sha(pass_n_salt);
        byte[] newpass = new byte[pass_n_salt.length + salt.length];
        System.arraycopy(pass_n_salt, 0, newpass, 0, pass_n_salt.length);
        System.arraycopy(salt, 0, newpass, pass_n_salt.length, salt.length);
        return Base64.encode(newpass);
    }

    private String createHashOld(String salt) {
        byte[] output = null;
        try {
            String smessage = this._password + salt;
            if (this._extra != null) {
                smessage = smessage + this._extra;
            }
            output = smessage.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            if (mTrace.beInfo()) {
                mTrace.infoT("createHashOld", "UTF8 encoding not supported.", e);
            }
            return null;
        }
        output = this.sha(output);
        return Base64.encode(output);
    }

    private byte[] sha(byte[] input) {
        byte[] output = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(input);
            output = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            if (mTrace.beInfo()) {
                mTrace.infoT("sha", "Algorithm not found " + e.getMessage(), e);
            }
            return null;
        }
        return output;
    }

    public static void main(String[] args) {
        PasswordHash pwd1 = new PasswordHash("user1", "secret");
        PasswordHash pwd1b = new PasswordHash("user1", "secret");
        PasswordHash pwd2 = new PasswordHash("user1", "secret2");
        PasswordHash pwd3 = new PasswordHash("user2", "secretx");
        String hash1 = pwd1.getHash();
        String hash1b = pwd1b.getHash();
        String hash2 = pwd2.getHash();
        String hash3 = pwd3.getHash();
        System.out.println(hash1);
        System.out.println(hash1b);
        System.out.println(hash2);
        System.out.println(hash3);
        System.out.println("Check1 (must be true) : " + pwd1.checkHash(hash1));
        System.out.println("Check2 (must be true) : " + pwd1.checkHash(hash1b));
        System.out.println("Check3 (must be false): " + pwd1.checkHash(hash1 + "x"));
        System.out.println("Check4 (must be false): " + pwd1.checkHash(hash2));
        System.out.println("Check5 (must be false): " + pwd1.checkHash(hash3));
        System.out.println("Check6 (must be false): " + pwd1.checkHash(null));
        System.out.println("Check7 (must be false): " + pwd1.checkHash("02:efef"));
        System.out.println("Check8 (must be false): " + pwd1.checkHash("01A"));
    }
}

