/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.imp;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;

public class Certificate {
    X509Certificate cert;
    private static Provider provider = null;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/Certificate.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/imp/Certificate.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    static /* synthetic */ Class array$B;

    public Certificate(HttpServletRequest req) throws CertificateException {
        this.cert = (X509Certificate)req.getAttribute("javax.servlet.request.X509Certificate");
        if (this.cert != null) {
            trace.infoT("mySAPCertificate", "javax.servlet.request.X509Certificate OK");
            return;
        }
        X509Certificate[] certChain = (X509Certificate[])req.getAttribute("javax.net.ssl.peer_certificates");
        if (certChain != null) {
            trace.infoT("mySAPCertificate", "javax.net.ssl.peer_certificates OK");
            this.cert = certChain[0];
            return;
        }
        trace.warningT("mySAPCertificate", "no certificate found");
        this.getCertFromString(req.getHeader("mysapcert"));
        if (this.cert == null) {
            throw new CertificateException("no certificate found");
        }
    }

    public Certificate(String _cert) throws CertificateException {
        this.getCertFromString(_cert);
    }

    private void getCertFromString(String _cert) throws CertificateException {
        if (_cert == null) {
            throw new CertificateException("no certificate found");
        }
        if (!_cert.startsWith("-")) {
            _cert = "-----BEGIN CERTIFICATE-----\r\n" + _cert + "\r\n-----END CERTIFICATE-----\n";
        }
        if (System.getProperty("java.version").startsWith("1.2")) {
            ByteArrayInputStream bais = new ByteArrayInputStream(_cert.getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.cert = (X509Certificate)cf.generateCertificate(bais);
        } else if (provider != null) {
            try {
                Class[] sig1 = new Class[]{array$B == null ? (array$B = Certificate.class$("[B")) : array$B};
                Object[] sig2 = new Object[]{_cert.getBytes()};
                this.cert = (X509Certificate)Class.forName("iaik.x509.X509Certificate").getConstructor(sig1).newInstance(sig2);
            }
            catch (Throwable e) {
                trace.infoT("getCertFromString", "IAIK Security Provider exists, but Certificate initialization failed");
            }
        } else {
            trace.infoT("getCertFromString", "java version=" + System.getProperty("java.version") + ", no IAIK Security provider !");
        }
    }

    public String getSubjectDN() {
        return this.cert.getSubjectDN().toString();
    }

    public String getIssuerDN() {
        return this.cert.getIssuerDN().toString();
    }

    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public String getSubjectHash() {
        return Certificate.convertSubjectToHash(this.cert.getSubjectDN().toString());
    }

    public static String convertSubjectToHash(String subject) {
        byte[] output = null;
        try {
            output = subject.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            trace.errorT("convertSubjectToHash", "UTF8 encoding not supported.,e");
            return null;
        }
        output = Certificate.sha(output);
        String hash = Base64.encode(output);
        return hash;
    }

    private static byte[] sha(byte[] input) {
        byte[] output = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(input);
            output = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            trace.errorT("sha", "Algorithm not found ", e);
            return null;
        }
        return output;
    }

    public static void main(String[] args) {
        String _cert = "MIIB8jCCAVugAwIBAgICBYgwDQYJKoZIhvcNAQEEBQAwLzELMAkGA1UEBhMCREUx\r\nDzANBgNVBAoTBlNBUC1BRzEPMA0GA1UEAxQGU1NPX0NBMB4XDTk4MDUwNDEyNTkzM1oXDTAwMDUwMzEyNTkzM1owMDELMAkGA1UEBhMCREUxDzANBgNVBAoTBlNBUC1B\r\nRzEQMA4GA1UEAxMHRDAyODcxMzBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQD/nM+p645KINgHabaHM+7joEJ6Y6t5MHgFGkCvSDlUtVpLqPg8ZC2TCfXeQ93ZEw04X0Y5\r\nIsy/AIqYsLuCQaYnAgMBAAGjYDBeMB8GA1UdIwQYMBaAFBOXd9tYGfBxgC83vDDPNrxIONKgMB0GA1UdDgQWBBTDes2rJFKBn3G30CpZVZOrT65m1jAOBgNVHQ8BAf8E\r\nBAMCBPAwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQQFAAOBgQBp6SXiLCglUzOAGxo6eiFLc4aTRbn32hsdHhFLxPdHnkBBE8P1+fIwKVQ2OKyVk+r+eJ942zTVEXVz\r\n3n2lxmHc8t7/fywi9Tm1BhVw9up391XK56Q3ocvgNeaAuidwlqolKCZL/WXuihjhW9GKOuTwtY85FdKrN5cJUZqHnVpEJw==";
        try {
            System.out.println(System.getProperty("java.version"));
            Certificate cert = new Certificate(_cert);
            System.out.println(cert.getSubjectDN());
            System.out.println(cert.getSerialNumber());
            System.out.println(cert.getIssuerDN());
            System.out.println(cert.getSubjectHash());
            System.out.println(provider);
            System.in.read();
        }
        catch (Exception e) {
            trace.debugT("main", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            provider = (Provider)Class.forName("iaik.security.provider.IAIK").newInstance();
        }
        catch (Throwable e) {
            trace.errorT("static", "IAIK provider not found!");
        }
        if (provider != null) {
            Security.addProvider(provider);
            trace.infoT("static", "provider added: " + provider.toString());
        }
    }
}

