/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.cache;

import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.cache.ICache;

public class UidMappingCacheManager {
    private static UidMappingCacheManager _instance;
    private static final IUMParameters mySAPProperties;
    private static final int _secondsToLive;
    private ICache _short_long_cache;
    private ICache _long_short_cache;
    private static boolean _cacheDisabled;
    static /* synthetic */ Class class$com$sap$security$core$util$cache$UidMappingCacheManager;

    private UidMappingCacheManager() {
        int capacity = mySAPProperties.getNumber("UM_UIDMAPPING_CACHE_CAPACITY", 5000);
        int maxLifeTime = mySAPProperties.getNumber("UM_UIDMAPPING_CACHE_MAXLIFE_LIFE_TIME", -1);
        if (capacity > 0) {
            this._short_long_cache = InternalUMFactory.getCache(2, capacity, maxLifeTime, this.getClass().getName() + "__short_long_cache");
            this._long_short_cache = InternalUMFactory.getCache(2, capacity, maxLifeTime, this.getClass().getName() + "__long_short_cache");
            _cacheDisabled = false;
        }
    }

    public String getLongUid(String shortuid) {
        String uid;
        if (_cacheDisabled) {
            return null;
        }
        String longuid = (String)this._short_long_cache.get(shortuid);
        if (longuid == null && (uid = (String)this._long_short_cache.get(longuid)) != null) {
            this._long_short_cache.invalidate(longuid);
        }
        return longuid;
    }

    public String getShortUid(String longuid) {
        String luid;
        if (_cacheDisabled) {
            return null;
        }
        String shortuid = (String)this._long_short_cache.get(longuid);
        if (shortuid == null && (luid = (String)this._short_long_cache.get(shortuid)) != null) {
            this._short_long_cache.invalidate(shortuid);
        }
        return shortuid;
    }

    public synchronized void put(String shortuid, String longuid) {
        if (_cacheDisabled) {
            return;
        }
        this._short_long_cache.put(shortuid, longuid, _secondsToLive);
        this._long_short_cache.put(longuid, shortuid, _secondsToLive);
    }

    public synchronized void invalidate(String shortuid) {
        if (_cacheDisabled) {
            return;
        }
        String longuid = this.getLongUid(shortuid);
        if (longuid != null) {
            this._short_long_cache.invalidate(shortuid);
            this._long_short_cache.invalidate(longuid);
        }
    }

    public static synchronized UidMappingCacheManager getInstance() {
        if (null == _instance) {
            Class clazz = class$com$sap$security$core$util$cache$UidMappingCacheManager == null ? (class$com$sap$security$core$util$cache$UidMappingCacheManager = UidMappingCacheManager.class$("com.sap.security.core.util.cache.UidMappingCacheManager")) : class$com$sap$security$core$util$cache$UidMappingCacheManager;
            synchronized (clazz) {
                if (null == _instance) {
                    _instance = new UidMappingCacheManager();
                }
            }
        }
        return _instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mySAPProperties = UMFactory.getProperties();
        _secondsToLive = mySAPProperties.getNumber("UM_UIDMAPPING_CACHE_EXPIRATION_INTERVAL", 600);
        _cacheDisabled = true;
    }
}

