/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.cache;

import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SoftCache
implements ICache {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/cache/SoftCache.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)";
    private Hashtable cache;
    private String name;
    private boolean mInitialized = false;
    private int mMaxLifeTime;
    private int mInitialSize;
    private float mClearRatio;
    private long mHitCount;
    private long mMissCount;
    private long mWriteCount;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/cache/SoftCache.java#2 $ from $DateTime: 2004/04/29 10:35:36 $ ($Change: 15711 $)");

    public void initialize(int initialSize, int maxLifeTimeInSeconds, String owner, boolean useNotification) {
        this.name = "UME_Cache_" + owner;
        if (initialSize <= 0) {
            if (mTrace.beInfo()) {
                mTrace.infoT("initialize", "Initial size for cache (owner=" + owner + ") is negative or 0. Using default 500.");
            }
            this.mInitialSize = 500;
        } else {
            this.mInitialSize = initialSize;
        }
        this.cache = new Hashtable(this.mInitialSize);
        this.mHitCount = 0L;
        this.mMissCount = 0L;
        this.mWriteCount = 0L;
        if (maxLifeTimeInSeconds <= 0) {
            maxLifeTimeInSeconds = -1;
        }
        this.mMaxLifeTime = maxLifeTimeInSeconds;
        this.mInitialized = true;
        try {
            this.mClearRatio = Float.parseFloat(UMFactory.getProperties().get("ume.cache.softreference_cache.clear_ratio", "0.25"));
        }
        catch (NumberFormatException nfex) {
            if (mTrace.beInfo()) {
                mTrace.infoT("initialize", "Property ume.cache.softreference_cache.clear_ratio doesn't contain a float value. Using default: 0.25", nfex);
            }
            this.mClearRatio = 0.25f;
        }
    }

    public boolean clearStatistics() {
        this.mHitCount = 0L;
        this.mMissCount = 0L;
        this.mWriteCount = 0L;
        return true;
    }

    public int getMaxSize() {
        return this.mInitialSize;
    }

    public synchronized long getReadCount() {
        return this.mHitCount + this.mMissCount;
    }

    public synchronized long getWriteCount() {
        return this.mWriteCount;
    }

    public synchronized long getHitCount() {
        return this.mHitCount;
    }

    public synchronized long getLoadCount() {
        long loadCount = 0L;
        boolean finished = false;
        Vector keysToRemove = new Vector();
        while (!finished) {
            loadCount = 0L;
            try {
                Set allKeys = this.cache.keySet();
                Iterator en = allKeys.iterator();
                while (en.hasNext()) {
                    Object currentKey = en.next();
                    SoftReference softRef = (SoftReference)this.cache.get(currentKey);
                    if (softRef == null) continue;
                    Object obj = softRef.get();
                    if (obj != null) {
                        ++loadCount;
                        continue;
                    }
                    if (keysToRemove.contains(currentKey)) continue;
                    keysToRemove.add(currentKey);
                }
                finished = true;
            }
            catch (ConcurrentModificationException ccmex) {
                finished = false;
                if (!mTrace.beDebug()) continue;
                mTrace.debugT("getLoadCount", ccmex);
            }
        }
        int size = keysToRemove.size();
        int i = 0;
        while (i < size) {
            this.invalidate(keysToRemove.elementAt(i));
            ++i;
        }
        return loadCount;
    }

    public synchronized long getMissCount() {
        return this.mMissCount;
    }

    public Enumeration getKeys() {
        return this.cache.keys();
    }

    public synchronized Object get(Object key) {
        if (!this.mInitialized) {
            String errorMessage = "SoftCache not initialized!";
            throw new RuntimeException(errorMessage);
        }
        SoftReference softRef = (SoftReference)this.cache.get(key);
        if (softRef == null) {
            if (mTrace.beInfo()) {
                mTrace.infoT("get", "Missed object \"" + key + "\"");
            }
            ++this.mMissCount;
            return null;
        }
        Object obj = softRef.get();
        if (obj == null) {
            this.cache.remove(key);
            if (mTrace.beInfo()) {
                mTrace.infoT("get", "Removed dangling reference to object \"" + key + "\"");
            }
            ++this.mMissCount;
            return null;
        }
        if (mTrace.beInfo()) {
            mTrace.infoT("get", "Found object \"" + key + "\"");
        }
        EntryWrapper entry = (EntryWrapper)obj;
        if (entry.mTimeOfDeath != -1L && System.currentTimeMillis() > entry.mTimeOfDeath) {
            if (mTrace.beInfo()) {
                mTrace.infoT("get", "Found object \"" + key + "\", but max time to live is exceeded");
            }
            this.cache.remove(key);
            ++this.mMissCount;
            return null;
        }
        obj = entry.mValue;
        ++entry.mAccessCounter;
        ++this.mHitCount;
        return obj;
    }

    public void cleanup() {
    }

    public synchronized void put(Object key, Object entry, int secondsToLive) {
        if (!this.mInitialized) {
            String errorMessage = "SoftCache not initialized!";
            throw new RuntimeException(errorMessage);
        }
        if (this.cache.keySet().size() + 1 > this.mInitialSize) {
            long timeStamp = System.currentTimeMillis();
            boolean done = false;
            while (!done) {
                try {
                    long removeCounter = 0L;
                    ArrayList<EntryWrapper> arl = new ArrayList<EntryWrapper>(this.cache.values().size());
                    if (arl.size() > 0) {
                        EntryWrapper e;
                        SoftReference sr;
                        String k;
                        Enumeration en = this.cache.keys();
                        while (en.hasMoreElements()) {
                            k = (String)en.nextElement();
                            sr = (SoftReference)this.cache.get(k);
                            if (sr != null) {
                                e = (EntryWrapper)sr.get();
                                if (e != null) {
                                    arl.add(e);
                                    continue;
                                }
                                this.cache.remove(k);
                                ++removeCounter;
                                continue;
                            }
                            this.cache.remove(k);
                            ++removeCounter;
                        }
                        EntryComparator ec2 = new EntryComparator();
                        EntryWrapper[] ew = arl.toArray(new EntryWrapper[arl.size()]);
                        Arrays.sort(ew, ec2);
                        long accesslimit = ew[Math.round((float)((float)ew.length * this.mClearRatio))].mAccessCounter;
                        Enumeration en2 = this.cache.keys();
                        while (en2.hasMoreElements()) {
                            k = (String)en2.nextElement();
                            sr = (SoftReference)this.cache.get(k);
                            if (sr != null) {
                                e = (EntryWrapper)sr.get();
                                if (e != null) {
                                    if (e.mAccessCounter > accesslimit) continue;
                                    this.cache.remove(k);
                                    ++removeCounter;
                                    continue;
                                }
                                this.cache.remove(k);
                                ++removeCounter;
                                continue;
                            }
                            this.cache.remove(k);
                            ++removeCounter;
                        }
                    }
                    done = true;
                    if (!mTrace.beInfo()) continue;
                    mTrace.infoT("put", "Limit of " + this.mInitialSize + " exceeded. Removed " + removeCounter + " objects from cache (took " + (System.currentTimeMillis() - timeStamp) + "ms)");
                }
                catch (ConcurrentModificationException cmex) {
                    done = false;
                    if (!mTrace.beInfo()) continue;
                    mTrace.infoT("put", "ConcurrentModificationException while cleaning up the cache. Try to cleanup again...", cmex);
                }
            }
        }
        this.cache.put(key, new SoftReference<EntryWrapper>(new EntryWrapper(entry, secondsToLive)));
        ++this.mWriteCount;
        if (mTrace.beInfo()) {
            mTrace.infoT("put", "Stored object \"" + key + "\"");
        }
    }

    public synchronized void put(Object key, Object entry) {
        this.put(key, entry, this.mMaxLifeTime);
    }

    public boolean invalidateLocally(Object key) {
        return this.invalidate(key);
    }

    public boolean invalidateLocally() {
        return this.invalidate();
    }

    public synchronized boolean invalidate() {
        this.cache = new Hashtable(this.mInitialSize);
        this.mHitCount = 0L;
        this.mMissCount = 0L;
        this.mWriteCount = 0L;
        return true;
    }

    public synchronized boolean invalidate(Object key) {
        boolean found;
        if (!this.mInitialized) {
            String errorMessage = "SoftCache not initialized!";
            throw new RuntimeException(errorMessage);
        }
        boolean bl = found = key != null ? this.cache.containsKey(key) : false;
        if (found) {
            this.cache.remove(key);
        }
        if (mTrace.beInfo()) {
            mTrace.infoT("invalidate", "Invalidate object \"" + key + "\"");
        }
        return found;
    }

    private class EntryWrapper {
        public long mTimeOfDeath;
        public Object mValue;
        public long mAccessCounter;

        public EntryWrapper(Object obj) {
            this.mTimeOfDeath = -1L;
            this.mValue = obj;
            this.mAccessCounter = 0L;
        }

        public EntryWrapper(Object obj, int secondsToLive) {
            this.mTimeOfDeath = secondsToLive > 0 ? System.currentTimeMillis() + (long)(1000 * secondsToLive) : (SoftCache.this.mMaxLifeTime == -1 ? -1L : System.currentTimeMillis() + (long)(1000 * SoftCache.this.mMaxLifeTime));
            this.mValue = obj;
            this.mAccessCounter = 0L;
        }
    }

    private class EntryComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (((EntryWrapper)o1).mAccessCounter < ((EntryWrapper)o2).mAccessCounter) {
                return -1;
            }
            if (((EntryWrapper)o1).mAccessCounter > ((EntryWrapper)o2).mAccessCounter) {
                return 1;
            }
            return 0;
        }
    }
}

