/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.cache;

import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;

public class MostRecentlyUsedCache
implements ICache {
    private int mCapacity;
    private int mTime;
    private Hashtable mIndexByCacheKey;
    private TreeMap mIndexByLastAccess;
    private boolean mInitialized;
    private int mMaxLifeTime;
    private long mHitCount;
    private long mMissCount;
    private long mWriteCount;
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/cache/MostRecentlyUsedCache.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/cache/MostRecentlyUsedCache.java#1 $ from $DateTime: 2004/03/08 16:48:43 $ ($Change: 14741 $)");

    public void cleanup() {
    }

    public void initialize(int initialSize, int maxLifeTimeInSeconds, String owner, boolean useNotification) {
        if (maxLifeTimeInSeconds <= 0) {
            maxLifeTimeInSeconds = -1;
        }
        this.mMaxLifeTime = maxLifeTimeInSeconds;
        if (initialSize <= 0) {
            if (trace.beError()) {
                trace.errorT("initialize", "Initial size for cache (owner=" + owner + ") is negative or 0. Using default 500.");
            }
            this.mCapacity = 500;
        } else {
            this.mCapacity = initialSize;
        }
        this.mInitialized = true;
        this.mTime = 0;
        this.mIndexByCacheKey = new Hashtable();
        this.mHitCount = 0L;
        this.mMissCount = 0L;
        this.mWriteCount = 0L;
        this.mIndexByLastAccess = new TreeMap();
    }

    public Enumeration getKeys() {
        return this.mIndexByCacheKey.keys();
    }

    public boolean clearStatistics() {
        this.mHitCount = 0L;
        this.mMissCount = 0L;
        this.mWriteCount = 0L;
        return true;
    }

    public int getMaxSize() {
        return this.mCapacity;
    }

    public synchronized long getReadCount() {
        return this.mHitCount + this.mMissCount;
    }

    public synchronized long getWriteCount() {
        return this.mWriteCount;
    }

    public long getHitCount() {
        return this.mHitCount;
    }

    public long getLoadCount() {
        return this.mIndexByCacheKey.keySet().size();
    }

    public long getMissCount() {
        return this.mMissCount;
    }

    public synchronized Object get(Object key) {
        if (!this.mInitialized) {
            String errorMessage = "MostRecentlyUsedCache not initialized!";
            if (trace.beError()) {
                trace.errorT("get", errorMessage);
                throw new RuntimeException(errorMessage);
            }
        }
        if (this.mIndexByCacheKey.containsKey(key)) {
            Integer accessTime;
            CacheRecord record = (CacheRecord)this.mIndexByCacheKey.get(key);
            Integer lastAccess = record.AccessTime;
            record.AccessTime = accessTime = this.nextConsecutiveNumber();
            MostRecentlyUsedCache mostRecentlyUsedCache = this;
            synchronized (mostRecentlyUsedCache) {
                this.mIndexByLastAccess.remove(lastAccess);
                this.mIndexByLastAccess.put(accessTime, key);
            }
            long dateofExpiration = record.DateOfExpiration;
            if (dateofExpiration != -1L && dateofExpiration < System.currentTimeMillis()) {
                this.invalidate(key);
                ++this.mMissCount;
                return null;
            }
            ++this.mHitCount;
            return record.Value;
        }
        ++this.mMissCount;
        return null;
    }

    public synchronized void put(Object key, Object entry) {
        if (!this.mInitialized) {
            String errorMessage = "MostRecentlyUsedCache not initialized!";
            if (trace.beError()) {
                trace.errorT("get", errorMessage);
                throw new RuntimeException(errorMessage);
            }
        }
        this.put(key, entry, this.mMaxLifeTime);
    }

    public synchronized void put(Object key, Object entry, int secondsToLive) {
        if (!this.mInitialized) {
            String errorMessage = "MostRecentlyUsedCache not initialized!";
            if (trace.beError()) {
                trace.errorT("get", errorMessage);
                throw new RuntimeException(errorMessage);
            }
        }
        if (key == null || entry == null) {
            return;
        }
        trace.debugT("put", "object" + key + " being stored in cache");
        CacheRecord record = new CacheRecord();
        record.AccessTime = this.nextConsecutiveNumber();
        record.Value = entry;
        if (secondsToLive != -1) {
            record.DateOfExpiration = System.currentTimeMillis() + (long)(secondsToLive * 1000);
        }
        if (this.mIndexByCacheKey.containsKey(key)) {
            Integer lastAccess = ((CacheRecord)this.mIndexByCacheKey.get((Object)key)).AccessTime;
            this.mIndexByLastAccess.remove(lastAccess);
        } else if (this.mIndexByCacheKey.size() >= this.mCapacity) {
            Integer lruTime = (Integer)this.mIndexByLastAccess.firstKey();
            Object lruKey = this.mIndexByLastAccess.remove(lruTime);
            this.mIndexByCacheKey.remove(lruKey);
        }
        this.mIndexByCacheKey.put(key, record);
        this.mIndexByLastAccess.put(record.AccessTime, key);
        ++this.mWriteCount;
    }

    public boolean invalidate() {
        this.mTime = 0;
        this.mIndexByCacheKey = new Hashtable();
        this.mHitCount = 0L;
        this.mMissCount = 0L;
        this.mWriteCount = 0L;
        this.mIndexByLastAccess = new TreeMap();
        return true;
    }

    public boolean invalidateLocally(Object key) {
        return this.invalidate(key);
    }

    public boolean invalidateLocally() {
        return this.invalidate();
    }

    public boolean invalidate(Object key) {
        if (!this.mInitialized) {
            String errorMessage = "MostRecentlyUsedCache not initialized!";
            if (trace.beError()) {
                trace.errorT("get", errorMessage);
                throw new RuntimeException(errorMessage);
            }
        }
        trace.debugT("get", "object" + key + " being expired in cache");
        if (this.mIndexByCacheKey.containsKey(key)) {
            MostRecentlyUsedCache mostRecentlyUsedCache = this;
            synchronized (mostRecentlyUsedCache) {
                this.mIndexByLastAccess.remove(((CacheRecord)this.mIndexByCacheKey.remove((Object)key)).AccessTime);
            }
            return true;
        }
        return false;
    }

    private synchronized Integer nextConsecutiveNumber() {
        this.mTime = this.mTime < Integer.MAX_VALUE ? ++this.mTime : this.restartNumbering();
        return new Integer(this.mTime);
    }

    private int restartNumbering() {
        int counter = 0;
        Integer counterObj = null;
        Integer[] oldKeys = this.mIndexByLastAccess.keySet().toArray(new Integer[0]);
        int i = 0;
        while (i < oldKeys.length) {
            counterObj = new Integer(counter++);
            Object key = this.mIndexByLastAccess.remove(oldKeys[i]);
            this.mIndexByLastAccess.put(counterObj, key);
            ((CacheRecord)this.mIndexByCacheKey.get(key)).AccessTime = counterObj;
            ++i;
        }
        this.mTime = counter;
        return counter;
    }

    private class CacheRecord {
        Integer AccessTime;
        Object Value;
        long DateOfExpiration;

        private CacheRecord() {
        }
    }
}

