/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.cache;

import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.CacheAdmin;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.CacheNotAvailableException;
import com.sap.ip.basecomps.cache.InvalidHandleException;
import com.sap.ip.basecomps.cache.NotARetrievableObjectException;
import com.sap.ip.basecomps.cache.ObjectExistsException;
import com.sap.ip.basecomps.cache.ObjectNotFoundException;
import com.sap.ip.basecomps.cache.StatisticEntry;
import com.sap.security.api.UMFactory;
import com.sap.security.api.UMRuntimeException;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.cache.ICache;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class BaseTechCacheWrapper
implements ICache {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/cache/BaseTechCacheWrapper.java#3 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)";
    private String mCacheID;
    private CacheAccess mCacheAccess;
    private StatisticEntry mStatistics;
    private int mInitialSize;
    private Attributes mDefaultAttributes;
    private static IUMTrace mTrace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/cache/BaseTechCacheWrapper.java#3 $ from $DateTime: 2004/09/10 10:01:00 $ ($Change: 17287 $)");

    private CacheAccess getCacheAccess() {
        try {
            return CacheAccess.getAccess((String)this.mCacheID);
        }
        catch (CacheException ce) {
            throw new UMRuntimeException((Throwable)ce, "Cannot get access to BaseTech Cache \"" + this.mCacheID + "\"");
        }
    }

    public void cleanup() {
        CacheAdmin.cleanup();
    }

    public Object get(Object key) {
        try {
            return this.mCacheAccess.get(key);
        }
        catch (NotARetrievableObjectException naroex) {
            if (mTrace.beDebug()) {
                mTrace.debugT("get", naroex);
            }
            return null;
        }
        catch (InvalidHandleException ihex) {
            if (mTrace.beDebug()) {
                mTrace.debugT("get", ihex);
            }
            return null;
        }
        catch (ObjectNotFoundException onfex) {
            if (mTrace.beDebug()) {
                mTrace.debugT("get", onfex);
            }
            return null;
        }
    }

    public boolean clearStatistics() {
        this.mStatistics.reset();
        return true;
    }

    public int getMaxSize() {
        return this.mInitialSize;
    }

    public boolean invalidate() {
        try {
            this.mCacheAccess.destroy();
            this.mStatistics.reset();
        }
        catch (CacheException ce) {
            throw new UMRuntimeException((Throwable)ce, "Cannot invalidate BaseTech Cache \"" + this.mCacheID + "\"");
        }
        return true;
    }

    public boolean invalidateLocally(Object key) {
        try {
            this.mCacheAccess.delete(key);
        }
        catch (CacheException ce) {
            throw new UMRuntimeException((Throwable)ce, "Cannot invalidate object \"" + key + "\" locally in BaseTech Cache \"" + this.mCacheID + "\"");
        }
        return true;
    }

    public boolean invalidateLocally() {
        try {
            this.mCacheAccess.delete();
            this.mStatistics.reset();
        }
        catch (CacheException ce) {
            throw new UMRuntimeException((Throwable)ce, "Cannot invalidate BaseTech Cache \"" + this.mCacheID + "\" locally.");
        }
        return true;
    }

    public boolean invalidate(Object key) {
        try {
            this.mCacheAccess.destroy(key);
        }
        catch (CacheException ce) {
            throw new UMRuntimeException((Throwable)ce, "Cannot invalidate object \"" + key + "\" in BaseTech Cache \"" + this.mCacheID + "\"");
        }
        return true;
    }

    public void put(Object key, Object entry, int secondsToLive) {
        Attributes attrs = null;
        if (secondsToLive <= 0) {
            attrs = this.mDefaultAttributes;
        } else {
            Properties props = new Properties();
            ((Hashtable)props).put("lifetime", "" + secondsToLive * 1000);
            ((Hashtable)props).put("weight", "1");
            attrs = new Attributes(props);
        }
        try {
            this.mCacheAccess.delete(key);
            try {
                this.mCacheAccess.put(key, attrs, entry);
            }
            catch (ObjectExistsException oeex) {
                if (mTrace.beDebug()) {
                    mTrace.debugT("put", oeex);
                }
                this.mCacheAccess.delete(key);
                try {
                    this.mCacheAccess.put(key, attrs, entry);
                }
                catch (ObjectExistsException oeex2) {
                    if (mTrace.beInfo()) {
                        mTrace.infoT("put", "Second put of object failed.", oeex2);
                    }
                }
            }
        }
        catch (CacheException ce) {
            throw new UMRuntimeException((Throwable)ce, "Cannot put object \"" + key + "\" in BaseTech Cache \"" + this.mCacheID + "\"");
        }
    }

    public long getReadCount() {
        return this.mStatistics.getReadCount();
    }

    public long getWriteCount() {
        return this.mStatistics.getWriteCount();
    }

    public long getHitCount() {
        return this.mStatistics.getHitCount();
    }

    public long getLoadCount() {
        try {
            return this.mCacheAccess.getAttributes().getRealWeight();
        }
        catch (CacheException cex) {
            if (mTrace.beDebug()) {
                mTrace.debugT("getLoadCount", cex);
            }
            return -1L;
        }
    }

    public long getMissCount() {
        return this.mStatistics.getMissCount();
    }

    public void put(Object key, Object entry) {
        this.put(key, entry, -1);
    }

    public void initialize(int initialSize, int maxLifeTimeInSeconds, String owner, boolean useNotification) {
        Properties allInOne = new Properties();
        IUMParameters params = UMFactory.getProperties();
        if (useNotification) {
            String serviceDomainName = params.get("ume.cache.distributable_cache.service_domain_name", "UME_ServiceDomain");
            String serviceDomainHost = params.get("ume.cache.distributable_cache.service_domain_host", "localhost");
            int serviceDomainPort = params.getNumber("ume.cache.distributable_cache.service_domain_port", 9999);
            String consistencyDomainName = params.get("ume.cache.distributable_cache.consistency_domain_name", "UME_ConsistencyDomain");
            String consistencyDomainClass = params.get("ume.cache.distributable_cache.consistency_domain_class");
            allInOne.setProperty("consistency-domain.domain.name", serviceDomainName);
            allInOne.setProperty("consistency-domain.domain.host", serviceDomainHost);
            allInOne.setProperty("consistency-domain.domain.port", "" + serviceDomainPort);
            allInOne.setProperty("consistency-domain.name", consistencyDomainName);
            if (consistencyDomainClass != null) {
                allInOne.setProperty("consistency-domain.class", consistencyDomainClass);
            } else {
                allInOne.setProperty("consistency-domain.class", "com.sap.ip.basecomps.consistency.impl.None");
            }
        } else {
            allInOne.setProperty("consistency-domain.class", "com.sap.ip.basecomps.consistency.impl.None");
        }
        if (maxLifeTimeInSeconds <= 0) {
            allInOne.setProperty("lifetime", "-1");
        } else {
            allInOne.setProperty("lifetime", "" + 1000 * maxLifeTimeInSeconds);
        }
        if (initialSize <= 0) {
            if (mTrace.beInfo()) {
                mTrace.infoT("initialize", "Initial size for cache (owner=" + owner + ") is negative or 0. Using default 500.");
            }
            initialSize = 500;
        }
        allInOne.setProperty("maxweight", "" + initialSize);
        Properties props = new Properties();
        if (maxLifeTimeInSeconds > 0) {
            ((Hashtable)props).put("lifetime", "" + maxLifeTimeInSeconds * 1000);
        } else {
            ((Hashtable)props).put("lifetime", "-1");
        }
        ((Hashtable)props).put("weight", "1");
        this.mDefaultAttributes = new Attributes(props);
        this.mInitialSize = initialSize;
        Attributes attr = new Attributes(allInOne);
        this.mCacheID = "UME_Cache_" + owner;
        try {
            CacheAccess.defineRegion((String)this.mCacheID, (Attributes)attr);
        }
        catch (CacheNotAvailableException cnaex) {
            throw new UMRuntimeException((Throwable)cnaex, "BaseTech Cache creation failed. generated ID: \"" + this.mCacheID + "\"");
        }
        catch (ObjectExistsException oee) {
            if (mTrace.beDebug()) {
                mTrace.debugT("initialize", oee);
            }
        }
        catch (CacheException cnaex) {
            throw new UMRuntimeException((Throwable)cnaex, "BaseTech Cache exception generated ID: \"" + this.mCacheID + "\"");
        }
        this.mCacheAccess = this.getCacheAccess();
        this.mStatistics = this.mCacheAccess.getRegionStatistics();
    }

    public Enumeration getKeys() {
        throw new UnsupportedOperationException("BaseTech Cache doesn't support the getKeys() functionality!");
    }
}

