/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util.batch;

import com.sap.security.api.AttributeValueAlreadyExistsException;
import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalSet;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserAccount;
import com.sap.security.api.IUserAccountFactory;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserMaint;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.InvalidPasswordException;
import com.sap.security.api.NoSuchGroupException;
import com.sap.security.api.NoSuchRoleException;
import com.sap.security.api.PrincipalIterator;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.umap.system.ISystemLandscapeWrapper;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.admin.UserAdminHelper;
import com.sap.security.core.imp.UserSearchFilter;
import com.sap.security.core.role.IScopeDefinition;
import com.sap.security.core.role.IServiceAction;
import com.sap.security.core.role.IServiceRepository;
import com.sap.security.core.role.NoSuchActionException;
import com.sap.security.core.role.imp.PermissionRoles;
import com.sap.security.core.role.imp.RoleUtils;
import com.sap.security.core.util.Base64;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.Message;
import com.sap.security.core.util.batch.BatchException;
import com.sap.security.core.util.batch.BatchMessagesBean;
import com.sap.security.core.util.notification.SendMailAsynch;
import com.sap.security.core.util.taglib.EncodeHtmlTag;
import com.sapmarkets.tpd.TradingPartnerDirectoryCommon;
import com.sapmarkets.tpd.master.PartnerID;
import com.sapmarkets.tpd.master.PartnerResultSet;
import com.sapmarkets.tpd.master.TradingPartnerDirectoryInterface;
import com.sapmarkets.tpd.master.TradingPartnerInterface;
import com.sapmarkets.tpd.util.TpdException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class Batch {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/batch/Batch.java#8 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/batch/Batch.java#8 $ from $DateTime: 2005/01/27 17:07:03 $ ($Change: 17889 $)");
    private static final IUMParameters mySAPProperties = UMFactory.getProperties();
    public static final String CompanyName = "org_id";
    public static final String CompanyID = "org_unique_id";
    public static final String OrgUnit = "org_unit";
    public static final String InternalUID = "internaluid";
    public static final String DisplayName = "uid";
    public static final String Role = "role";
    public static final String Email = "email_address";
    public static final String FirstName = "first_name";
    public static final String LastName = "last_name";
    public static final String JobTitle = "job_title";
    public static final String Country = "country";
    public static final String Language = "language";
    public static final String TimeZone = "time_zone";
    public static final String Currency = "currency";
    public static final String Street = "street";
    public static final String City = "city";
    public static final String State = "state";
    public static final String Province = "province";
    public static final String Zip = "zip";
    public static final String Telephone = "telephone";
    public static final String Fax = "fax";
    public static final String Password = "password";
    public static final String Name = "name";
    public static final String Status = "status";
    public static final String Warnings = "warnings";
    public static final String Mobile = "mobile";
    public static final String Department = "department";
    public static final String UniqueUserID = "UniqueUserID";
    public static final String Title = "title";
    public static final String Telephone_ext = "telephone_ext";
    public static final String Fax_ext = "fax_ext";
    public static final String Building = "building";
    public static final String Room = "room";
    public static final String InhousePost = "inHouseMail";
    public static final String AcademicGrade = "academicTitle";
    public static final String IsManager = "isManager";
    public static final String Floor = "floor";
    public static final String Salutation = "salutation";
    public static final String GROUPNAME = "gid";
    public static final String GROUPDESC = "gdesc";
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ROLENAME = "rid";
    public static final String ROLEDESC = "rdesc";
    public static final String ACTION = "action";
    public static final String CERT = "cert";
    public static final String ALL_ATTRIBUTES = "org_id:org_unit:internaluid:uid:role:email_address:first_name:last_name:job_title:country:language:time_zone:currency:street:city:state:province:zip:telephone:fax:password:name:status:warnings:telephone_ext:fax_ext:building:room:inHouseMail:academicTitle:isManager:floor:salutation:org_unique_id:gdesc:gid:user:group:rdesc:rid:action:cert:department:mobile";
    public static final String CREATED = "CREATED";
    public static final String FAILED = "FAILED";
    public static final String UPDATED = "UPDATED";
    public static final String UPDATE_FAILED = "UPDATE FAILED";
    public static final String EXISTS = "EXISTS";
    public static final String NO_PERMISSION = "NO PERMISSION";
    public static final String UM_NAMESPACE = "UM";
    private String userOrGroup = "user";
    private boolean overwrite = false;
    private IUser performer;
    private String performersCompanyId;
    private BufferedWriter writer;
    private HashMap cachedTPs = new HashMap();
    private long lastRunTime = 0L;
    private TradingPartnerDirectoryInterface tpd;
    private BatchMessagesBean msgs;
    public static final String orgUnitAdapterKey = "UM_ORGUNIT_ADAPTERID";
    public static final String orgUnitSysIdKey = "UM_ORGUNIT_SYSID";
    public static final String orgUnitScopeKey = "UM_ORGUNIT_SCOPE";
    public static final String BINARY = "{BINARY}";
    public static final String X509 = "{X.509}";
    private HashMap principalsetToRemoveMap = new HashMap();
    private HashMap principalsetToAddMap = new HashMap();

    public boolean areUsersBeingImported() {
        return this.userOrGroup.equals(USER);
    }

    private IUserFactory userFactory() {
        return UMFactory.getUserFactory();
    }

    private IUserAccountFactory userAccountFactory() {
        return UMFactory.getUserAccountFactory();
    }

    public long getLastRunTime() {
        return this.lastRunTime;
    }

    public Batch(IUser _performer, boolean _overwrite) throws BatchException {
        if (!UserAdminHelper.hasAccess(_performer, "BATCH_ADMIN")) {
            // empty if block
        }
        this.overwrite = _overwrite;
        this.performer = _performer;
        this.performersCompanyId = _performer.getCompany();
        this.tpd = TradingPartnerDirectoryCommon.getTPD();
        this.writer = null;
        this.msgs = new BatchMessagesBean(_performer.getLocale());
    }

    public Batch(IUser _performer, BufferedWriter _writer) throws BatchException {
        if (!UserAdminHelper.hasAccess(_performer, "BATCH_ADMIN")) {
            throw new BatchException(this.msgs.print(new Message("USER_X_NO_PERMISSION", _performer.getDisplayName())));
        }
        this.overwrite = false;
        this.performer = _performer;
        this.tpd = TradingPartnerDirectoryCommon.getTPD();
        this.writer = _writer;
        this.msgs = new BatchMessagesBean(_performer.getLocale());
    }

    private IRoleFactory getRoleFactory(TradingPartnerInterface tp) {
        return UMFactory.getRoleFactory();
    }

    public Vector lineUploader(BufferedReader reader) throws IOException, BatchException {
        double startTime = Calendar.getInstance().getTime().getTime();
        String line = "";
        int lineCounter = 0;
        int userCounter = 0;
        int eqPos = 0;
        String lvalue = "";
        String rvalue = "";
        Vector results = new Vector();
        int badLinesCounter = 0;
        HashMap<String, Object> usertemp = new HashMap<String, Object>();
        do {
            StringTokenizer rolet;
            if (badLinesCounter > 100) {
                trace.warningT("Batch:lineUpload", "max bad lines exceeded!");
                throw new BatchException(this.msgs.print(new Message("TOO_MANY_BAD_LINES")));
            }
            if (lineCounter > 10 && lineCounter > userCounter * 50) {
                trace.warningT("Batch:lineUpload", "Heuristic plausibility check failed: file must be in wrong format!");
                throw new BatchException(this.msgs.print(new Message("PLAUS_CHECK_FAILED")));
            }
            line = reader.readLine();
            if (userCounter == 0 && line.indexOf("[") >= line.indexOf("]")) {
                trace.warningT("Batch:lineUpload", "File must be in wrong format: should start with [user] delimeter!");
                throw new BatchException(this.msgs.print(new Message("NO_USER_DELIMETER")));
            }
            ++lineCounter;
            if (line != null && line.length() == 0) continue;
            if (line == null || line.indexOf("[") < line.indexOf("]")) {
                if (line != null) {
                    if (line.toLowerCase().indexOf(USER) != -1) {
                        this.userOrGroup = USER;
                    } else if (line.toLowerCase().indexOf(GROUP) != -1) {
                        this.userOrGroup = GROUP;
                    } else if (line.toLowerCase().indexOf(Role) != -1) {
                        this.userOrGroup = Role;
                    } else {
                        throw new BatchException(this.msgs.print(new Message("DELIMETER_X_NOT_SUPPORTED", EncodeHtmlTag.encode(line))));
                    }
                }
                ++userCounter;
                if (usertemp.size() < 1) continue;
                try {
                    if (this.userOrGroup.equals(USER)) {
                        this.createBatchUser(usertemp, false);
                    } else if (this.userOrGroup.equals(GROUP)) {
                        this.createBatchGroup(usertemp);
                    } else {
                        this.createBatchRole(usertemp);
                    }
                }
                catch (Exception e) {
                    usertemp.put(Status, FAILED);
                    StringWriter sw = new StringWriter();
                    PrintWriter pwr = new PrintWriter(sw);
                    trace.infoT("lineUploader", e);
                    pwr.flush();
                    pwr.close();
                    trace.warningT("lineUploader", sw.getBuffer().toString());
                    this.addWarning(usertemp, this.msgs.print(new Message("ERROR_X", e.getMessage())));
                }
                results.add(usertemp);
                usertemp = new HashMap();
                continue;
            }
            if (userCounter <= 0) continue;
            eqPos = line.indexOf("=");
            if (eqPos == -1) {
                this.addWarning(usertemp, this.msgs.print(new Message("WARN_INVALID_LINE_NOEQ_X", new Integer(lineCounter).toString())));
                ++badLinesCounter;
                continue;
            }
            lvalue = line.substring(0, eqPos).trim();
            if (lvalue.indexOf(":") == -1) {
                lvalue = lvalue.toLowerCase();
            }
            rvalue = line.substring(eqPos + 1, line.length()).trim();
            if (ALL_ATTRIBUTES.indexOf(lvalue) == -1 && lvalue.indexOf(":") == -1) {
                Object[] params = new Object[]{lvalue, new Integer(lineCounter).toString()};
                this.addWarning(usertemp, this.msgs.print(new Message("WARN_UNKNOWN_ATT_X_X", params)));
                ++badLinesCounter;
            }
            if (lvalue.indexOf(":") != -1) {
                Vector attVector = (Vector)usertemp.get(lvalue);
                if (attVector == null) {
                    Vector<String> newVector = new Vector<String>();
                    newVector.add(rvalue);
                    usertemp.put(lvalue, newVector);
                    continue;
                }
                attVector.add(rvalue);
                usertemp.put(lvalue, attVector);
                continue;
            }
            if (lvalue.equals(Role)) {
                Vector<String> roleVector = (Vector<String>)usertemp.get(lvalue);
                if (roleVector == null) {
                    roleVector = new Vector<String>();
                }
                if (rvalue != null) {
                    rolet = new StringTokenizer(rvalue, ";");
                    while (rolet.hasMoreElements()) {
                        roleVector.add(((String)rolet.nextElement()).trim());
                    }
                }
                usertemp.put(lvalue, roleVector);
                continue;
            }
            if (lvalue.equals(CERT)) {
                Vector<String> certVector = (Vector<String>)usertemp.get(lvalue);
                if (certVector == null) {
                    certVector = new Vector<String>();
                }
                if (rvalue == null) continue;
                certVector.add(rvalue);
                usertemp.put(lvalue, certVector);
                continue;
            }
            if (lvalue.equals(USER) && (this.userOrGroup.equals(GROUP) || this.userOrGroup.equals(Role))) {
                HashSet<String> userHashSet = (HashSet<String>)usertemp.get(lvalue);
                if (userHashSet == null) {
                    userHashSet = new HashSet<String>();
                }
                if (rvalue != null) {
                    rolet = new StringTokenizer(rvalue, ";");
                    while (rolet.hasMoreElements()) {
                        userHashSet.add(((String)rolet.nextElement()).trim());
                    }
                }
                usertemp.put(lvalue, userHashSet);
                continue;
            }
            if (lvalue.equals(GROUP)) {
                Vector<String> groupVector = (Vector<String>)usertemp.get(lvalue);
                if (groupVector == null) {
                    groupVector = new Vector<String>();
                }
                if (rvalue != null) {
                    StringTokenizer groupt = new StringTokenizer(rvalue, ";");
                    while (groupt.hasMoreElements()) {
                        groupVector.add(((String)groupt.nextElement()).trim());
                    }
                }
                usertemp.put(lvalue, groupVector);
                continue;
            }
            if (lvalue.equals(ACTION) && this.userOrGroup.equals(Role)) {
                Vector<String> actionVector = (Vector<String>)usertemp.get(lvalue);
                if (actionVector == null) {
                    actionVector = new Vector<String>();
                }
                if (rvalue != null) {
                    StringTokenizer actiont = new StringTokenizer(rvalue, ";");
                    while (actiont.hasMoreElements()) {
                        actionVector.add(((String)actiont.nextElement()).trim());
                    }
                }
                usertemp.put(lvalue, actionVector);
                continue;
            }
            if (rvalue.length() > 0) {
                usertemp.put(lvalue, rvalue);
                continue;
            }
            usertemp.put(lvalue, null);
        } while (line != null);
        this.doPrincipalSets(results);
        reader.close();
        this.lastRunTime = Math.round(((double)Calendar.getInstance().getTime().getTime() - startTime) / 1000.0);
        if (this.lastRunTime == 0L) {
            this.lastRunTime = 1L;
        }
        if (lineCounter > 0 && userCounter == 0) {
            trace.warningT("Batch:lineUpload", "No (valid) user data found, file might be in wrong format");
            throw new BatchException(this.msgs.print(new Message("NO_VALID_DATA")));
        }
        return results;
    }

    public Vector EBPLineUploader(BufferedReader reader, boolean mapRoles) throws IOException, BatchException, TpdException {
        double startTime = Calendar.getInstance().getTime().getTime();
        String line = "";
        int lineCounter = 0;
        int userCounter = -1;
        Vector results = new Vector();
        HashMap<String, Object> usertemp = new HashMap<String, Object>();
        usertemp.put(Warnings, "");
        TradingPartnerInterface companyOfPerformer = this.tpd.getPartner(PartnerID.instantiatePartnerID((String)this.performer.getCompany()));
        while ((line = reader.readLine()) != null) {
            ++lineCounter;
            ++userCounter;
            if ((line = line.trim()).length() == 0) continue;
            StringTokenizer t = new StringTokenizer(line, ";", true);
            int counter = 1;
            while (t.hasMoreTokens()) {
                String value = t.nextToken();
                if (value.equals(";")) {
                    ++counter;
                    continue;
                }
                switch (counter) {
                    case 1: {
                        usertemp.put(DisplayName, value);
                        break;
                    }
                    case 2: {
                        usertemp.put(LastName, value);
                        break;
                    }
                    case 3: {
                        usertemp.put(OrgUnit, value);
                        break;
                    }
                    case 4: {
                        usertemp.put(Email, value);
                        break;
                    }
                    case 5: {
                        usertemp.put(Country, value);
                        break;
                    }
                    case 6: {
                        usertemp.put(FirstName, value);
                        break;
                    }
                    case 7: {
                        usertemp.put(Telephone, value);
                        break;
                    }
                    case 8: {
                        String ph = (String)usertemp.get(Telephone);
                        if (ph == null) {
                            ph = "";
                        }
                        usertemp.put(Telephone, ph + value);
                        break;
                    }
                    case 9: {
                        usertemp.put(Fax, value);
                        break;
                    }
                    case 10: {
                        String f = (String)usertemp.get(Fax);
                        if (f == null) {
                            f = "";
                        }
                        usertemp.put(Fax, f + value);
                        break;
                    }
                    case 11: {
                        usertemp.put(Building, value);
                        break;
                    }
                    case 12: {
                        usertemp.put(Room, value);
                        break;
                    }
                    case 13: {
                        usertemp.put(InhousePost, value);
                        break;
                    }
                    case 14: {
                        usertemp.put(AcademicGrade, value);
                        break;
                    }
                    case 15: {
                        usertemp.put(Salutation, value);
                        break;
                    }
                    case 16: {
                        usertemp.put(IsManager, value);
                        break;
                    }
                    case 17: {
                        Vector<String> roles = new Vector<String>();
                        if (!mapRoles) {
                            roles.add(value);
                        } else {
                            Vector<String> v = new Vector<String>();
                            v.add(value);
                            try {
                                Iterator SRMRoles = RoleUtils.heuristicActionsToRolesMapper(((AbstractList)v).iterator(), companyOfPerformer, false);
                                while (SRMRoles.hasNext()) {
                                    roles.add(((IRole)SRMRoles.next()).getDisplayName());
                                }
                            }
                            catch (Exception e) {
                                roles.add(value + " " + this.msgs.print(new Message("ROLE_CANT_BE_MAPPED")));
                            }
                        }
                        usertemp.put(Role, roles);
                        break;
                    }
                    case 18: {
                        usertemp.put(Floor, value);
                    }
                }
            }
            if (companyOfPerformer != null) {
                usertemp.put(CompanyName, companyOfPerformer.getDisplayName());
            }
            if (counter < 2) {
                throw new BatchException(this.msgs.print(new Message("EBP_WRONG_FORMAT")));
            }
            try {
                this.createBatchUser(usertemp, true);
            }
            catch (Exception e) {
                usertemp.put(Status, this.msgs.print(new Message(FAILED)));
                StringWriter sw = new StringWriter();
                PrintWriter pwr = new PrintWriter(sw);
                trace.infoT("createBatchUser", e);
                pwr.flush();
                pwr.close();
                trace.warningT("EBPLineUploader", sw.getBuffer().toString());
                Object[] params = new Object[]{e.getMessage(), new Integer(lineCounter).toString()};
                Message msgg = new Message("ERROR_X_AT_LINE_X", params);
                String sss = this.msgs.print(msgg);
                this.addWarning(usertemp, sss);
            }
            results.add(usertemp);
            usertemp = new HashMap();
        }
        HashMap tempmap = new HashMap();
        String records = "";
        if (results != null) {
            int j = 0;
            while (j < results.size()) {
                tempmap = (HashMap)results.elementAt(j);
                Iterator keys = tempmap.keySet().iterator();
                String record = "";
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    record = key.equals(Password) ? record + " " + key + " = pwd n/a in trace" : (key.equals(Role) || key.indexOf(":") != -1 ? record + " " + key + "=" + ((Vector)tempmap.get(key)).toString() : record + " " + key + "=" + (String)tempmap.get(key));
                }
                records = records + record + "\n\n";
                ++j;
            }
        }
        trace.debugT("<<<<<<<<<<<<<<<<<<<<<<<<<<Batch protocol>>>>>>>>>>>>>>>>>>>>>>>>>>", "");
        trace.debugT("Batch user records: ", records);
        reader.close();
        this.lastRunTime = Math.round(((double)Calendar.getInstance().getTime().getTime() - startTime) / 1000.0);
        if (this.lastRunTime == 0L) {
            this.lastRunTime = 1L;
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    private void createBatchUser(HashMap hashUser, boolean ebp) throws BatchException, UMException, TpdException {
        block181: {
            block178: {
                dispName = (String)hashUser.get("uid");
                if (dispName == null || dispName.length() == 0) {
                    throw new BatchException(this.msgs.print(new Message("UID_EMPTY")));
                }
                user = null;
                password = null;
                createdOrUpdated = " created ";
                ua = null;
                value = null;
                rf = this.getRoleFactory(null);
                gf = UMFactory.getGroupFactory();
                roleSet = new Vector<E>();
                groupSet = new Vector<E>();
                exists = true;
                umaps = new HashMap<String, HashMap<String, String>>();
                uniqueIDOfUser = null;
                try {
                    usf = this.userFactory().getUserSearchFilter();
                    usf.setUniqueName(dispName, 0, false);
                    sr = this.userFactory().searchUsers(usf);
                    v0 = exists = sr.size() == 1;
                    if (exists) {
                        uniqueIDOfUser = (String)sr.next();
                    }
                }
                catch (UMException nsue) {
                    exists = false;
                }
                if (!(hashUser.get("email_address") != null && ((String)hashUser.get("email_address")).trim().length() != 0 || exists)) {
                    throw new BatchException(this.msgs.print(new Message("EMAIL_EMPTY")));
                }
                if (!hashUser.containsKey("org_id") && !hashUser.containsKey("org_unique_id")) {
                    if (this.performersCompanyId == null) {
                        if (!UserAdminHelper.hasAccess(this.performer, "BATCH_ADMIN")) {
                            hashUser.put("status", "NO PERMISSION");
                            this.addWarning(hashUser, this.msgs.print(new Message("INDIV_USER_NO_PERMISSION", this.performer.getDisplayName())));
                            return;
                        }
                    } else if (!UserAdminHelper.hasAccess(this.performer, "MANAGE_ALL_COMPANIES")) {
                        hashUser.put("status", "NO PERMISSION");
                        params = new Object[]{this.performer.getDisplayName(), this.performer.getCompany()};
                        this.addWarning(hashUser, this.msgs.print(new Message("USER_X_OF_COMP_X_NO_IND_PERMISS", params)));
                        return;
                    }
                }
                try {
                    if (!exists) ** GOTO lbl52
                    user = uniqueIDOfUser != null ? this.userFactory().getMutableUser(uniqueIDOfUser) : this.userFactory().getMutableUser(this.userFactory().getUserByUniqueName(dispName).getUniqueID());
                    if (this.overwrite) {
                        createdOrUpdated = " updated ";
                    } else {
                        hashUser.put("status", "EXISTS");
                        createdOrUpdated = " updated ";
                        return;
lbl52:
                        // 1 sources

                        user = this.userFactory().newUser(dispName);
                        fn = (String)hashUser.get("first_name");
                        ln = (String)hashUser.get("last_name");
                        if (!(fn != null && ln != null || exists)) {
                            if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                                hashUser.put("status", "UPDATE FAILED");
                            } else {
                                hashUser.put("status", "FAILED");
                            }
                            this.addWarning(hashUser, this.msgs.print(new Message("FIRSTNAME_ANDOR_LASTNAME_MISSING")));
                            return;
                        }
                        if (fn != null) {
                            user.setFirstName(fn);
                        }
                        if (ln != null) {
                            user.setLastName(ln);
                        }
                    }
                }
                catch (Exception e) {
                    user = this.userFactory().newUser(dispName);
                    fn = (String)hashUser.get("first_name");
                    ln = (String)hashUser.get("last_name");
                    if (!(fn != null && ln != null || exists)) {
                        if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                            hashUser.put("status", "UPDATE FAILED");
                        } else {
                            hashUser.put("status", "FAILED");
                        }
                        this.addWarning(hashUser, this.msgs.print(new Message("FIRSTNAME_ANDOR_LASTNAME_MISSING")));
                        return;
                    }
                    if (fn != null) {
                        user.setFirstName(fn);
                    }
                    if (ln == null) break block178;
                    user.setLastName(ln);
                }
            }
            if (!hashUser.containsKey("warnings")) {
                hashUser.put("warnings", "");
            }
            if ((cid = (String)hashUser.get("org_unique_id")) != null && !cid.trim().equals("")) {
                this.addWarning(hashUser, this.msgs.print(new Message("COMPANY_ID_X_SPECIFIED", cid)));
                try {
                    pi = PartnerID.instantiatePartnerID((String)cid);
                    company = this.tpd.getPartner(pi);
                    if (UserAdminHelper.hasAccess(this.performer, "MANAGE_ALL_COMPANIES")) {
                        this.addWarning(hashUser, this.msgs.print(new Message("USER_X_HAS_GLOBAL_PERM", this.performer.getDisplayName())));
                    } else {
                        if (this.performersCompanyId == null) {
                            hashUser.put("status", "NO PERMISSION");
                            this.addWarning(hashUser, this.msgs.print(new Message("INDUSER_X_NOT_BATCH_ADMIN", this.performer.getDisplayName())));
                            return;
                        }
                        if (this.performersCompanyId.equals(cid)) {
                            params = new Object[]{this.performer.getDisplayName(), company.getDisplayName()};
                            this.addWarning(hashUser, this.msgs.print(new Message("USER_X_MEMBER_OF_COMP_X", params)));
                        } else {
                            hashUser.put("status", "NO PERMISSION");
                            params = new Object[]{this.performer.getDisplayName(), company.getDisplayName()};
                            this.addWarning(hashUser, this.msgs.print(new Message("USER_X_NEITHER_CLOBAL_NOR_X", params)));
                            return;
                        }
                    }
                    if (company.getDisplayName() == null) {
                        company = null;
                        if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                            hashUser.put("status", "UPDATE FAILED");
                        } else {
                            hashUser.put("status", "FAILED");
                        }
                        this.addWarning(hashUser, this.msgs.print(new Message("COMPANY_ID_X_NOT_FOUND", cid)));
                        cid = null;
                        return;
                    }
                    compname = (String)hashUser.get("org_id");
                    if (compname != null && compname.trim().length() > 0 && !compname.equals(company.getDisplayName())) {
                        if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                            hashUser.put("status", "UPDATE FAILED");
                        } else {
                            hashUser.put("status", "FAILED");
                        }
                        args = new Object[]{company.getDisplayName(), compname};
                        this.addWarning(hashUser, this.msgs.print(new Message("COMPANY_ID_X_NAME_NOMATCH_X", args)));
                        return;
                    }
                    orgUnitNeeded = Batch.isOrgUnitRequired(company);
                    orgunit = (String)hashUser.get("org_unit");
                    if (orgunit != null && orgunit.length() == 0) {
                        orgunit = null;
                    }
                    if (orgUnitNeeded && orgunit == null) {
                        throw new BatchException(this.msgs.print(new Message("ORGUNIT_REQUIRED_FOR_X", company.getDisplayName())));
                    }
                    if (!orgUnitNeeded && orgunit != null) {
                        throw new BatchException(this.msgs.print(new Message("ORGUNIT_DISALLOWED_FOR_X", company.getDisplayName())));
                    }
                    user.setCompany(company.getPartnerID().toString());
                    rf = this.getRoleFactory(company);
                }
                catch (TpdException tpde) {
                    throw new BatchException("Problem with trading partner: " + tpde.getMessage());
                }
            } else {
                cid = null;
            }
            if ((cname = (String)hashUser.get("org_id")) != null && cname.length() > 0 && cid == null) {
                this.addWarning(hashUser, this.msgs.print(new Message("COMPANY_NAME_X_SPECIFIED", cname)));
                try {
                    partnersEnum = this.getPartners(cname);
                    company = null;
                    if (partnersEnum == null || !partnersEnum.hasMoreElements()) {
                        if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                            hashUser.put("status", "UPDATE FAILED");
                        } else {
                            hashUser.put("status", "FAILED");
                        }
                        this.addWarning(hashUser, this.msgs.print(new Message("COMPANY_X_NOT_FOUND", cname)));
                        return;
                    }
                    company = (TradingPartnerInterface)partnersEnum.nextElement();
                    user.setCompany(company.getPartnerID().toString());
                    rf = this.getRoleFactory(company);
                    if (partnersEnum.hasMoreElements()) {
                        if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                            hashUser.put("status", "UPDATE FAILED");
                        } else {
                            hashUser.put("status", "FAILED");
                        }
                        this.addWarning(hashUser, this.msgs.print(new Message("COMPANY_X_AMBIGUOUS", cname)));
                        return;
                    }
                    if (UserAdminHelper.hasAccess(this.performer, "MANAGE_ALL_COMPANIES")) {
                        this.addWarning(hashUser, this.msgs.print(new Message("USER_X_HAS_GLOBAL_PERM", this.performer.getDisplayName())));
                    } else {
                        if (this.performersCompanyId == null) {
                            hashUser.put("status", "NO PERMISSION");
                            this.addWarning(hashUser, this.msgs.print(new Message("INDUSER_X_NOT_BATCH_ADMIN", this.performer.getDisplayName())));
                            return;
                        }
                        if (this.performersCompanyId.equals(company.getPartnerID().toString())) {
                            params = new Object[]{this.performer.getDisplayName(), company.getDisplayName()};
                            this.addWarning(hashUser, this.msgs.print(new Message("USER_X_MEMBER_OF_COMP_X", params)));
                        } else {
                            hashUser.put("status", "NO PERMISSION");
                            params = new Object[]{this.performer.getDisplayName(), company.getDisplayName()};
                            this.addWarning(hashUser, this.msgs.print(new Message("USER_X_NEITHER_CLOBAL_NOR_X", params)));
                            return;
                        }
                    }
                    orgUnitNeeded = Batch.isOrgUnitRequired(company);
                    orgunit = (String)hashUser.get("org_unit");
                    if (orgunit != null && orgunit.length() == 0) {
                        orgunit = null;
                    }
                    if (orgUnitNeeded && orgunit == null) {
                        throw new BatchException(this.msgs.print(new Message("ORGUNIT_REQUIRED_FOR_X", company.getDisplayName())));
                    }
                    if (!orgUnitNeeded && orgunit != null) {
                        throw new BatchException(this.msgs.print(new Message("ORGUNIT_DISALLOWED_FOR_X", company.getDisplayName())));
                    }
                }
                catch (TpdException tpde) {
                    throw new BatchException("Problem with trading partner: " + tpde.getMessage());
                }
            }
            keys = hashUser.keySet().iterator();
            while (keys.hasNext()) {
                key = (String)keys.next();
                if (key.equalsIgnoreCase("org_unit")) {
                    ou = new String[]{(String)hashUser.get(key)};
                    user.setAttribute("UM", "ORGUNIT", ou);
                    continue;
                }
                if (key.equalsIgnoreCase("email_address")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 70) {
                        value = value.substring(0, 69);
                    }
                    user.setEmail(value);
                    continue;
                }
                if (key.equalsIgnoreCase("uid") || key.equalsIgnoreCase("org_id") || key.equalsIgnoreCase("org_unique_id") || key.equalsIgnoreCase("internaluid")) continue;
                if (key.equalsIgnoreCase("first_name")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 30) {
                        value = value.substring(0, 29);
                    }
                    user.setFirstName(value);
                    continue;
                }
                if (key.equalsIgnoreCase("last_name")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 30) {
                        value = value.substring(0, 29);
                    }
                    user.setLastName(value);
                    continue;
                }
                if (key.equalsIgnoreCase("job_title")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 20) {
                        value = value.substring(0, 19);
                    }
                    user.setJobTitle(value);
                    continue;
                }
                if (key.equalsIgnoreCase("country")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 30) {
                        value = value.substring(0, 29);
                    }
                    user.setCountry(value);
                    continue;
                }
                if (key.equalsIgnoreCase("language")) {
                    localeStr = (String)hashUser.get(key);
                    locale = null;
                    if (value != null) {
                        locales = Locale.getAvailableLocales();
                        i = 0;
                        while (i < locales.length) {
                            if (locales[i].toString().equalsIgnoreCase(localeStr)) {
                                locale = locales[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    user.setLocale(locale);
                    continue;
                }
                if (key.equalsIgnoreCase("time_zone")) {
                    value = (String)hashUser.get(key);
                    tz = null;
                    if (value != null) {
                        tz = java.util.TimeZone.getTimeZone(value);
                    }
                    user.setTimeZone(tz);
                    continue;
                }
                if (key.equalsIgnoreCase("currency")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 20) {
                        value = value.substring(0, 19);
                    }
                    user.setCurrency(value);
                    continue;
                }
                if (key.equalsIgnoreCase("street")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 60) {
                        value = value.substring(0, 59);
                    }
                    user.setStreet(value);
                    continue;
                }
                if (key.equalsIgnoreCase("city")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 30) {
                        value = value.substring(0, 29);
                    }
                    user.setCity(value);
                    continue;
                }
                if (key.equalsIgnoreCase("state")) {
                    state = (String)hashUser.get(key);
                    if (value != null && state.length() > 20) {
                        state = state.substring(0, 19);
                    }
                    user.setState(state);
                    continue;
                }
                if (key.equalsIgnoreCase("province")) continue;
                if (key.equalsIgnoreCase("zip")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 15) {
                        value = value.substring(0, 14);
                    }
                    user.setZip(value);
                    continue;
                }
                if (key.equalsIgnoreCase("telephone")) {
                    phone = (String)hashUser.get(key);
                    if (phone != null && phone.length() > 40) {
                        phone = phone.substring(0, 39);
                    }
                    user.setTelephone(phone);
                    continue;
                }
                if (key.equalsIgnoreCase("fax")) {
                    fax = (String)hashUser.get(key);
                    if (fax != null && fax.length() > 40) {
                        fax = fax.substring(0, 39);
                    }
                    user.setFax(fax);
                    continue;
                }
                if (key.equalsIgnoreCase("mobile")) {
                    user.setCellPhone((String)hashUser.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("department")) {
                    user.setDepartment((String)hashUser.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("name")) continue;
                if (key.equalsIgnoreCase("title")) {
                    user.setTitle((String)hashUser.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("warnings")) continue;
                if (key.indexOf(":") != -1) {
                    binaryFound = false;
                    delim = key.indexOf(":");
                    namespace = key.substring(0, delim);
                    attname = key.substring(delim + 1, key.length());
                    addattVector = (Vector)hashUser.get(key);
                    if (addattVector == null || addattVector.size() == 0) {
                        this.addWarning(hashUser, this.msgs.print(new Message("WARN_ADDATT_X_EMPTY", namespace + ":" + attname)));
                        continue;
                    }
                    if (namespace.equals("$inverse_usermapping$")) {
                        throw new BatchException("Inverse user mapping not supported yet");
                    }
                    if (namespace.equals("$usermapping$")) {
                        delim = attname.indexOf(":");
                        sysid = attname.substring(0, delim);
                        umap_attname = attname.substring(delim + 1, attname.length());
                        if (addattVector.size() > 1) {
                            throw new BatchException("Multiple mappings for one system can't work!");
                        }
                        umap_attvalue = (String)addattVector.get(0);
                        sysmap = (HashMap<String, String>)umaps.get(sysid);
                        if (sysmap == null) {
                            sysmap = new HashMap<String, String>();
                        }
                        sysmap.put(umap_attname, umap_attvalue);
                        umaps.put(sysid, sysmap);
                        continue;
                    }
                    addattStrings = new String[addattVector.size()];
                    i = 0;
                    while (i < addattVector.size()) {
                        addattStrings[i] = (String)addattVector.elementAt(i);
                        if (addattStrings[i].startsWith("{BINARY}")) {
                            if (i > 0) {
                                throw new BatchException("Cannot store multiple additional attributes using one namespace-name pair if one of the attributes is of type BINARY");
                            }
                            binaryFound = true;
                        }
                        ++i;
                    }
                    if (binaryFound) {
                        user.setBinaryAttribute(namespace, attname, Base64.decode(addattStrings[0].substring("{BINARY}".length())));
                        continue;
                    }
                    user.setAttribute(namespace, attname, addattStrings);
                    continue;
                }
                if (key.equalsIgnoreCase("role")) {
                    if (!UserAdminHelper.hasAccess(this.performer, "ROLES_ASSIGN")) {
                        hashUser.put("status", "NO PERMISSION");
                        this.addWarning(hashUser, this.msgs.print(new Message("USER_X_NO_ROLES_PERM", this.performer.getDisplayName())));
                        return;
                    }
                    roleVector = (Vector)hashUser.get(key);
                    if (roleVector == null || roleVector.size() == 0) continue;
                    i = 0;
                    while (i < roleVector.size()) {
                        role = null;
                        try {
                            role = rf.getRoleByUniqueName((String)roleVector.elementAt(i));
                        }
                        catch (UMException ume) {
                            Batch.trace.debugT("createBatchUser", ume);
                        }
                        if (role == null) {
                            this.addWarning(hashUser, this.msgs.print(new Message("WARN_ROLE_X_NOTDEF_FOR_IND", (String)roleVector.elementAt(i))));
                            if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                                hashUser.put("status", "UPDATE FAILED");
                            } else {
                                hashUser.put("status", "FAILED");
                            }
                            return;
                        }
                        roleSet.add(roleVector.elementAt(i));
                        ++i;
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("group")) {
                    if (!UserAdminHelper.hasAccess(this.performer, "GROUPS_ASSIGN")) {
                        hashUser.put("status", "NO PERMISSION");
                        this.addWarning(hashUser, this.msgs.print(new Message("USER_X_NO_GROUPASSIGN_PERM", this.performer.getDisplayName())));
                        return;
                    }
                    groupVector = (Vector)hashUser.get(key);
                    if (groupVector == null || groupVector.size() == 0) continue;
                    i = 0;
                    while (i < groupVector.size()) {
                        group = null;
                        try {
                            group = gf.getGroupByUniqueName((String)groupVector.elementAt(i));
                        }
                        catch (UMException ume) {
                            Batch.trace.debugT("createBatchUser", ume);
                        }
                        if (group == null) {
                            this.addWarning(hashUser, this.msgs.print(new Message("ERROR_GROUP_X_NOTDEF", (String)groupVector.elementAt(i))));
                            if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                                hashUser.put("status", "UPDATE FAILED");
                            } else {
                                hashUser.put("status", "FAILED");
                            }
                            return;
                        }
                        groupSet.add(groupVector.elementAt(i));
                        ++i;
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("telephone_ext") || key.equalsIgnoreCase("fax_ext")) continue;
                if (key.equalsIgnoreCase("building")) {
                    b = new String[]{(String)hashUser.get(key)};
                    user.setAttribute("UM", "building", b);
                    continue;
                }
                if (key.equalsIgnoreCase("room")) {
                    r = new String[]{(String)hashUser.get(key)};
                    user.setAttribute("UM", "room", r);
                    continue;
                }
                if (key.equalsIgnoreCase("inHouseMail")) {
                    ip = new String[]{(String)hashUser.get(key)};
                    user.setAttribute("UM", "inHouseMail", ip);
                    continue;
                }
                if (key.equalsIgnoreCase("academicTitle")) {
                    ag = new String[]{(String)hashUser.get(key)};
                    user.setAttribute("UM", "academicTitle", ag);
                    continue;
                }
                if (key.equalsIgnoreCase("floor")) {
                    f = new String[]{(String)hashUser.get(key)};
                    user.setAttribute("UM", "floor", f);
                    continue;
                }
                if (key.equalsIgnoreCase("salutation")) {
                    value = (String)hashUser.get(key);
                    if (value != null && value.length() > 10) {
                        value = value.substring(0, 9);
                    }
                    user.setSalutation((String)hashUser.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("password") || key.equalsIgnoreCase("cert")) continue;
                this.addWarning(hashUser, this.msgs.print(new Message("WARN_IGNORED_UNKNOWN_ATT_X", key)));
            }
            try {
                user.save();
                user.commit();
                hashUser.put("UniqueUserID", user.getUniqueID());
            }
            catch (Exception e) {
                Batch.trace.infoT("createBatchUser", e);
                user.rollback();
                if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                    hashUser.put("status", "UPDATE FAILED");
                } else {
                    hashUser.put("status", "FAILED");
                }
                this.addWarning(hashUser, this.msgs.print(new Message("FAILED_COMMITING_X", e.getMessage())));
                return;
            }
            if (umaps.keySet().size() > 0) {
                wrapper = null;
                wrappers = UMFactory.getSystemLandscapeWrappers();
                if (wrappers.size() <= 0) {
                    throw new BatchException("No system landscapes found, can't process user mappings");
                }
                wrapper = (ISystemLandscapeWrapper)wrappers.get(0);
                if (wrapper == null) {
                    throw new BatchException("system landscape found is null, can't process user mappings");
                }
                umap_keys = umaps.keySet().iterator();
                while (umap_keys.hasNext()) {
                    sysid = (String)umap_keys.next();
                    mapping_data = (HashMap)umaps.get(sysid);
                    try {
                        system = wrapper.getSystemByAlias(sysid);
                        mapping = UMFactory.getUserMapping().getUserMappingData(system, (IPrincipal)user);
                        mapping.storeLogonData((Map)mapping_data);
                    }
                    catch (Exception e) {
                        throw new BatchException(e.getMessage());
                    }
                }
            }
            if (hashUser.get("cert") != null) {
                block179: {
                    bais = null;
                    certVector = (Vector)hashUser.get("cert");
                    if (certVector == null || certVector.size() <= 0) break block179;
                    certs = new X509Certificate[certVector.size()];
                    i = 0;
                    while (i < certVector.size()) {
                        cert = (String)certVector.get(i);
                        if (!cert.startsWith("{X.509}")) {
                            throw new BatchException("Only X509 certificates are supported at the moment");
                        }
                        certbuffer = new StringBuffer("-----BEGIN CERTIFICATE-----\r\n");
                        certbuffer.append(cert.substring("{X.509}".length()) + "\r\n");
                        certbuffer.append("-----END CERTIFICATE-----\r\n");
                        bais = new ByteArrayInputStream(certbuffer.toString().getBytes());
                        cf = CertificateFactory.getInstance("X.509");
                        certs[i] = (X509Certificate)cf.generateCertificate(bais);
                        ++i;
                    }
                    if (ua == null) {
                        ua = this.getUserAccount(dispName, user, createdOrUpdated);
                    }
                    ua.setCertificates(certs);
                }
                var30_84 = null;
                try {
                    bais.close();
                }
                catch (IOException ioe) {
                    Batch.trace.infoT("createBatchUser", ioe);
                }
                break block181;
                {
                    catch (CertificateException cex) {
                        throw new BatchException(cex.getMessage());
                    }
                    catch (Exception e) {
                        throw new BatchException(e.getMessage());
                    }
                }
                catch (Throwable var29_88) {
                    var30_85 = null;
                    try {
                        bais.close();
                    }
                    catch (IOException ioe) {
                        Batch.trace.infoT("createBatchUser", ioe);
                    }
                    throw var29_88;
                }
            }
        }
        if (createdOrUpdated.trim().equals("created") || hashUser.get("password") != null) {
            key = "password";
            try {
                if (ua == null) {
                    ua = this.getUserAccount(dispName, user, createdOrUpdated);
                }
                if ((password = (String)hashUser.get(key)) == null || password.trim().length() == 0) {
                    password = UMFactory.getSecurityPolicy().generatePassword();
                }
                try {
                    if (Batch.mySAPProperties.getBoolean("ume.admin.password.migration", false)) {
                        p = new String[]{password};
                        ua.setAttribute("com.sap.security.core.usermanagement", "j_password", p);
                    } else {
                        ua.setPassword(password);
                    }
                }
                catch (InvalidPasswordException ipe) {
                    if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                        hashUser.put("status", "UPDATE FAILED");
                    } else {
                        hashUser.put("status", "FAILED");
                        this.userFactory().deleteUser(user.getUniqueID());
                    }
                    this.addWarning(hashUser, this.msgs.print(new Message("INVALID_PWD_TECHNICAL_REASON_X", ipe.getMessage())));
                    return;
                }
            }
            catch (Exception ex) {
                if (createdOrUpdated.trim().equalsIgnoreCase("created")) {
                    this.userFactory().deleteUser(user.getUniqueID());
                }
                throw new BatchException("Problem with user account creation: " + ex.getMessage());
            }
        }
        if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
            password = hashUser.get("password") != null ? this.msgs.print(new Message("RESETTO", password)) : this.msgs.print(new Message("PWD_NOT_CHANGED"));
        }
        try {
            if (ua != null) {
                ua.save();
                ua.commit();
            }
        }
        catch (Exception e) {
            Batch.trace.infoT("createBatchUser", e);
            if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                hashUser.put("status", "UPDATE FAILED");
            } else {
                hashUser.put("status", "FAILED");
                this.userFactory().deleteUser(user.getUniqueID());
            }
            this.addWarning(hashUser, this.msgs.print(new Message("FAILED_COMMITING_X", e.getMessage())));
            return;
        }
        try {
            if (createdOrUpdated.trim().equalsIgnoreCase("created")) {
                SendMailAsynch.generateEmailOnUMEvent(this.performer, (IUser)user, "create_by_batch_performed", null, password);
            } else {
                SendMailAsynch.generateEmailOnUMEvent(this.performer, (IUser)user, "update_by_batch_performed", null, password);
            }
        }
        catch (UMException ume) {
            Batch.trace.warningT("createBatchUser", "Problem while sending email: " + ume.getMessage());
            this.addWarning(hashUser, this.msgs.print(new Message("PROBLEM_WITH_EMAIL_X", ume.getMessage())));
        }
        if (hashUser.get("role") != null) {
            assignedRoles = null;
            assignedRoles = createdOrUpdated.trim().equalsIgnoreCase("updated") != false ? rf.getRolesOfUser(user.getUniqueID(), false) : new String[]{};
            assignedRolesVector = new Vector<String>();
            i = 0;
            while (i < assignedRoles.length) {
                assignedRolesVector.add(assignedRoles[i]);
                ++i;
            }
            iterators = this.principalsToBeCreatedDeleted(roleSet, assignedRolesVector.iterator(), "role");
            creator = iterators[0];
            remover = iterators[1];
            while (creator.hasNext()) {
                this.addMemberToPrincipalSetMap(user.getUniqueID(), (String)creator.next());
            }
            while (remover.hasNext()) {
                this.removeMemberFromPrincipalSetMap(user.getUniqueID(), (String)remover.next());
            }
        }
        if (hashUser.get("group") != null) {
            iterators = this.principalsToBeCreatedDeleted(groupSet, user.getParentGroups(false), "group");
            creator = iterators[0];
            remover = iterators[1];
            while (creator.hasNext()) {
                this.addMemberToPrincipalSetMap(user.getUniqueID(), (String)creator.next());
            }
            while (remover.hasNext()) {
                gid = (String)remover.next();
                if (gid.equals("GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE") || gid.equals("GRUP.SUPER_GROUPS_DATASOURCE.AUTHENTICATED_USERS")) continue;
                this.removeMemberFromPrincipalSetMap(user.getUniqueID(), gid);
            }
        }
        hashUser.put("password", password);
        hashUser.put("status", createdOrUpdated.trim().toUpperCase());
    }

    private IUserAccount getUserAccount(String dispName, IUserMaint user, String createdOrUpdated) throws UMException, BatchException {
        IUserAccount ua;
        if (createdOrUpdated.trim().equals("created")) {
            ua = this.userAccountFactory().newUserAccount(dispName, user.getUniqueID());
        } else {
            IUserAccount[] accounts = user.getUserAccounts();
            if (accounts.length > 1) {
                throw new BatchException("multiple user accounts not supported in batch yet");
            }
            ua = this.userAccountFactory().getMutableUserAccount(accounts[0].getUniqueID());
        }
        return ua;
    }

    public void downloadAllUsers(boolean inPortal) throws BatchException, IOException, UMException {
        IRoleFactory companyRoleFactory = UMFactory.getRoleFactory();
        IUserSearchFilter filter = this.userFactory().getUserSearchFilter();
        ISearchResult users = this.userFactory().searchUsers(filter);
        TradingPartnerDirectoryInterface tpd = TradingPartnerDirectoryCommon.getTPD();
        if (users == null) {
            return;
        }
        try {
            while (users.hasNext()) {
                IUser u = this.userFactory().getUser((String)users.next());
                try {
                    this.downloadUser(u, tpd.getPartner(u.getCompany()), companyRoleFactory, inPortal);
                }
                catch (TpdException tpde) {
                    throw new BatchException(tpde.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            throw new BatchException(ioe.getMessage());
        }
    }

    private void downloadUser(IUser user, TradingPartnerInterface tp, IRoleFactory companyRoleFactory, boolean inPortal) throws BatchException, IOException, UMException {
        String[] namespaces;
        int i;
        Locale lcl;
        IUserAccount[] accounts;
        this.writeEncoded("[User]");
        if (inPortal) {
            this.writer.write("<br>");
        }
        this.writer.newLine();
        String value = null;
        if (tp != null) {
            this.writeEncoded("org_id=" + tp.getDisplayName());
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((accounts = user.getUserAccounts()).length > 0) {
            int k = 0;
            while (k < 1) {
                this.writeEncoded("uid=" + accounts[k].getDisplayName());
                if (inPortal) {
                    this.writer.write("<br>");
                }
                this.writer.newLine();
                ++k;
            }
        } else {
            this.writeEncoded("uid= __NO_ACCOUNT_ERROR__");
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        String[] rolesIt = companyRoleFactory.getRolesOfUser(user.getUniqueID(), false);
        String rolestring = "role=";
        if (rolesIt != null) {
            int i2 = 0;
            while (i2 < rolesIt.length) {
                rolestring = rolestring + companyRoleFactory.getRole(rolesIt[i2]).getUniqueName() + ";";
                ++i2;
            }
            this.writeEncoded(rolestring);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        Iterator groupsIt = user.getParentGroups(false);
        groupsIt = new PrincipalIterator(groupsIt, PrincipalIterator.ITERATOR_TYPE_UNIQUEIDS_NOT_CHECKED);
        String groupstring = "group=";
        IGroupFactory gf = UMFactory.getGroupFactory();
        if (groupsIt != null) {
            while (groupsIt.hasNext()) {
                try {
                    groupstring = groupstring + gf.getGroup((String)groupsIt.next()).getUniqueName() + ";";
                }
                catch (NoSuchGroupException nsge) {
                    if (!trace.beDebug()) continue;
                    trace.debugT("downloadUser", nsge);
                }
            }
            this.writeEncoded(groupstring);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getEmail()) != null && value.length() > 0) {
            this.writeEncoded("email_address=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getFirstName()) != null && value.length() > 0) {
            this.writeEncoded("first_name=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getLastName()) != null && value.length() > 0) {
            this.writeEncoded("last_name=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getJobTitle()) != null && value.length() > 0) {
            this.writeEncoded("job_title=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getTitle()) != null && value.length() > 0) {
            this.writeEncoded("title=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getCountry()) != null && value.length() > 0) {
            this.writeEncoded("country=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((lcl = user.getLocale()) != null && (value = lcl.getLanguage()) != null) {
            this.writeEncoded("language=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if (user.getTimeZone() != null && (value = user.getTimeZone().getID()) != null) {
            this.writeEncoded("time_zone=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getCurrency()) != null && value.length() > 0) {
            this.writeEncoded("currency=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getStreet()) != null && value.length() > 0) {
            this.writeEncoded("street=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getCity()) != null && value.length() > 0) {
            this.writeEncoded("city=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getState()) != null && value.length() > 0) {
            this.writeEncoded("state=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getZip()) != null && value.length() > 0) {
            this.writeEncoded("zip=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getTelephone()) != null && value.length() > 0) {
            this.writeEncoded("telephone=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getFax()) != null && value.length() > 0) {
            this.writeEncoded("fax=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getCellPhone()) != null && value.length() > 0) {
            this.writeEncoded("mobile=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if ((value = user.getDepartment()) != null && value.length() > 0) {
            this.writeEncoded("department=" + value);
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
        if (accounts != null && accounts.length > 0) {
            try {
                X509Certificate[] certs = accounts[0].getCertificates();
                if (certs != null) {
                    i = 0;
                    while (i < certs.length) {
                        this.writeEncoded("cert={X.509}" + Base64.encode(certs[i].getEncoded()));
                        if (inPortal) {
                            this.writer.write("<br>");
                        }
                        this.writer.newLine();
                        ++i;
                    }
                }
            }
            catch (CertificateException cex) {
                throw new BatchException(cex.getMessage());
            }
        }
        if ((namespaces = user.getAttributeNamespaces()) != null) {
            i = 0;
            while (i < namespaces.length) {
                String namespace = namespaces[i];
                if (namespace.indexOf("com.sap.security.core.usermanagement") == -1 && namespace.indexOf("com.sap.security.core.usermanagement.relation") == -1 && namespace.indexOf("$usermapping$") == -1 && namespace.indexOf("$inverse_usermapping$") == -1) {
                    String[] names = user.getAttributeNames(namespace);
                    int j = 0;
                    while (j < names.length) {
                        boolean isBinary;
                        ArrayList<String> atts = new ArrayList<String>();
                        boolean bl = isBinary = user.getAttributeType(namespace, names[j]).equals("Byte");
                        if (isBinary) {
                            atts.add(BINARY + Base64.encode(user.getBinaryAttribute(namespace, names[j])));
                        } else {
                            String[] attsArray = user.getAttribute(namespace, names[j]);
                            int z = 0;
                            while (z < attsArray.length) {
                                atts.add(attsArray[z]);
                                ++z;
                            }
                        }
                        if (atts != null && atts.size() > 0) {
                            int k = 0;
                            while (k < atts.size()) {
                                if (namespaces[i].equals(UM_NAMESPACE) && names[j].equals("ORGUNIT")) {
                                    this.writeEncoded("org_unit=" + (String)atts.get(k));
                                } else {
                                    this.writeEncoded(namespace + ":" + names[j] + "=" + (String)atts.get(k));
                                }
                                if (inPortal) {
                                    this.writer.write("<br>");
                                }
                                this.writer.newLine();
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (mySAPProperties.getBoolean("ume.admin.password.migration", false)) {
            try {
                this.writeEncoded("password=" + user.getUserAccounts()[0].getHashedPassword());
            }
            catch (Exception e) {
                trace.errorT("downloadUser", e);
            }
            if (inPortal) {
                this.writer.write("<br>");
            }
            this.writer.newLine();
        }
    }

    public boolean downloadUsersOfCompany(IUser actor, TradingPartnerInterface tp, boolean inPortal) throws UMException {
        if (this.writer == null) {
            throw new BatchException("no write destination defined");
        }
        boolean usersFound = false;
        IRoleFactory companyRoleFactory = UMFactory.getRoleFactory();
        if (tp != null) {
            IUserSearchFilter filter = this.userFactory().getUserSearchFilter();
            filter.setCompany(tp.getPartnerID().toString(), 0, true);
            ISearchResult users = this.userFactory().searchUsers(filter);
            if (users == null) {
                return false;
            }
            try {
                usersFound = users.size() > 0;
                while (users.hasNext()) {
                    this.downloadUser(this.userFactory().getUser((String)users.next()), tp, companyRoleFactory, inPortal);
                }
            }
            catch (IOException ioe) {
                throw new BatchException(ioe.getMessage());
            }
        }
        UserSearchFilter su = new UserSearchFilter();
        su.setCompany("", 0, true);
        ISearchResult result = UMFactory.getUserFactory().searchUsers((IUserSearchFilter)su);
        if (result == null) {
            return false;
        }
        try {
            usersFound = result.hasNext();
            while (result.hasNext()) {
                this.downloadUser(this.userFactory().getUser((String)result.next()), tp, companyRoleFactory, inPortal);
            }
        }
        catch (IOException ioe) {
            throw new BatchException(ioe.getMessage());
        }
        return usersFound;
    }

    private void addWarning(HashMap map, String warning) {
        String oldWarnings = (String)map.get(Warnings);
        if (oldWarnings == null) {
            oldWarnings = "";
        }
        if (oldWarnings.length() == 0) {
            map.put(Warnings, warning);
        } else {
            map.put(Warnings, oldWarnings + "&" + warning);
        }
    }

    private Enumeration getPartners(String cname) throws TpdException {
        if (this.cachedTPs.containsKey(cname)) {
            return ((Vector)this.cachedTPs.get(cname)).elements();
        }
        int MAX_HITS = 999;
        PartnerResultSet result = this.tpd.getPartners(cname, MAX_HITS);
        Vector<TradingPartnerInterface> v = new Vector<TradingPartnerInterface>();
        if (result.getSize() >= 1) {
            Iterator iterator = result.partnerIterator();
            while (iterator.hasNext()) {
                TradingPartnerInterface tp = (TradingPartnerInterface)iterator.next();
                if (cname.equalsIgnoreCase(tp.getDisplayName())) {
                    v.clear();
                    v.add(tp);
                    break;
                }
                v.add(tp);
            }
        }
        this.cachedTPs.put(cname, v);
        return v.elements();
    }

    public static boolean isOrgUnitRequired(TradingPartnerInterface tp) throws UMException {
        String orgUnitScopeValue = mySAPProperties.get(orgUnitScopeKey);
        if (null == mySAPProperties.get(orgUnitAdapterKey, mySAPProperties.get(orgUnitSysIdKey))) {
            return false;
        }
        IServiceRepository _sp = InternalUMFactory.getServiceRepository();
        IScopeDefinition _isd = _sp.getScopeDefinitionByName(orgUnitScopeValue);
        if (null == _isd) {
            trace.warningT("initBeans", "Unknown scope", new String[]{orgUnitScopeValue});
            throw new UMException("Unknown scope " + orgUnitScopeValue);
        }
        return _sp.belongsToScope(tp, _isd);
    }

    private void createBatchGroup(HashMap hashGroup) throws BatchException, UMException, TpdException {
        Iterator[] iterators;
        String createdOrUpdated = " created ";
        IGroupFactory gf = UMFactory.getGroupFactory();
        String name = (String)hashGroup.get(GROUPNAME);
        String desc = (String)hashGroup.get(GROUPDESC);
        IGroup group = null;
        if (name == null || name.length() == 0) {
            throw new BatchException(this.msgs.print(new Message("GROUPNAME_MISSING")));
        }
        try {
            if (!this.overwrite) {
                group = gf.getGroupByUniqueName(name);
                hashGroup.put(Status, EXISTS);
                createdOrUpdated = " updated ";
                return;
            }
            group = gf.getMutableGroup(gf.getGroupByUniqueName(name).getUniqueID());
            createdOrUpdated = " updated ";
            if (!UserAdminHelper.hasAccess(this.performer, "GROUPS_MODIFY")) {
                hashGroup.put(Status, NO_PERMISSION);
                this.addWarning(hashGroup, this.msgs.print(new Message("USER_X_NO_GROUPMODIFY_PERM", this.performer.getDisplayName())));
                return;
            }
            if (!group.isMutable()) {
                throw new BatchException(this.msgs.print(new Message("CANT_MIDIFY_GROUP_X", group.getDisplayName())));
            }
        }
        catch (NoSuchGroupException nsge) {
            if (!UserAdminHelper.hasAccess(this.performer, "GROUPS_ADD")) {
                hashGroup.put(Status, NO_PERMISSION);
                this.addWarning(hashGroup, this.msgs.print(new Message("USER_X_NO_GROUPADD_PERM", this.performer.getDisplayName())));
                return;
            }
            group = gf.newGroup(name);
        }
        if (desc != null && desc.length() > 0) {
            group.setDescription(desc);
        }
        HashSet userHashSet = (HashSet)hashGroup.get(USER);
        Vector groupVector = (Vector)hashGroup.get(GROUP);
        if (groupVector != null && groupVector.size() > 0) {
            if (!UserAdminHelper.hasAccess(this.performer, "GROUPS_ASSIGN")) {
                hashGroup.put(Status, NO_PERMISSION);
                this.addWarning(hashGroup, this.msgs.print(new Message("USER_X_NO_GROUPASSIGN_PERM", this.performer.getDisplayName())));
                return;
            }
            try {
                iterators = this.principalsToBeCreatedDeleted(groupVector, group.getGroupMembers(false), GROUP);
                while (iterators[0].hasNext()) {
                    group.addGroupMember((String)iterators[0].next());
                }
                while (iterators[1].hasNext()) {
                    group.removeGroupMember((String)iterators[1].next());
                }
            }
            catch (UMException ume) {
                this.addWarning(hashGroup, this.msgs.print(new Message("WARN_CANT_ASSIGN_GROUPTOGROUP", ume.getMessage())));
                if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                    hashGroup.put(Status, UPDATE_FAILED);
                } else {
                    hashGroup.put(Status, FAILED);
                }
                return;
            }
        }
        if (userHashSet != null && userHashSet.size() > 0) {
            if (!UserAdminHelper.hasAccess(this.performer, "GROUPS_ASSIGN")) {
                hashGroup.put(Status, NO_PERMISSION);
                this.addWarning(hashGroup, this.msgs.print(new Message("USER_X_NO_GROUPASSIGN_PERM", this.performer.getDisplayName())));
                return;
            }
            try {
                iterators = this.usersToBeCreatedDeleted(userHashSet, group.getUserMembers(false));
                while (iterators[0].hasNext()) {
                    group.addUserMember((String)iterators[0].next());
                }
                while (iterators[1].hasNext()) {
                    group.removeUserMember((String)iterators[1].next());
                }
            }
            catch (UMException ume) {
                this.addWarning(hashGroup, this.msgs.print(new Message("WARN_CANT_ASSIGN_USERTOGROUP", ume.getMessage())));
                if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                    hashGroup.put(Status, UPDATE_FAILED);
                } else {
                    hashGroup.put(Status, FAILED);
                }
                return;
            }
        }
        group.save();
        group.commit();
        hashGroup.put(Status, createdOrUpdated.trim().toUpperCase());
    }

    private void createBatchRole(HashMap hashRole) throws BatchException, UMException, TpdException {
        Iterator[] iterators;
        String createdOrUpdated = " created ";
        IRoleFactory rf = UMFactory.getRoleFactory();
        String name = (String)hashRole.get(ROLENAME);
        String desc = (String)hashRole.get(ROLEDESC);
        IRole role = null;
        if (name == null || name.length() == 0) {
            throw new BatchException(this.msgs.print(new Message("GROUPNAME_MISSING")));
        }
        try {
            if (!this.overwrite) {
                role = rf.getRoleByUniqueName(name);
                hashRole.put(Status, EXISTS);
                createdOrUpdated = " updated ";
                return;
            }
            role = rf.getMutableRole(rf.getRoleByUniqueName(name).getUniqueID());
            createdOrUpdated = " updated ";
            if (!UserAdminHelper.hasAccess(this.performer, "ROLES_MODIFY")) {
                hashRole.put(Status, NO_PERMISSION);
                this.addWarning(hashRole, this.msgs.print(new Message("USER_X_NO_GROUPMODIFY_PERM", this.performer.getDisplayName())));
                return;
            }
            if (!role.isMutable()) {
                throw new BatchException(this.msgs.print(new Message("CANT_MIDIFY_GROUP_X", role.getDisplayName())));
            }
        }
        catch (NoSuchRoleException nsge) {
            if (!UserAdminHelper.hasAccess(this.performer, "ROLES_ADD")) {
                hashRole.put(Status, NO_PERMISSION);
                this.addWarning(hashRole, this.msgs.print(new Message("USER_X_NO_GROUPADD_PERM", this.performer.getDisplayName())));
                return;
            }
            role = rf.newRole(name);
        }
        if (desc != null && desc.length() > 0) {
            role.setDescription(desc);
        }
        HashSet userHashSet = (HashSet)hashRole.get(USER);
        Vector groupVector = (Vector)hashRole.get(GROUP);
        Vector actionVector = (Vector)hashRole.get(ACTION);
        if (groupVector != null && groupVector.size() > 0) {
            if (!UserAdminHelper.hasAccess(this.performer, "ROLES_ASSIGN")) {
                hashRole.put(Status, NO_PERMISSION);
                this.addWarning(hashRole, this.msgs.print(new Message("USER_X_NO_GROUPASSIGN_PERM", this.performer.getDisplayName())));
                return;
            }
            try {
                iterators = this.principalsToBeCreatedDeleted(groupVector, role.getGroupMembers(false), GROUP);
                while (iterators[0].hasNext()) {
                    role.addGroupMember((String)iterators[0].next());
                }
                while (iterators[1].hasNext()) {
                    role.removeGroupMember((String)iterators[1].next());
                }
            }
            catch (UMException ume) {
                this.addWarning(hashRole, this.msgs.print(new Message("WARN_CANT_ASSIGN_GROUPTOGROUP", ume.getMessage())));
                if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                    hashRole.put(Status, UPDATE_FAILED);
                } else {
                    hashRole.put(Status, FAILED);
                }
                return;
            }
        }
        if (userHashSet != null && userHashSet.size() > 0) {
            if (!UserAdminHelper.hasAccess(this.performer, "ROLES_ASSIGN")) {
                hashRole.put(Status, NO_PERMISSION);
                this.addWarning(hashRole, this.msgs.print(new Message("USER_X_NO_GROUPASSIGN_PERM", this.performer.getDisplayName())));
                return;
            }
            try {
                iterators = this.usersToBeCreatedDeleted(userHashSet, role.getUserMembers(false));
                while (iterators[0].hasNext()) {
                    role.addUserMember((String)iterators[0].next());
                }
                while (iterators[1].hasNext()) {
                    role.removeUserMember((String)iterators[1].next());
                }
            }
            catch (UMException ume) {
                this.addWarning(hashRole, this.msgs.print(new Message("WARN_CANT_ASSIGN_USERTOGROUP", ume.getMessage())));
                if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                    hashRole.put(Status, UPDATE_FAILED);
                } else {
                    hashRole.put(Status, FAILED);
                }
                return;
            }
        }
        if (actionVector != null && actionVector.size() > 0) {
            if (!UserAdminHelper.hasAccess(this.performer, "ROLES_MODIFY")) {
                hashRole.put(Status, NO_PERMISSION);
                this.addWarning(hashRole, this.msgs.print(new Message("USER_X_NO_ROLEMODIFY_PERM", this.performer.getDisplayName())));
                return;
            }
            PermissionRoles.removeActions(role);
            IServiceRepository srepository = InternalUMFactory.getServiceRepository();
            String a = null;
            HashSet<IServiceAction> actionSet = new HashSet<IServiceAction>();
            int i = 0;
            while (i < actionVector.size()) {
                try {
                    a = (String)actionVector.get(i);
                    actionSet.add(srepository.getServiceActionById(a));
                }
                catch (NoSuchActionException nsae) {
                    this.addWarning(hashRole, this.msgs.print(new Message("ACTION_X_NOT_EXIST", a)));
                    if (createdOrUpdated.trim().equalsIgnoreCase("updated")) {
                        hashRole.put(Status, UPDATE_FAILED);
                    } else {
                        hashRole.put(Status, FAILED);
                    }
                    return;
                }
                ++i;
            }
            PermissionRoles.setActions(role, actionSet);
        }
        role.save();
        role.commit();
        hashRole.put(Status, createdOrUpdated.trim().toUpperCase());
    }

    private Iterator[] usersToBeCreatedDeleted(HashSet newLogonIDs, Iterator oldUniqueIDsIt) throws UMException {
        Iterator[] result = new Iterator[2];
        HashSet<String> newUniqueIDs = new HashSet<String>();
        HashSet oldUniqueIDs = new HashSet();
        while (oldUniqueIDsIt.hasNext()) {
            oldUniqueIDs.add(oldUniqueIDsIt.next());
        }
        Iterator it = newLogonIDs.iterator();
        while (it.hasNext()) {
            String uid = this.userFactory().getUserByLogonID((String)it.next()).getUniqueID();
            if (!oldUniqueIDs.contains(uid)) {
                newUniqueIDs.add(uid);
                continue;
            }
            oldUniqueIDs.remove(uid);
        }
        result[0] = newUniqueIDs.iterator();
        result[1] = oldUniqueIDs.iterator();
        return result;
    }

    private Iterator[] principalsToBeCreatedDeleted(Vector newPrincipalIDs, Iterator oldUniqueIDsIt, String type) throws UMException {
        Iterator[] result = new Iterator[2];
        Vector<String> newUniqueIDs = new Vector<String>();
        HashMap oldUniqueIDs = new HashMap();
        boolean isRole = type.toLowerCase().indexOf(Role) != -1;
        IRoleFactory rf = UMFactory.getRoleFactory();
        IGroupFactory gf = UMFactory.getGroupFactory();
        while (oldUniqueIDsIt.hasNext()) {
            oldUniqueIDs.put(oldUniqueIDsIt.next(), "");
        }
        int i = 0;
        while (i < newPrincipalIDs.size()) {
            String uid = null;
            uid = isRole ? rf.getRoleByUniqueName((String)newPrincipalIDs.get(i)).getUniqueID() : gf.getGroupByUniqueName((String)newPrincipalIDs.get(i)).getUniqueID();
            if (!oldUniqueIDs.containsKey(uid)) {
                newUniqueIDs.add(uid);
            } else {
                oldUniqueIDs.remove(uid);
            }
            ++i;
        }
        result[0] = ((AbstractList)newUniqueIDs).iterator();
        result[1] = oldUniqueIDs.keySet().iterator();
        return result;
    }

    public void downloadGroups(String[] uids, boolean inPortal) throws BatchException {
        try {
            IGroup[] groups = UMFactory.getGroupFactory().getGroups(uids);
            int i = 0;
            while (i < groups.length) {
                this.writeEncoded("[group]");
                this.writer.write("<br>");
                this.writer.newLine();
                this.writeEncoded("gid=" + EncodeHtmlTag.encode(groups[i].getUniqueName()));
                this.writer.write("<br>");
                this.writer.newLine();
                String gdescription = groups[i].getDescription();
                if (gdescription != null && gdescription.length() > 0) {
                    this.writeEncoded("gdesc=" + EncodeHtmlTag.encode(gdescription));
                    this.writer.write("<br>");
                    this.writer.newLine();
                }
                Iterator users = groups[i].getUserMembers(false);
                String delim = null;
                if (users.hasNext()) {
                    this.writeEncoded("user=");
                }
                while (users.hasNext()) {
                    IUser user = this.userFactory().getUser((String)users.next());
                    delim = users.hasNext() ? ";" : "";
                    this.writeEncoded(EncodeHtmlTag.encode(user.getUniqueName()) + delim);
                }
                this.writer.write("<br>");
                this.writer.newLine();
                Iterator nested_groups = groups[i].getGroupMembers(false);
                if (nested_groups.hasNext()) {
                    this.writeEncoded("group=");
                }
                while (nested_groups.hasNext()) {
                    IGroup gr = UMFactory.getGroupFactory().getGroup((String)nested_groups.next());
                    delim = nested_groups.hasNext() ? ";" : "";
                    this.writeEncoded(EncodeHtmlTag.encode(gr.getUniqueName()) + delim);
                }
                this.writer.write("<br>");
                this.writer.newLine();
                ++i;
            }
        }
        catch (Exception nsge) {
            throw new BatchException(nsge.getMessage());
        }
    }

    public void downloadRoles(String[] uids, boolean inPortal) throws BatchException {
        try {
            IRole[] roles = UMFactory.getRoleFactory().getRoles(uids);
            int i = 0;
            while (i < roles.length) {
                this.writeEncoded("[role]");
                this.writer.write("<br>");
                this.writer.newLine();
                this.writeEncoded("rid=" + EncodeHtmlTag.encode(roles[i].getUniqueName()));
                this.writer.write("<br>");
                this.writer.newLine();
                String rdescription = roles[i].getDescription();
                if (rdescription != null && rdescription.length() > 0) {
                    this.writeEncoded("rdesc=" + EncodeHtmlTag.encode(rdescription));
                    this.writer.write("<br>");
                    this.writer.newLine();
                }
                Iterator actions = PermissionRoles.getActions(roles[i]);
                String delim = null;
                if (actions.hasNext()) {
                    this.writeEncoded("action=");
                }
                while (actions.hasNext()) {
                    IServiceAction action = (IServiceAction)actions.next();
                    this.writeEncoded(EncodeHtmlTag.encode(action.getUniqueID()));
                    delim = actions.hasNext() ? ";" : "";
                    this.writeEncoded(delim);
                }
                this.writer.write("<br>");
                this.writer.newLine();
                Iterator users = roles[i].getUserMembers(false);
                delim = null;
                if (users.hasNext()) {
                    this.writeEncoded("user=");
                }
                while (users.hasNext()) {
                    String uniqueID = (String)users.next();
                    try {
                        IUser user = this.userFactory().getUser(uniqueID);
                        delim = users.hasNext() ? ";" : "";
                        this.writeEncoded(EncodeHtmlTag.encode(user.getUniqueName()) + delim);
                    }
                    catch (UMException exc) {
                        trace.infoT("downloadRoles(String[],boolean", "User member not found: " + uniqueID, exc);
                    }
                }
                this.writer.write("<br>");
                this.writer.newLine();
                Iterator nested_groups = roles[i].getGroupMembers(false);
                if (nested_groups.hasNext()) {
                    this.writeEncoded("group=");
                }
                while (nested_groups.hasNext()) {
                    String uniqueID = (String)nested_groups.next();
                    try {
                        IGroup gr = UMFactory.getGroupFactory().getGroup(uniqueID);
                        delim = nested_groups.hasNext() ? ";" : "";
                        this.writeEncoded(EncodeHtmlTag.encode(gr.getUniqueName()) + delim);
                    }
                    catch (UMException exc) {
                        trace.infoT("downloadRoles(String[],boolean", "Group member not found: " + uniqueID, exc);
                    }
                }
                this.writer.write("<br>");
                this.writer.newLine();
                ++i;
            }
        }
        catch (Exception nsge) {
            throw new BatchException(nsge.getMessage());
        }
    }

    private void removeMemberFromPrincipalSetMap(String memberUid, String principalSetUID) {
        HashSet<String> members = (HashSet<String>)this.principalsetToRemoveMap.get(principalSetUID);
        if (members == null) {
            members = new HashSet<String>();
            this.principalsetToRemoveMap.put(principalSetUID, members);
        }
        if (!members.contains(memberUid)) {
            members.add(memberUid);
        }
    }

    private void addMemberToPrincipalSetMap(String memberUid, String principalSetUID) {
        HashSet<String> members = (HashSet<String>)this.principalsetToAddMap.get(principalSetUID);
        if (members == null) {
            members = new HashSet<String>();
            this.principalsetToAddMap.put(principalSetUID, members);
        }
        if (!members.contains(memberUid)) {
            members.add(memberUid);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doPrincipalSets(Vector results) {
        pf = UMFactory.getPrincipalFactory();
        principalsets = this.principalsetToRemoveMap.keySet().iterator();
        block8: while (principalsets.hasNext()) {
            principalSetUID = (String)principalsets.next();
            try {
                principal = pf.getMutablePrincipal(principalSetUID);
                if (!(principal instanceof IPrincipalSet)) continue;
                members = (HashSet)this.principalsetToRemoveMap.get(principalSetUID);
                i = members.iterator();
                while (i.hasNext()) {
                    id = (String)i.next();
                    ((IPrincipalSet)principal).removeMember(id);
                }
                principal.save();
                principal.commit();
                continue;
            }
            catch (UMException umex) {
                if (Batch.trace.beDebug()) {
                    Batch.trace.debugT("doPrincipalSets", "Error during assignment: " + umex.getMessage(), umex);
                }
                members = (HashSet)this.principalsetToRemoveMap.get(principalSetUID);
                i = members.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                id = (String)i.next();
                j = 0;
                while (j < results.size()) {
                    user = (HashMap)results.get(j);
                    result_uid = (String)user.get("UniqueUserID");
                    if (id.equals(result_uid)) {
                        this.addWarning(user, this.msgs.print(new Message("CANT_REMOVE_USER_FROM_ROLE_X", principalSetUID)));
                    }
                    ++j;
                }
                continue;
lbl34:
                // 1 sources

            }
        }
        principalsets = this.principalsetToAddMap.keySet().iterator();
        block12: while (principalsets.hasNext()) {
            principalSetUID = (String)principalsets.next();
            try {
                try {
                    principal = pf.getMutablePrincipal(principalSetUID);
                    if (!(principal instanceof IPrincipalSet)) continue;
                    members = (HashSet)this.principalsetToAddMap.get(principalSetUID);
                    i = members.iterator();
                    while (i.hasNext()) {
                        id = (String)i.next();
                        ((IPrincipalSet)principal).addMember(id);
                    }
                    principal.save();
                    principal.commit();
                    continue;
                }
                catch (AttributeValueAlreadyExistsException avae) {
                    members = (HashSet)this.principalsetToAddMap.get(principalSetUID);
                    i = members.iterator();
                    ** while (i.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    id = (String)i.next();
                    try {
                        pf.addPrincipalToParent(id, principalSetUID);
                    }
                    catch (AttributeValueAlreadyExistsException avae2) {
                        if (!Batch.trace.beDebug()) continue;
                        Batch.trace.debugT("doPrincipalSets", "Cannot add member \"" + id + "\" to principal \"" + principalSetUID + "\" because it is already its member.");
                    }
                    continue;
lbl64:
                    // 1 sources

                    continue block12;
                }
            }
            catch (UMException umex) {
                if (Batch.trace.beDebug()) {
                    Batch.trace.debugT("doPrincipalSets", "Error during assignment: " + umex.getMessage(), umex);
                }
                members = (HashSet)this.principalsetToRemoveMap.get(principalSetUID);
                i = members.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                id = (String)i.next();
                j = 0;
                while (j < results.size()) {
                    user = (HashMap)results.get(j);
                    result_uid = (String)user.get("UniqueUserID");
                    if (id.equals(result_uid)) {
                        this.addWarning(user, this.msgs.print(new Message("CANT_ADD_USER_TO_ROLE_X", principalSetUID)));
                    }
                    ++j;
                }
                continue;
lbl81:
                // 1 sources

            }
        }
        this.principalsetToRemoveMap.clear();
        this.principalsetToAddMap.clear();
    }

    private void writeEncoded(String text) throws IOException {
        this.writer.write(EncodeHtmlTag.encode(text));
    }
}

