/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import com.sap.security.api.ISecurityPolicy;
import java.security.SecureRandom;

public class SecurityUtils {
    public static final String GENERAL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final String SPECIAL_CHARS = "~!@#$%&*?";
    public static final String NUMERIC_CHARS = "1234567890";
    public static final String UPPERCA_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWERCA_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static SecureRandom random = new SecureRandom();

    public static String GeneratePassword(int PasswordLength) {
        return SecurityUtils.generateRandomChars(PasswordLength, GENERAL_CHARS);
    }

    public static String generateRandomChars(int PasswordLength, String pChars) {
        String characters = pChars;
        char[] chars = new char[PasswordLength];
        int i = 0;
        while (i < PasswordLength) {
            chars[i] = characters.charAt(random.nextInt(characters.length()));
            ++i;
        }
        return new String(chars);
    }

    public static String randomize(String s) {
        if (s == null) {
            return null;
        }
        char[] array = s.toCharArray();
        SecurityUtils.randomize(array);
        return new String(array);
    }

    public static void randomize(char[] array) {
        int length = array.length;
        int i = 0;
        while (i < length - 1) {
            int x = random.nextInt(length);
            char y = array[i];
            array[i] = array[i + x];
            array[i + x] = y;
            --length;
            ++i;
        }
    }

    public static String getSpecialChars(int length) {
        return SecurityUtils.generateRandomChars(length, SPECIAL_CHARS);
    }

    public static String getNumericChars(int length) {
        return SecurityUtils.generateRandomChars(length, NUMERIC_CHARS);
    }

    public static String getUCaseLetterChars(int length) {
        return SecurityUtils.generateRandomChars(length, UPPERCA_CHARS);
    }

    public static String getLCaseLetterChars(int length) {
        return SecurityUtils.generateRandomChars(length, LOWERCA_CHARS);
    }

    public static String GeneratePassword(ISecurityPolicy secpolicy) {
        return secpolicy.generatePassword();
    }
}

