/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.util.IUMParameters;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.imp.SystemUser;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.RefreshTask;
import com.sap.security.core.util.imp.UMParameters;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class SecurityAudit {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/SecurityAudit.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/SecurityAudit.java#3 $ from $DateTime: 2005/01/21 16:34:10 $ ($Change: 17855 $)");
    private static final IUMParameters properties = UMFactory.getProperties();
    private static final String CHANGELIST_TOKEN = "$Change: ";
    private static final String CHANGELIST_PREFIX = ": ";
    private static final String CHANGELIST_POSTFIX = " $";
    private static final String VERSION_PREFIX = "#";
    private static final String VERSION_POSTFIX = " $";
    private static final String AUDIT_CATEGORY = "/System/Security/Audit";
    private static final String LOGIN_CATEGORY = "/System/Security/Login";
    private static final String PRINCIPAL_USER = "USER";
    private static final String PRINCIPAL_UACC = "USERACCOUNT";
    private static final String PRINCIPAL_GROUP = "GROUP";
    private static final String PRINCIPAL_ROLE = "ROLE";
    private static final String PRINCIPAL_COMMON = "PRINCIPAL";
    private static final String PRINCIPAL_NONE = "NONE";
    public static final String EVENT_USER_CREATE = "USER.CREATE";
    public static final String EVENT_USER_CREATE_DETAILS = "USER.CREATE_DETAILS";
    public static final String EVENT_USERACCOUNT_CREATE = "USERACCOUNT.CREATE";
    public static final String EVENT_GROUP_CREATE = "GROUP.CREATE";
    public static final String EVENT_ROLE_CREATE = "ROLE.CREATE";
    public static final String EVENT_USER_MODIFY = "USER.MODIFY";
    public static final String EVENT_USER_MODIFY_DETAILS = "USER.MODIFY_DETAILS";
    public static final String EVENT_USERACCOUNT_MODIFY = "USERACCOUNT.MODIFY";
    public static final String EVENT_GROUP_MODIFY = "GROUP.MODIFY";
    public static final String EVENT_ROLE_MODIFY = "ROLE.MODIFY";
    public static final String EVENT_USER_DELETE = "USER.DELETE";
    public static final String EVENT_USERACCOUNT_DELETE = "USERACCOUNT.DELETE";
    public static final String EVENT_GROUP_DELETE = "GROUP.DELETE";
    public static final String EVENT_ROLE_DELETE = "ROLE.DELETE";
    public static final String EVENT_USERMAPPING_CREATE = "USERMAPPING.CREATE";
    public static final String EVENT_USERMAPPING_MODIFY = "USERMAPPING.MODIFY";
    public static final String EVENT_USERMAPPING_DELETE = "USERMAPPING.DELETE";
    public static final String EVENT_USERMAPPING_USE = "USERMAPPING.USE";
    public static final String EVENT_LOGIN_OK = "LOGIN.OK";
    public static final String EVENT_LOGIN_ERROR = "LOGIN.ERROR";
    public static final String EVENT_LOGOFF = "LOGOFF.OK";
    public static final String EVENT_ACL_CREATE = "ACL.CREATE";
    public static final String EVENT_ACL_MODIFY = "ACL.MODIFY";
    public static final String EVENT_ACL_DELETE = "ACL.DELETE";
    public static final String EVENT_ACCESS_OK = "ACCESS.OK";
    public static final String EVENT_ACCESS_ERROR = "ACCESS.ERROR";
    public static final String EVENT_CUSTOMIZE = "CUSTOMIZE";
    public static final String EVENT_PRINCIPAL_CREATE = "PRINCIPAL.CREATE";
    public static final String EVENT_PRINCIPAL_MODIFY = "PRINCIPAL.MODIFY";
    public static final String EVENT_PRINCIPAL_DELETE = "PRINCIPAL.DELETE";
    private static final String SYSTEM_USER_NAME = SystemUser.getInstance().getUniqueName();
    private static final boolean getObjectName = properties.getBoolean("ume.secaudit.get_object_name", false);
    private static final boolean logActor = properties.getBoolean("ume.secaudit.log_actor", true);
    private static Set secretAttributesSet = new HashSet();
    private static Map principalNameMap = new HashMap();
    private static Map principalDetailsMap = new HashMap();
    private static Map eventSeverityMap = new HashMap();
    private static Category cat;
    private static Location loc;
    private static boolean initialized;
    private static int effectiveSeverity;
    private static Timer refreshTimer;

    private static void initialize() {
        String methodName = "initialize()";
        if (!properties.getBoolean("ume.trace.internal_trace", false)) {
            loc = Location.getLocation((String)"com.sap.security");
            cat = Category.getCategory((String)AUDIT_CATEGORY);
            effectiveSeverity = cat.getEffectiveSeverity();
            initialized = true;
            if (trace.beInfo()) {
                trace.infoT("initialize()", "SecurityAudit was successfully initialized");
            }
        } else {
            trace.warningT("initialize()", "Internal trace is activated; no log messages will be written!");
        }
    }

    public static boolean logOldAttributeValues() {
        return effectiveSeverity == 0;
    }

    protected static void updateEffectiveSeverity() {
        trace.infoT("updateEffectiveSeverity()", "Refreshing the logging severity");
        if (cat != null) {
            effectiveSeverity = cat.getEffectiveSeverity();
        }
    }

    public static void log(String event, String objectID, String objectName, Map details) {
        if (!initialized) {
            return;
        }
        if (event == null) {
            trace.warningT("log(...)", "No event type was specified!");
            return;
        }
        if (objectID == null && trace.beInfo()) {
            trace.infoT("log(...)", "ObjectID handed over is 'null'!");
        }
        String objectType = SecurityAudit.getObjectType(event, objectID);
        if (event.startsWith(PRINCIPAL_COMMON) && !objectType.equals(PRINCIPAL_NONE)) {
            event = objectType + event.substring(PRINCIPAL_COMMON.length());
        }
        SecurityAudit.logToFile(event, objectType, objectID, objectName, details);
        if (!SecurityAudit.logOldAttributeValues() && (event.equals(EVENT_USER_CREATE) || event.equals(EVENT_USER_MODIFY))) {
            SecurityAudit.logToFile(event + "_DETAILS", objectType, objectID, objectName, details);
        }
    }

    public static void log(String event, String objectID, Map details) {
        String methodName = "log(String, String, Map)";
        String objectName = null;
        if (getObjectName) {
            String objectType = SecurityAudit.getObjectType(event, objectID);
            IUser principal = null;
            try {
                if (objectType != null && !PRINCIPAL_NONE.equals(objectType)) {
                    if (PRINCIPAL_USER.equals(objectType)) {
                        principal = UMFactory.getUserFactory().getUser(objectID);
                    } else if (PRINCIPAL_UACC.equals(objectType)) {
                        principal = UMFactory.getUserAccountFactory().getUserAccount(objectID);
                    } else if (PRINCIPAL_GROUP.equals(objectType)) {
                        principal = UMFactory.getGroupFactory().getGroup(objectID);
                    } else if (PRINCIPAL_ROLE.equals(objectType)) {
                        principal = UMFactory.getRoleFactory().getRole(objectID);
                    }
                    if (principal != null) {
                        objectName = principal.getDisplayName();
                    }
                }
            }
            catch (UMException exc) {
                trace.warningT("log(String, String, Map)", "Couldn't get IPrincipal for ID: " + objectID, exc);
            }
        }
        SecurityAudit.log(event, objectID, objectName, details);
    }

    private static String getActor() {
        if (!logActor) {
            return "<anonymous>";
        }
        String logonId = InternalUMFactory.getUserThreadAttribute();
        if (logonId != null) {
            return logonId;
        }
        if (trace.beInfo()) {
            trace.infoT("getActor()", "No user logged in -> using system user");
        }
        return SYSTEM_USER_NAME;
    }

    public static boolean isLogged(String event) {
        return effectiveSeverity <= SecurityAudit.getEventSeverity(event);
    }

    public static boolean isLogged(String event, String objectID) {
        String objectType = SecurityAudit.getObjectType(event, objectID);
        if (event.startsWith(PRINCIPAL_COMMON) && !objectType.equals(PRINCIPAL_NONE)) {
            event = objectType + event.substring(PRINCIPAL_COMMON.length());
        }
        return effectiveSeverity <= SecurityAudit.getEventSeverity(event);
    }

    private static void logToFile(String event, String objectType, String objectID, String objectName, Map details) {
        int eventSeverity = SecurityAudit.getEventSeverity(event);
        if (eventSeverity < effectiveSeverity) {
            return;
        }
        String detailsString = SecurityAudit.analyseDetails(event, details);
        if (!"".equals(detailsString)) {
            String SEPARATOR = "\t| ";
            StringBuffer logOutput = new StringBuffer(150);
            logOutput.append(SecurityAudit.getActor());
            logOutput.append("\t| ");
            logOutput.append(event);
            logOutput.append("\t| ");
            logOutput.append(objectType);
            logOutput.append(" = ");
            logOutput.append(objectID);
            logOutput.append("\t| ");
            if (objectName != null) {
                logOutput.append(objectName);
            }
            if (detailsString != null) {
                logOutput.append("\t| ").append(detailsString);
            }
            cat.logT(eventSeverity, loc, "logToFile", logOutput.toString());
        }
    }

    private static String analyseDetails(String event, Map details) {
        String[] principalDetails = null;
        if (!SecurityAudit.logOldAttributeValues()) {
            principalDetails = (String[])principalDetailsMap.get(event);
        }
        if (details == null) {
            if (principalDetails != null && principalDetails.length != 0) {
                return "";
            }
            return null;
        }
        if (principalDetails != null && principalDetails.length == 0) {
            return null;
        }
        StringBuffer tempSB = new StringBuffer();
        boolean passwordDetected = false;
        boolean attributesToLog = false;
        boolean customizeEvent = EVENT_CUSTOMIZE.equals(event);
        Iterator entries = details.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry mapEntry = entries.next();
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            if (key instanceof String[]) {
                String[] keyArray = (String[])key;
                if (principalDetails != null) {
                    boolean found = false;
                    int i = 0;
                    while (i < principalDetails.length) {
                        if (principalDetails[i].equals(keyArray[2])) {
                            found = true;
                            attributesToLog = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) continue;
                }
                tempSB.append(keyArray[0]);
                tempSB.append(CHANGELIST_PREFIX);
                tempSB.append(keyArray[2]);
                passwordDetected = SecurityAudit.isSecretAttribute(keyArray[2]);
            } else {
                tempSB.append(key);
                if (customizeEvent) {
                    passwordDetected = UMParameters.isSecureProperty((String)key);
                }
            }
            tempSB.append("=[");
            if (passwordDetected) {
                tempSB.append("******");
                passwordDetected = false;
            } else if (value instanceof Vector[]) {
                int i;
                int size;
                Vector oldValueVector = ((Vector[])value)[0];
                Vector newValueVector = ((Vector[])value)[1];
                if (SecurityAudit.logOldAttributeValues()) {
                    if (oldValueVector != null) {
                        tempSB.append("{");
                        size = oldValueVector.size();
                        i = 0;
                        while (i < size) {
                            Object oldValue;
                            if (i != 0) {
                                tempSB.append(", ");
                            }
                            if ((oldValue = oldValueVector.get(i)) != null) {
                                tempSB.append(oldValue);
                            }
                            ++i;
                        }
                    }
                    tempSB.append("} -> {");
                }
                if (newValueVector != null) {
                    size = newValueVector.size();
                    i = 0;
                    while (i < size) {
                        Object newValue;
                        if (i != 0) {
                            tempSB.append(", ");
                        }
                        if ((newValue = newValueVector.get(i)) != null) {
                            tempSB.append(newValue);
                        }
                        ++i;
                    }
                }
                if (SecurityAudit.logOldAttributeValues()) {
                    tempSB.append("}");
                }
            } else {
                tempSB.append(value);
            }
            tempSB.append("], ");
        }
        if (tempSB.length() >= 2) {
            tempSB.setLength(tempSB.length() - 2);
        }
        if (principalDetails != null && !attributesToLog) {
            return "";
        }
        if (tempSB.length() > 0) {
            return tempSB.toString();
        }
        return null;
    }

    private static String getObjectType(String event, String objectID) {
        if (objectID == null) {
            return PRINCIPAL_NONE;
        }
        if (!(event.startsWith(PRINCIPAL_USER) || event.startsWith(PRINCIPAL_UACC) || event.startsWith(PRINCIPAL_GROUP) || event.startsWith(PRINCIPAL_ROLE) || event.startsWith(PRINCIPAL_COMMON) || event.startsWith("USERMAPPING") || event.startsWith("LOGIN") || event.startsWith("LOGOFF"))) {
            return PRINCIPAL_NONE;
        }
        try {
            String principalType = UMFactory.getPrincipalFactory().getPrincipalType(objectID);
            String name = (String)principalNameMap.get(principalType);
            if (name == null) {
                return PRINCIPAL_NONE;
            }
            return name;
        }
        catch (UMException exc) {
            if (trace.beInfo()) {
                trace.infoT("getObjectType(String)", "Couldn't get principal type of ID: " + objectID, exc);
            }
            return PRINCIPAL_NONE;
        }
    }

    private static int getEventSeverity(String event) {
        Integer eventSeverity = (Integer)eventSeverityMap.get(event);
        if (eventSeverity == null) {
            if (trace.beWarning()) {
                trace.warningT("getSeverityFromEvent(String)", "Couldn't get severity from event; using default value!");
            }
            return 500;
        }
        return eventSeverity;
    }

    private static boolean isSecretAttribute(String attributeName) {
        return secretAttributesSet.contains(attributeName);
    }

    private static void createEventSeverityMap() {
        eventSeverityMap.put(EVENT_USER_CREATE, new Integer(400));
        eventSeverityMap.put(EVENT_USER_CREATE_DETAILS, new Integer(300));
        eventSeverityMap.put(EVENT_USERACCOUNT_CREATE, new Integer(500));
        eventSeverityMap.put(EVENT_GROUP_CREATE, new Integer(500));
        eventSeverityMap.put(EVENT_ROLE_CREATE, new Integer(500));
        eventSeverityMap.put(EVENT_USER_MODIFY, new Integer(400));
        eventSeverityMap.put(EVENT_USER_MODIFY_DETAILS, new Integer(300));
        eventSeverityMap.put(EVENT_USERACCOUNT_MODIFY, new Integer(500));
        eventSeverityMap.put(EVENT_GROUP_MODIFY, new Integer(500));
        eventSeverityMap.put(EVENT_ROLE_MODIFY, new Integer(500));
        eventSeverityMap.put(EVENT_USER_DELETE, new Integer(400));
        eventSeverityMap.put(EVENT_USERACCOUNT_DELETE, new Integer(500));
        eventSeverityMap.put(EVENT_GROUP_DELETE, new Integer(500));
        eventSeverityMap.put(EVENT_ROLE_DELETE, new Integer(500));
        eventSeverityMap.put(EVENT_USERMAPPING_CREATE, new Integer(400));
        eventSeverityMap.put(EVENT_USERMAPPING_MODIFY, new Integer(400));
        eventSeverityMap.put(EVENT_USERMAPPING_DELETE, new Integer(400));
        eventSeverityMap.put(EVENT_USERMAPPING_USE, new Integer(400));
        eventSeverityMap.put(EVENT_LOGIN_OK, new Integer(400));
        eventSeverityMap.put(EVENT_LOGIN_ERROR, new Integer(500));
        eventSeverityMap.put(EVENT_LOGOFF, new Integer(400));
        eventSeverityMap.put(EVENT_ACL_CREATE, new Integer(500));
        eventSeverityMap.put(EVENT_ACL_MODIFY, new Integer(500));
        eventSeverityMap.put(EVENT_ACL_DELETE, new Integer(500));
        eventSeverityMap.put(EVENT_ACCESS_OK, new Integer(300));
        eventSeverityMap.put(EVENT_ACCESS_ERROR, new Integer(600));
        eventSeverityMap.put(EVENT_CUSTOMIZE, new Integer(500));
        eventSeverityMap.put(EVENT_PRINCIPAL_CREATE, new Integer(100));
        eventSeverityMap.put(EVENT_PRINCIPAL_MODIFY, new Integer(100));
        eventSeverityMap.put(EVENT_PRINCIPAL_DELETE, new Integer(100));
    }

    private static void createPrincipalNameMap() {
        principalNameMap.put("IUser", PRINCIPAL_USER);
        principalNameMap.put("IUserAccount", PRINCIPAL_UACC);
        principalNameMap.put("IGroup", PRINCIPAL_GROUP);
        principalNameMap.put("IRole", PRINCIPAL_ROLE);
        principalNameMap.put("IPrincipal", PRINCIPAL_COMMON);
        principalNameMap.put("IPrincipalSet", PRINCIPAL_COMMON);
    }

    private static void createPrincipalDetailsMap() {
        principalDetailsMap.put(EVENT_USER_CREATE, new String[]{"uniquename", "company"});
        principalDetailsMap.put(EVENT_USERACCOUNT_CREATE, new String[]{"userid"});
        principalDetailsMap.put(EVENT_GROUP_CREATE, new String[]{"uniquename", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE"});
        principalDetailsMap.put(EVENT_ROLE_CREATE, new String[]{"uniquename", "PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", "actions"});
        principalDetailsMap.put(EVENT_USER_MODIFY, new String[]{"company"});
        principalDetailsMap.put(EVENT_USERACCOUNT_MODIFY, new String[]{"islocked", "lockreason", "passwordchangerequired", "lastpasswordchange", "certificatehash"});
        principalDetailsMap.put(EVENT_GROUP_MODIFY, new String[]{"PRINCIPAL_RELATION_MEMBER_ATTRIBUTE"});
        principalDetailsMap.put(EVENT_ROLE_MODIFY, new String[]{"PRINCIPAL_RELATION_MEMBER_ATTRIBUTE", "actions"});
        principalDetailsMap.put(EVENT_USER_DELETE, new String[0]);
        principalDetailsMap.put(EVENT_USERACCOUNT_DELETE, new String[]{"userid"});
        principalDetailsMap.put(EVENT_GROUP_DELETE, new String[0]);
        principalDetailsMap.put(EVENT_ROLE_DELETE, new String[0]);
    }

    private static void createSecretAttributesSet() {
        secretAttributesSet.add("j_password");
        secretAttributesSet.add("oldpassword");
        secretAttributesSet.add("com.sap.security.core.umap.key");
    }

    private static Map getVersion() {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        try {
            versionMap.put("Version", VERSIONSTRING.substring(VERSIONSTRING.indexOf(VERSION_PREFIX, 0) + 1, VERSIONSTRING.indexOf(" $", 1)));
            int changelistPos = VERSIONSTRING.indexOf(CHANGELIST_TOKEN);
            if (changelistPos != -1) {
                versionMap.put("Changelist", VERSIONSTRING.substring(VERSIONSTRING.indexOf(CHANGELIST_PREFIX, changelistPos) + 2, VERSIONSTRING.indexOf(" $", changelistPos + 1)));
            }
        }
        catch (Exception exception) {
            trace.warningT("parseVersionString(String)", "Couldn't get version of SecurityAudit class!", exception);
        }
        return versionMap;
    }

    static {
        initialized = false;
        SecurityAudit.initialize();
        SecurityAudit.createPrincipalNameMap();
        SecurityAudit.createEventSeverityMap();
        SecurityAudit.createPrincipalDetailsMap();
        SecurityAudit.createSecretAttributesSet();
        int refreshTime = properties.getNumber("ume.trace.reload_time", 5) * 60000;
        refreshTimer = new Timer(true);
        refreshTimer.schedule((TimerTask)new RefreshTask(), refreshTime, (long)refreshTime);
        SecurityAudit.log(EVENT_CUSTOMIZE, "SecurityAudit", SecurityAudit.getVersion());
        SecurityAudit.log(EVENT_CUSTOMIZE, "Properties", properties.getProperties());
    }
}

