/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import com.sap.security.api.UMFactory;
import com.sap.security.core.InternalUMFactory;
import com.sap.security.core.util.IUMTrace;
import com.sap.security.core.util.Message;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceBean {
    public static final String VERSIONSTRING = "$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/ResourceBean.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)";
    private static final IUMTrace trace = InternalUMFactory.getTrace("$Id: //shared_tc/com.sapall.security/630_VAL_REL/src/_core/java/com/sap/security/core/util/ResourceBean.java#2 $ from $DateTime: 2004/06/09 16:32:18 $ ($Change: 16222 $)");
    private static final String defaultLabel = "missing";
    private static final boolean show_resource_keys = UMFactory.getProperties().getBoolean("UM_SHOW_RESOURCE_KEYS", false);
    private Locale locale = null;
    private ResourceBundle resourceBundle = null;
    private ResourceBundle pageResourceBundle = null;
    private Properties resourceBundleFromEngine = null;
    private static HashMap bundleCache = new HashMap();

    public ResourceBean(Locale locale, String baseName) {
        this.init(locale, baseName, this.getClass().getClassLoader());
    }

    public ResourceBean(Locale locale, String baseName, ClassLoader cl) {
        this.init(locale, baseName, cl);
    }

    private void init(Locale locale, String baseName, ClassLoader cl) {
        if (trace.bePath()) {
            trace.entering("ResourceBean", new Object[]{locale, baseName});
        }
        this.locale = locale != null ? locale : Locale.getDefault();
        this.initEngineBundle(baseName, this.locale);
        this.resourceBundle = ResourceBundle.getBundle(baseName, this.locale, cl);
    }

    public ResourceBean(Locale locale, String baseName, String pageBaseName) {
        this.init(locale, baseName, pageBaseName, this.getClass().getClassLoader());
    }

    public ResourceBean(Locale locale, String baseName, String pageBaseName, ClassLoader cl) {
        this.init(locale, baseName, pageBaseName, cl);
    }

    private void init(Locale locale, String baseName, String pageBaseName, ClassLoader cl) {
        if (trace.bePath()) {
            trace.entering("ResourceBean", new Object[]{locale, baseName, pageBaseName});
        }
        this.locale = locale != null ? locale : Locale.getDefault();
        this.initEngineBundle(baseName, this.locale);
        this.resourceBundle = ResourceBundle.getBundle(baseName, this.locale, cl);
        this.pageResourceBundle = ResourceBundle.getBundle(pageBaseName, this.locale, cl);
    }

    public String get(String key) {
        if (show_resource_keys) {
            return "***" + key + "***";
        }
        try {
            String value;
            if (this.resourceBundleFromEngine != null && (value = (String)((Hashtable)this.resourceBundleFromEngine).get(key)) != null) {
                return value;
            }
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            trace.errorT("get", "failed to fetch key from ResourceBundle", ex);
            return defaultLabel;
        }
    }

    public String getPage(String key) throws MissingResourceException {
        return this.pageResourceBundle.getString(key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getString(Message message) {
        if (show_resource_keys) {
            return "***" + message.messageId + "***";
        }
        try {
            String value;
            if (this.resourceBundleFromEngine != null && (value = (String)((Hashtable)this.resourceBundleFromEngine).get(message.messageId)) != null) {
                return value;
            }
            return this.resourceBundle.getString(message.messageId);
        }
        catch (MissingResourceException ex) {
            trace.errorT("print", "Message ID (" + message.messageId + ") not found in properties files-" + ex.getKey(), ex);
            return "Unknown message (ID = " + message.messageId + ")";
        }
    }

    public String print(Message message) {
        if (show_resource_keys) {
            return "***" + message.messageId + "***";
        }
        try {
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(this.locale);
            String msg = this.parsePattern(this.getString(message));
            formatter.applyPattern(msg);
            return formatter.format(message.args);
        }
        catch (MissingResourceException ex) {
            trace.errorT("print", "Message ID (" + message.messageId + ") not found in properties files-" + ex.getKey(), ex);
            return "Unknown message (ID = " + message.messageId + ")";
        }
        catch (Exception ex) {
            trace.errorT("print", "Message cannot be formatted. Message ID (" + message.messageId + "). Reason: " + ex.getMessage(), ex);
            return "Wrong message (ID = " + message.messageId + ")";
        }
    }

    public String parsePattern(String newPattern) {
        StringBuffer segments = new StringBuffer(newPattern.length());
        int i = 0;
        while (i < newPattern.length()) {
            char ch = newPattern.charAt(i);
            if (ch == '\'') {
                if (i + 1 == newPattern.length()) {
                    segments.append(ch).append(ch);
                } else if (newPattern.charAt(i + 1) == '\'') {
                    segments.append(ch);
                    ++i;
                } else {
                    segments.append(ch).append(ch);
                }
            } else {
                segments.append(ch);
            }
            ++i;
        }
        return segments.toString();
    }

    private void initEngineBundle(String baseName, Locale locale) {
        String variant;
        String country;
        String lang = locale.getLanguage();
        if (lang != null && lang.length() == 0) {
            lang = null;
        }
        if ((country = locale.getCountry()) != null && country.length() == 0) {
            country = null;
        }
        if ((variant = locale.getVariant()) != null && variant.length() == 0) {
            variant = null;
        }
        String bundleName = baseName;
        Properties props = null;
        try {
            if (lang != null && country != null && variant != null) {
                props = ResourceBean.getBundle(bundleName.concat("_" + lang + "_" + country + "_" + variant + ".properties"));
            }
            if (props == null && lang != null && country != null) {
                props = ResourceBean.getBundle(bundleName.concat("_" + lang + "_" + country + ".properties"));
            }
            if (props == null && lang != null) {
                props = ResourceBean.getBundle(bundleName.concat("_" + lang + ".properties"));
            }
            if (props == null) {
                props = ResourceBean.getBundle(bundleName.concat(".properties"));
            }
            if (props != null) {
                this.resourceBundleFromEngine = props;
            }
        }
        catch (IOException ioe) {
            trace.warningT("initEngineBundle", ioe);
        }
    }

    private static synchronized Properties getBundle(String bundleName) throws IOException {
        Properties props = (Properties)bundleCache.get(bundleName);
        if (props != null || bundleCache.containsKey(bundleName)) {
            return props;
        }
        InputStream stream = UMFactory.getUMFileIO().readFile(bundleName);
        if (stream == null) {
            props = null;
        } else {
            props = new Properties();
            props.load(stream);
        }
        bundleCache.put(bundleName, props);
        return props;
    }

    public Enumeration getIds() {
        Enumeration ids;
        if (this.resourceBundleFromEngine != null && (ids = ((Hashtable)this.resourceBundleFromEngine).keys()) != null && ids.hasMoreElements()) {
            return ids;
        }
        return this.resourceBundle.getKeys();
    }
}

