/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;

public class PropertiesUTF8
extends Properties {
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";

    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if (line.length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.continueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = new String("");
                }
                String loppedLine = line.substring(0, line.length() - 1);
                int startIndex = 0;
                startIndex = 0;
                while (startIndex < nextLine.length()) {
                    if (whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) == -1) break;
                    ++startIndex;
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
            }
            int len = line.length();
            int keyStart = 0;
            while (keyStart < len) {
                if (whiteSpaceChars.indexOf(line.charAt(keyStart)) == -1) break;
                ++keyStart;
            }
            if (keyStart == len) continue;
            int separatorIndex = keyStart;
            while (separatorIndex < len) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                } else if (keyValueSeparators.indexOf(currentChar) != -1) break;
                ++separatorIndex;
            }
            int valueIndex = separatorIndex;
            while (valueIndex < len) {
                if (whiteSpaceChars.indexOf(line.charAt(valueIndex)) == -1) break;
                ++valueIndex;
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len) {
                if (whiteSpaceChars.indexOf(line.charAt(valueIndex)) == -1) break;
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            key = this.loadConvert(key);
            value = this.loadConvert(value);
            ((Hashtable)this).put(key, value);
        }
        return;
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

