/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class LocaleString {
    private Map localeMap = new HashMap();
    private static Locale enLocale = new Locale("en", "US");

    public String get(Locale locale) throws MissingResourceException {
        String value = this.getByLocale(locale);
        if (null == value && null == (value = this.getByLocale(Locale.getDefault())) && null == (value = this.getByLocale(enLocale))) {
            Iterator iter = this.localeMap.values().iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
            } else {
                throw new MissingResourceException("No value found for locale", this.getClass().getName(), locale.toString());
            }
        }
        return value;
    }

    public void put(String locale, String value) {
        this.localeMap.put(locale, value);
    }

    private String getByLocale(Locale locale) {
        String value;
        if (null != locale.getVariant() && null != (value = (String)this.localeMap.get(locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant()))) {
            return value;
        }
        if (null != locale.getCountry() && null != (value = (String)this.localeMap.get(locale.getLanguage() + "_" + locale.getCountry()))) {
            return value;
        }
        if (null != locale.getLanguage() && null != (value = (String)this.localeMap.get(locale.getLanguage()))) {
            return value;
        }
        return null;
    }
}

