/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import com.sap.security.core.vault.SecretKeyGenerator;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.utils.KeyAndCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeCertType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.GregorianCalendar;
import java.util.Vector;

public class InstallerUtils {
    public static void createKeyStore(String sysid, String ou1, String ou2, FileOutputStream fos) throws KeyStoreException, NoSuchAlgorithmException, IOException, InvalidKeyException, CodingException, CertificateException, X509ExtensionException {
        Name subject = new Name();
        subject.addRDN(ObjectID.country, (Object)"DE");
        subject.addRDN(ObjectID.organization, (Object)"SAP Trust Community");
        subject.addRDN(ObjectID.organizationalUnit, (Object)ou2);
        subject.addRDN(ObjectID.organizationalUnit, (Object)ou1);
        subject.addRDN(ObjectID.commonName, (Object)sysid);
        KeyAndCertificate kac = InstallerUtils.createSelfSigned(subject);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("TestKey", kac.getPrivateKey(), "test".toCharArray(), (Certificate[])kac.getCertificateChain());
        ks.store(fos, "test".toCharArray());
    }

    public static KeyAndCertificate createSelfSigned(Name subject) throws NoSuchAlgorithmException, InvalidKeyException, CodingException, CertificateException, X509ExtensionException {
        KeyPair myKeyPair = null;
        X509Certificate myCertificate = null;
        Object myName = null;
        AlgorithmID idAlg = null;
        Object strRDNC = null;
        Object strRDNL = null;
        Object strRDNO = null;
        Object strRDNOU = null;
        Object strRDNS = null;
        Object strRDNCN = null;
        Vector<Object> vX509Ext = new Vector<Object>();
        V3Extension[] aX509Ext = null;
        int i = 0;
        idAlg = AlgorithmID.dsa_With_SHA1;
        KeyPairGenerator generator = KeyPairGenerator.getInstance("DSA");
        generator.initialize(1024, SecretKeyGenerator.getRandom());
        myKeyPair = generator.generateKeyPair();
        vX509Ext.addElement(new NetscapeCertType(NetscapeCertType.SSL_CLIENT | NetscapeCertType.S_MIME));
        vX509Ext.addElement(new BasicConstraints(false));
        vX509Ext.addElement(new KeyUsage(31));
        aX509Ext = new V3Extension[vX509Ext.size()];
        i = 0;
        while (i < vX509Ext.size()) {
            aX509Ext[i] = (V3Extension)vX509Ext.elementAt(i);
            ++i;
        }
        myCertificate = InstallerUtils.createCertificate(subject, myKeyPair.getPublic(), subject, myKeyPair.getPrivate(), idAlg, 0, aX509Ext);
        return new KeyAndCertificate(myKeyPair.getPrivate(), new X509Certificate[]{myCertificate});
    }

    private static X509Certificate createCertificate(Name subject, PublicKey pk, Name issuer, PrivateKey sk, AlgorithmID algorithm, int serialNumber, V3Extension[] extensions) throws InvalidKeyException, X509ExtensionException, NoSuchAlgorithmException, CodingException, CertificateException, X509ExtensionException {
        X509Certificate cert = new X509Certificate();
        cert.setSerialNumber(BigInteger.valueOf(serialNumber));
        cert.setSubjectDN((Principal)subject);
        cert.setPublicKey(pk);
        cert.setIssuerDN((Principal)issuer);
        GregorianCalendar date = new GregorianCalendar();
        date.add(5, -1);
        cert.setValidNotBefore(date.getTime());
        date.add(2, 60);
        cert.setValidNotAfter(date.getTime());
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier(pk);
        if (ski != null) {
            cert.addExtension((V3Extension)ski);
        }
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                cert.addExtension(extensions[i]);
                ++i;
            }
        }
        cert.sign(algorithm, sk);
        return cert;
    }
}

