/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

import java.sql.SQLException;

public class Escape {
    private static final char ESCAPE = '\\';
    private static final char ESCAPE_REP = '1';
    private static final char APOSTROPHE = '\'';
    private static final char APOSTROPHE_REP = '2';
    private static final char PERCENT = '%';
    private static final char PERCENT_REP = '3';
    private static final char UNDERSCORE = '_';
    private static final char UNDERSCORE_REP = '4';
    private static final char UNICODE_PREFIX1 = '\u00b1';
    private static final char UNICODE_PREFIX_REP1 = '5';
    private static final char UNICODE_PREFIX2 = '\u00b2';
    private static final char UNICODE_PREFIX_REP2 = '6';
    private static final char UNICODE_PREFIX3 = '\u00b3';
    private static final char UNICODE_PREFIX_REP3 = '7';
    private static final char UNICODE_PREFIX4 = '\u00b4';
    private static final char UNICODE_PREFIX_REP4 = '8';

    public static String escapeSqlString(String s, int maxlen) throws SQLException {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length < 1) {
            return s;
        }
        StringBuffer result = new StringBuffer(length * 2);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    result.append('\\');
                    result.append('1');
                    break;
                }
                case '\'': {
                    result.append('\\');
                    result.append('2');
                    break;
                }
                case '%': {
                    result.append('\\');
                    result.append('3');
                    break;
                }
                case '_': {
                    result.append('\\');
                    result.append('4');
                    break;
                }
                case '\u00b1': {
                    result.append('\\');
                    result.append('5');
                    break;
                }
                case '\u00b2': {
                    result.append('\\');
                    result.append('6');
                    break;
                }
                case '\u00b3': {
                    result.append('\\');
                    result.append('7');
                    break;
                }
                case '\u00b4': {
                    result.append('\\');
                    result.append('8');
                    break;
                }
                default: {
                    if (Escape.isAsciiChar(c)) {
                        result.append(c);
                        break;
                    }
                    result.append(Escape.encodeUnicode(c));
                }
            }
            if (maxlen > 0 && result.length() > maxlen) {
                throw new SQLException("SQL name too long");
            }
            ++i;
        }
        return result.toString();
    }

    public static String unescapeSqlString(String s) {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length < 1) {
            return s;
        }
        StringBuffer result = new StringBuffer(length);
        boolean escaping = false;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (escaping) {
                switch (c) {
                    case '1': {
                        result.append('\\');
                        break;
                    }
                    case '2': {
                        result.append('\'');
                        break;
                    }
                    case '3': {
                        result.append('%');
                        break;
                    }
                    case '4': {
                        result.append('_');
                        break;
                    }
                    case '5': {
                        result.append('\u00b1');
                        break;
                    }
                    case '6': {
                        result.append('\u00b2');
                        break;
                    }
                    case '7': {
                        result.append('\u00b3');
                        break;
                    }
                    case '8': {
                        result.append('\u00b4');
                    }
                }
                escaping = false;
            } else {
                switch (c) {
                    case '\\': {
                        escaping = true;
                        break;
                    }
                    case '\u00b1': {
                        result.append(Escape.decodeUnicode(s.substring(i + 1, i + 2)));
                        ++i;
                        break;
                    }
                    case '\u00b2': {
                        result.append(Escape.decodeUnicode(s.substring(i + 1, i + 3)));
                        i += 2;
                        break;
                    }
                    case '\u00b3': {
                        result.append(Escape.decodeUnicode(s.substring(i + 1, i + 4)));
                        i += 3;
                        break;
                    }
                    case '\u00b4': {
                        result.append(Escape.decodeUnicode(s.substring(i + 1, i + 5)));
                        i += 4;
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static boolean isAsciiChar(char c) {
        return c <= '\u00ff';
    }

    private static String encodeUnicode(char c) {
        String s = Integer.toHexString(c);
        int length = s.length();
        switch (length) {
            case 1: {
                return '\u00b1' + s;
            }
            case 2: {
                return '\u00b2' + s;
            }
            case 3: {
                return '\u00b3' + s;
            }
            case 4: {
                return '\u00b4' + s;
            }
        }
        return "";
    }

    private static char decodeUnicode(String s) {
        return (char)Integer.parseInt(s, 16);
    }
}

