/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.util;

public class Base64 {
    private static char[] b64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] b64icode = new byte[256];

    public static String encode(byte[] data) {
        return new String(Base64.encodeAsArray(data));
    }

    public static byte[] decode(String data) {
        char[] tdata = new char[data.length()];
        data.getChars(0, data.length(), tdata, 0);
        return Base64.decode(tdata);
    }

    public static char[] encodeAsArray(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = b64code[quad ? val & 0x3F : 64];
            out[index + 2] = b64code[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = b64code[(val >>= 6) & 0x3F];
            out[index + 0] = b64code[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(char[] data) {
        int len = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == '=') {
            --len;
        }
        if (data.length > 1 && data[data.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int ix = 0;
        while (ix < data.length) {
            int value = (data[ix] & 0xFF) == 33 ? 62 : b64icode[data[ix] & 0xFF];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++ix;
        }
        if (index != out.length) {
            throw new RuntimeException("miscalculated data length!");
        }
        return out;
    }

    static {
        int i = 0;
        while (i < 256) {
            Base64.b64icode[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < b64code.length) {
            Base64.b64icode[Base64.b64code[i2]] = (byte)i2;
            ++i2;
        }
        Base64.b64icode[61] = -1;
    }
}

